/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.common.ViewabilityManager;
import com.mopub.common.ViewabilityVendor;
import com.mopub.common.VisibleForTesting;
import com.mopub.mobileads.BaseHtmlWebView;
import com.mopub.mobileads.BaseWebView;
import com.mopub.mobileads.util.WebViews;
import com.mopub.mraid.WebViewDebugListener;
import java.lang.ref.WeakReference;
import java.util.Set;

public abstract class MoPubWebViewController {
    @NonNull
    protected WeakReference<Activity> mWeakActivity;
    @NonNull
    protected final Context mContext;
    @NonNull
    protected final ViewGroup mDefaultAdContainer;
    @Nullable
    protected BaseHtmlWebView.BaseWebViewListener mBaseWebViewListener;
    @Nullable
    protected WebViewDebugListener mDebugListener;
    @Nullable
    protected BaseWebView mWebView;
    @Nullable
    protected String mDspCreativeId;
    protected boolean mIsPaused = true;

    public MoPubWebViewController(@NonNull Context context, @Nullable String dspCreativeId) {
        this.mContext = context.getApplicationContext();
        Preconditions.checkNotNull(this.mContext);
        this.mDspCreativeId = dspCreativeId;
        this.mWeakActivity = context instanceof Activity ? new WeakReference<Activity>((Activity)context) : new WeakReference<Object>(null);
        this.mDefaultAdContainer = new FrameLayout(this.mContext);
    }

    protected abstract BaseWebView createWebView();

    protected abstract void doFillContent(@NonNull String var1);

    public final void fillContent(@NonNull String htmlData, @Nullable Set<ViewabilityVendor> viewabilityVendors, @Nullable WebViewCacheListener listener) {
        Preconditions.checkNotNull(htmlData, "htmlData cannot be null");
        this.mWebView = this.createWebView();
        if (listener != null) {
            listener.onReady(this.mWebView);
        }
        String htmlDataOm = ViewabilityManager.injectVerificationUrlsIntoHtml(htmlData, viewabilityVendors);
        htmlDataOm = ViewabilityManager.injectScriptContentIntoHtml(htmlDataOm);
        this.doFillContent(htmlDataOm);
    }

    protected abstract ViewGroup.LayoutParams getLayoutParams();

    public void loadJavascript(@NonNull String javascript) {
    }

    public void onShow(@NonNull Activity activity) {
        Preconditions.checkNotNull(activity);
        this.mWeakActivity = new WeakReference<Activity>(activity);
    }

    protected void pause(boolean isFinishing) {
        this.mIsPaused = true;
        if (this.mWebView != null) {
            WebViews.onPause(this.mWebView, isFinishing);
        }
    }

    protected void resume() {
        this.mIsPaused = false;
        if (this.mWebView != null) {
            this.mWebView.onResume();
        }
    }

    protected void destroy() {
        if (!this.mIsPaused) {
            this.pause(true);
        }
    }

    @NonNull
    public Context getContext() {
        return this.mContext;
    }

    @NonNull
    WeakReference<Activity> getWeakActivity() {
        return this.mWeakActivity;
    }

    public void setMoPubWebViewListener(@Nullable BaseHtmlWebView.BaseWebViewListener baseWebViewListener) {
        this.mBaseWebViewListener = baseWebViewListener;
    }

    public void setDebugListener(@Nullable WebViewDebugListener debugListener) {
        this.mDebugListener = debugListener;
    }

    @NonNull
    public View getAdContainer() {
        return this.mDefaultAdContainer;
    }

    @VisibleForTesting
    public BaseHtmlWebView.BaseWebViewListener getBaseWebViewListener() {
        return this.mBaseWebViewListener;
    }

    @VisibleForTesting
    public static class ScreenMetricsWaiter {
        @NonNull
        private final Handler mHandler = new Handler();
        @Nullable
        private WaitRequest mLastWaitRequest;

        public WaitRequest waitFor(View ... views) {
            this.mLastWaitRequest = new WaitRequest(this.mHandler, views);
            return this.mLastWaitRequest;
        }

        public void cancelLastRequest() {
            if (this.mLastWaitRequest != null) {
                this.mLastWaitRequest.cancel();
                this.mLastWaitRequest = null;
            }
        }

        public static class WaitRequest {
            @NonNull
            private final View[] mViews;
            @NonNull
            private final Handler mHandler;
            @Nullable
            private Runnable mSuccessRunnable;
            int mWaitCount;
            final Runnable mWaitingRunnable = new Runnable(){

                @Override
                public void run() {
                    for (final View view : mViews) {
                        if (view.getHeight() > 0 || view.getWidth() > 0) {
                            this.countDown();
                            continue;
                        }
                        view.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                            public boolean onPreDraw() {
                                view.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                                this.countDown();
                                return true;
                            }
                        });
                    }
                }
            };

            WaitRequest(@NonNull Handler handler, @NonNull View[] views) {
                this.mHandler = handler;
                this.mViews = views;
            }

            void countDown() {
                --this.mWaitCount;
                if (this.mWaitCount == 0 && this.mSuccessRunnable != null) {
                    this.mSuccessRunnable.run();
                    this.mSuccessRunnable = null;
                }
            }

            public void start(@NonNull Runnable successRunnable) {
                this.mSuccessRunnable = successRunnable;
                this.mWaitCount = this.mViews.length;
                this.mHandler.post(this.mWaitingRunnable);
            }

            void cancel() {
                this.mHandler.removeCallbacks(this.mWaitingRunnable);
                this.mSuccessRunnable = null;
            }
        }
    }

    public static interface WebViewCacheListener {
        public void onReady(BaseWebView var1);
    }
}

