/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.ViewabilityVendor;
import com.mopub.mobileads.util.XmlUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;

class VastAdVerificationsParser {
    private static final String AD_VERIFICATIONS = "AdVerifications";
    private static final String VERIFICATION = "Verification";
    private static final String VENDOR = "vendor";
    private static final String JAVASCRIPT_RESOURCE = "JavaScriptResource";
    private static final String TRACKING_EVENTS = "TrackingEvents";
    private static final String EVENT = "event";
    private static final String VERIFICATION_PARAMETERS = "VerificationParameters";
    private static final String TRACKING = "Tracking";
    private static final String API_FRAMEWORK = "apiFramework";
    private static final String OMID = "omid";
    private static final String VERIFICATION_NOT_EXECUTED = "verificationNotExecuted";
    @NonNull
    private final Set<ViewabilityVendor> viewabilityVendors = new HashSet<ViewabilityVendor>();

    VastAdVerificationsParser(@Nullable Node adVerificationsParent) {
        if (adVerificationsParent != null) {
            this.parse(adVerificationsParent);
        }
    }

    private void parse(@NonNull Node adVerificationParent) {
        Node adVerifications = XmlUtils.getFirstMatchingChildNode(adVerificationParent, AD_VERIFICATIONS);
        List<Node> verificationNodes = XmlUtils.getMatchingChildNodes(adVerifications, VERIFICATION);
        if (verificationNodes == null || verificationNodes.isEmpty()) {
            return;
        }
        for (Node verification : verificationNodes) {
            Node javascriptNode = XmlUtils.getFirstMatchingChildNode(verification, JAVASCRIPT_RESOURCE, API_FRAMEWORK, Collections.singletonList(OMID));
            if (javascriptNode == null) continue;
            Node trackingEventsNode = XmlUtils.getFirstMatchingChildNode(verification, TRACKING_EVENTS);
            Node notExecutedNode = XmlUtils.getFirstMatchingChildNode(trackingEventsNode, TRACKING, EVENT, Collections.singletonList(VERIFICATION_NOT_EXECUTED));
            Node parametersNode = XmlUtils.getFirstMatchingChildNode(verification, VERIFICATION_PARAMETERS);
            String javascriptResource = XmlUtils.getNodeValue(javascriptNode);
            ViewabilityVendor.Builder builder = new ViewabilityVendor.Builder(javascriptResource);
            builder.withApiFramework(OMID).withVendorKey(XmlUtils.getAttributeValue(verification, VENDOR)).withVerificationParameters(XmlUtils.getNodeValue(parametersNode)).withVerificationNotExecuted(XmlUtils.getNodeValue(notExecutedNode));
            ViewabilityVendor viewabilityVendor = builder.build();
            if (viewabilityVendor == null) continue;
            this.viewabilityVendors.add(viewabilityVendor);
        }
    }

    @NonNull
    Set<ViewabilityVendor> getViewabilityVendors() {
        return this.viewabilityVendors;
    }
}

