/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.mobileads.VastInLineXmlManager;
import com.mopub.mobileads.VastWrapperXmlManager;
import com.mopub.mobileads.util.XmlUtils;
import org.w3c.dom.Node;

class VastAdXmlManager {
    private static final String INLINE = "InLine";
    private static final String WRAPPER = "Wrapper";
    private static final String SEQUENCE = "sequence";
    @NonNull
    private final Node mAdNode;

    VastAdXmlManager(@NonNull Node adNode) {
        Preconditions.checkNotNull(adNode);
        this.mAdNode = adNode;
    }

    @Nullable
    VastInLineXmlManager getInLineXmlManager() {
        Node inLineNode = XmlUtils.getFirstMatchingChildNode(this.mAdNode, INLINE);
        VastInLineXmlManager vastInLineXmlManager = null;
        if (inLineNode != null) {
            vastInLineXmlManager = new VastInLineXmlManager(inLineNode);
        }
        return vastInLineXmlManager;
    }

    @Nullable
    VastWrapperXmlManager getWrapperXmlManager() {
        Node wrapperNode = XmlUtils.getFirstMatchingChildNode(this.mAdNode, WRAPPER);
        VastWrapperXmlManager vastWrapperXmlManager = null;
        if (wrapperNode != null) {
            vastWrapperXmlManager = new VastWrapperXmlManager(wrapperNode);
        }
        return vastWrapperXmlManager;
    }

    @Nullable
    String getSequence() {
        return XmlUtils.getAttributeValue(this.mAdNode, SEQUENCE);
    }
}

