/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.VastAbsoluteProgressTracker;
import com.mopub.mobileads.VastResourceXmlManager;
import com.mopub.mobileads.VastTracker;
import com.mopub.mobileads.util.XmlUtils;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

public class VastIconXmlManager {
    public static final String ICON_CLICKS = "IconClicks";
    public static final String ICON_CLICK_TRACKING = "IconClickTracking";
    public static final String ICON_CLICK_THROUGH = "IconClickThrough";
    public static final String ICON_VIEW_TRACKING = "IconViewTracking";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String OFFSET = "offset";
    public static final String DURATION = "duration";
    @NonNull
    private final Node mIconNode;
    @NonNull
    private final VastResourceXmlManager mResourceXmlManager;

    VastIconXmlManager(@NonNull Node iconNode) {
        Preconditions.checkNotNull(iconNode);
        this.mIconNode = iconNode;
        this.mResourceXmlManager = new VastResourceXmlManager(iconNode);
    }

    @Nullable
    Integer getWidth() {
        return XmlUtils.getAttributeValueAsInt(this.mIconNode, WIDTH);
    }

    @Nullable
    Integer getHeight() {
        return XmlUtils.getAttributeValueAsInt(this.mIconNode, HEIGHT);
    }

    @Nullable
    Integer getOffsetMS() {
        String iconOffsetStr = XmlUtils.getAttributeValue(this.mIconNode, OFFSET);
        Integer iconOffset = null;
        try {
            iconOffset = VastAbsoluteProgressTracker.Companion.parseAbsoluteOffset(iconOffsetStr);
        }
        catch (NumberFormatException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, String.format("Invalid VAST icon offset format: %s:", iconOffsetStr));
        }
        return iconOffset;
    }

    @Nullable
    Integer getDurationMS() {
        String iconDurationStr = XmlUtils.getAttributeValue(this.mIconNode, DURATION);
        Integer iconDuration = null;
        try {
            iconDuration = VastAbsoluteProgressTracker.Companion.parseAbsoluteOffset(iconDurationStr);
        }
        catch (NumberFormatException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, String.format("Invalid VAST icon duration format: %s:", iconDurationStr));
        }
        return iconDuration;
    }

    @NonNull
    VastResourceXmlManager getResourceXmlManager() {
        return this.mResourceXmlManager;
    }

    @NonNull
    List<VastTracker> getClickTrackingUris() {
        Node iconClicksNode = XmlUtils.getFirstMatchingChildNode(this.mIconNode, ICON_CLICKS);
        ArrayList<VastTracker> iconClickTrackingUris = new ArrayList<VastTracker>();
        if (iconClicksNode == null) {
            return iconClickTrackingUris;
        }
        List<Node> iconClickTrackingNodes = XmlUtils.getMatchingChildNodes(iconClicksNode, ICON_CLICK_TRACKING);
        for (Node iconClickTrackingNode : iconClickTrackingNodes) {
            String uri = XmlUtils.getNodeValue(iconClickTrackingNode);
            if (uri == null) continue;
            iconClickTrackingUris.add(new VastTracker.Builder(uri).build());
        }
        return iconClickTrackingUris;
    }

    @Nullable
    String getClickThroughUri() {
        Node iconClicksNode = XmlUtils.getFirstMatchingChildNode(this.mIconNode, ICON_CLICKS);
        if (iconClicksNode == null) {
            return null;
        }
        Node iconClickThroughNode = XmlUtils.getFirstMatchingChildNode(iconClicksNode, ICON_CLICK_THROUGH);
        return XmlUtils.getNodeValue(iconClickThroughNode);
    }

    @NonNull
    List<VastTracker> getViewTrackingUris() {
        List<Node> iconViewTrackingNodes = XmlUtils.getMatchingChildNodes(this.mIconNode, ICON_VIEW_TRACKING);
        ArrayList<VastTracker> iconViewTrackingUris = new ArrayList<VastTracker>();
        for (Node iconViewTrackingNode : iconViewTrackingNodes) {
            String uri = XmlUtils.getNodeValue(iconViewTrackingNode);
            if (uri == null) continue;
            iconViewTrackingUris.add(new VastTracker.Builder(uri).build());
        }
        return iconViewTrackingUris;
    }
}

