/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.VastErrorCode;
import com.mopub.mobileads.VastMacro;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class VastMacroHelper {
    @NonNull
    private final List<String> mOriginalUris;
    @NonNull
    private final Map<VastMacro, String> mMacroDataMap;

    public VastMacroHelper(@NonNull List<String> uris) {
        Preconditions.checkNotNull(uris, "uris cannot be null");
        this.mOriginalUris = uris;
        this.mMacroDataMap = new HashMap<VastMacro, String>();
        this.mMacroDataMap.put(VastMacro.CACHEBUSTING, this.getCachebustingString());
    }

    @NonNull
    public List<String> getUris() {
        ArrayList<String> modifiedUris = new ArrayList<String>();
        for (String originalUri : this.mOriginalUris) {
            String modifiedUri = originalUri;
            if (TextUtils.isEmpty((CharSequence)modifiedUri)) continue;
            for (VastMacro vastMacro : VastMacro.values()) {
                String value = this.mMacroDataMap.get((Object)vastMacro);
                if (value == null) {
                    value = "";
                }
                modifiedUri = modifiedUri.replaceAll("\\[" + vastMacro.name() + "\\]", value);
            }
            modifiedUris.add(modifiedUri);
        }
        return modifiedUris;
    }

    @NonNull
    public VastMacroHelper withErrorCode(@Nullable VastErrorCode errorCode) {
        if (errorCode != null) {
            this.mMacroDataMap.put(VastMacro.ERRORCODE, errorCode.getErrorCode());
        }
        return this;
    }

    @NonNull
    public VastMacroHelper withContentPlayHead(@Nullable Integer contentPlayHeadMS) {
        String contentPlayHeadMSStr;
        if (contentPlayHeadMS != null && !TextUtils.isEmpty((CharSequence)(contentPlayHeadMSStr = this.formatContentPlayHead(contentPlayHeadMS)))) {
            this.mMacroDataMap.put(VastMacro.CONTENTPLAYHEAD, contentPlayHeadMSStr);
        }
        return this;
    }

    @NonNull
    public VastMacroHelper withAssetUri(@Nullable String assetUri) {
        if (!TextUtils.isEmpty((CharSequence)assetUri)) {
            try {
                assetUri = URLEncoder.encode(assetUri, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                MoPubLog.log(MoPubLog.SdkLogEvent.ERROR_WITH_THROWABLE, "Failed to encode url", e);
            }
            this.mMacroDataMap.put(VastMacro.ASSETURI, assetUri);
        }
        return this;
    }

    @NonNull
    private String getCachebustingString() {
        return String.format(Locale.US, "%08d", Math.round(Math.random() * 1.0E8));
    }

    @NonNull
    private String formatContentPlayHead(int contentPlayHeadMS) {
        return String.format("%02d:%02d:%02d.%03d", TimeUnit.MILLISECONDS.toHours(contentPlayHeadMS), TimeUnit.MILLISECONDS.toMinutes(contentPlayHeadMS) % TimeUnit.HOURS.toMinutes(1L), TimeUnit.MILLISECONDS.toSeconds(contentPlayHeadMS) % TimeUnit.MINUTES.toSeconds(1L), contentPlayHeadMS % 1000);
    }
}

