/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.text.TextUtils;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.CacheService;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.AsyncTasks;
import com.mopub.mobileads.VastVideoConfig;
import com.mopub.mobileads.VastXmlManagerAggregator;
import com.mopub.mobileads.VideoDownloader;

public class VastManager
implements VastXmlManagerAggregator.VastXmlManagerAggregatorListener {
    @Nullable
    private VastManagerListener mVastManagerListener;
    @Nullable
    private VastXmlManagerAggregator mVastXmlManagerAggregator;
    @Nullable
    private String mDspCreativeId;
    private double mScreenAspectRatio;
    private int mScreenWidthDp;
    private final boolean mShouldPreCacheVideo;

    public VastManager(@NonNull Context context, boolean shouldPreCacheVideo) {
        this.initializeScreenDimensions(context);
        this.mShouldPreCacheVideo = shouldPreCacheVideo;
    }

    public void prepareVastVideoConfiguration(@Nullable String vastXml, @NonNull VastManagerListener vastManagerListener, @Nullable String dspCreativeId, @NonNull Context context) {
        Preconditions.checkNotNull(vastManagerListener, "vastManagerListener cannot be null");
        Preconditions.checkNotNull(context, "context cannot be null");
        if (this.mVastXmlManagerAggregator == null) {
            this.mVastManagerListener = vastManagerListener;
            this.mVastXmlManagerAggregator = new VastXmlManagerAggregator(this, this.mScreenAspectRatio, this.mScreenWidthDp, context.getApplicationContext());
            this.mDspCreativeId = dspCreativeId;
            try {
                AsyncTasks.safeExecuteOnExecutor(this.mVastXmlManagerAggregator, vastXml);
            }
            catch (Exception e) {
                MoPubLog.log(MoPubLog.SdkLogEvent.ERROR_WITH_THROWABLE, "Failed to aggregate vast xml", e);
                this.mVastManagerListener.onVastVideoConfigurationPrepared(null);
            }
        }
    }

    public void cancel() {
        if (this.mVastXmlManagerAggregator != null) {
            this.mVastXmlManagerAggregator.cancel(true);
            this.mVastXmlManagerAggregator = null;
        }
    }

    @Override
    public void onAggregationComplete(final @Nullable VastVideoConfig vastVideoConfig) {
        if (this.mVastManagerListener == null) {
            throw new IllegalStateException("mVastManagerListener cannot be null here. Did you call prepareVastVideoConfiguration()?");
        }
        if (vastVideoConfig == null) {
            this.mVastManagerListener.onVastVideoConfigurationPrepared(null);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mDspCreativeId)) {
            vastVideoConfig.setDspCreativeId(this.mDspCreativeId);
        }
        if (!this.mShouldPreCacheVideo || this.updateDiskMediaFileUrl(vastVideoConfig)) {
            this.mVastManagerListener.onVastVideoConfigurationPrepared(vastVideoConfig);
            return;
        }
        VideoDownloader.VideoDownloaderListener videoDownloaderListener = new VideoDownloader.VideoDownloaderListener(){

            @Override
            public void onComplete(boolean success) {
                if (success && VastManager.this.updateDiskMediaFileUrl(vastVideoConfig)) {
                    VastManager.this.mVastManagerListener.onVastVideoConfigurationPrepared(vastVideoConfig);
                } else {
                    MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Failed to download VAST video.");
                    VastManager.this.mVastManagerListener.onVastVideoConfigurationPrepared(null);
                }
            }
        };
        VideoDownloader.cache(vastVideoConfig.getNetworkMediaFileUrl(), videoDownloaderListener);
    }

    private boolean updateDiskMediaFileUrl(@NonNull VastVideoConfig vastVideoConfig) {
        Preconditions.checkNotNull(vastVideoConfig, "vastVideoConfig cannot be null");
        String networkMediaFileUrl = vastVideoConfig.getNetworkMediaFileUrl();
        if (CacheService.containsKeyDiskCache(networkMediaFileUrl)) {
            String filePathDiskCache = CacheService.getFilePathDiskCache(networkMediaFileUrl);
            vastVideoConfig.setDiskMediaFileUrl(filePathDiskCache);
            return true;
        }
        return false;
    }

    private void initializeScreenDimensions(@NonNull Context context) {
        Preconditions.checkNotNull(context, "context cannot be null");
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        int screenWidth = display.getWidth();
        int screenHeight = display.getHeight();
        float density = context.getResources().getDisplayMetrics().density;
        if (density <= 0.0f) {
            density = 1.0f;
        }
        this.mScreenAspectRatio = (double)screenWidth / (double)screenHeight;
        this.mScreenWidthDp = (int)((float)screenWidth / density);
    }

    @Deprecated
    @VisibleForTesting
    int getScreenWidthDp() {
        return this.mScreenWidthDp;
    }

    @Deprecated
    @VisibleForTesting
    double getScreenAspectRatio() {
        return this.mScreenAspectRatio;
    }

    public static interface VastManagerListener {
        public void onVastVideoConfigurationPrepared(@Nullable VastVideoConfig var1);
    }
}

