/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.mobileads.util.XmlUtils;
import org.w3c.dom.Node;

class VastMediaXmlManager {
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String DELIVERY = "delivery";
    private static final String VIDEO_TYPE = "type";
    private static final String BITRATE = "bitrate";
    private static final String BITRATE_MIN = "minBitrate";
    private static final String BITRATE_MAX = "maxBitrate";
    @NonNull
    private final Node mMediaNode;

    VastMediaXmlManager(@NonNull Node mediaNode) {
        Preconditions.checkNotNull(mediaNode, "mediaNode cannot be null");
        this.mMediaNode = mediaNode;
    }

    @Nullable
    String getDelivery() {
        return XmlUtils.getAttributeValue(this.mMediaNode, DELIVERY);
    }

    @Nullable
    Integer getWidth() {
        return XmlUtils.getAttributeValueAsInt(this.mMediaNode, WIDTH);
    }

    @Nullable
    Integer getHeight() {
        return XmlUtils.getAttributeValueAsInt(this.mMediaNode, HEIGHT);
    }

    @Nullable
    String getType() {
        return XmlUtils.getAttributeValue(this.mMediaNode, VIDEO_TYPE);
    }

    @Nullable
    String getMediaUrl() {
        return XmlUtils.getNodeValue(this.mMediaNode);
    }

    @Nullable
    Integer getBitrate() {
        Integer bitrate = XmlUtils.getAttributeValueAsInt(this.mMediaNode, BITRATE);
        if (bitrate != null) {
            return bitrate;
        }
        Integer minBitrate = XmlUtils.getAttributeValueAsInt(this.mMediaNode, BITRATE_MIN);
        Integer maxBitrate = XmlUtils.getAttributeValueAsInt(this.mMediaNode, BITRATE_MAX);
        if (minBitrate != null && maxBitrate != null) {
            return (minBitrate + maxBitrate) / 2;
        }
        if (minBitrate != null) {
            return minBitrate;
        }
        return maxBitrate;
    }
}

