/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.mopub.common.MoPubBrowser;
import com.mopub.common.UrlAction;
import com.mopub.common.UrlHandler;
import com.mopub.common.ViewabilityVendor;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Intents;
import com.mopub.exceptions.IntentNotResolvableException;
import com.mopub.mobileads.Mockable;
import com.mopub.mobileads.VastAbsoluteProgressTracker;
import com.mopub.mobileads.VastCompanionAdConfig;
import com.mopub.mobileads.VastErrorCode;
import com.mopub.mobileads.VastFractionalProgressTracker;
import com.mopub.mobileads.VastIconConfig;
import com.mopub.mobileads.VastTracker;
import com.mopub.mobileads.VastVideoConfig$WhenMappings;
import com.mopub.mobileads.VideoTrackingEvent;
import com.mopub.mobileads.VideoViewabilityTracker;
import com.mopub.network.TrackingRequest;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Mockable
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 \u00a5\u00012\u00020\u0001:\u0006\u00a5\u0001\u00a6\u0001\u00a7\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010k\u001a\u00020l2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050mH\u0016J\u0016\u0010n\u001a\u00020l2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070mH\u0016J\u0016\u0010o\u001a\u00020l2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070mH\u0016J\u0016\u0010p\u001a\u00020l2\f\u0010q\u001a\b\u0012\u0004\u0012\u00020\u00190mH\u0012J\u0016\u0010r\u001a\u00020l2\f\u0010q\u001a\b\u0012\u0004\u0012\u00020\u00190mH\u0012J\u0016\u0010s\u001a\u00020l2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070mH\u0016J\u0016\u0010t\u001a\u00020l2\f\u0010q\u001a\b\u0012\u0004\u0012\u00020\u00190mH\u0012J\u0016\u0010u\u001a\u00020l2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00070mH\u0016J\u0016\u0010v\u001a\u00020l2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\f0mH\u0016J\u001e\u0010w\u001a\u00020l2\f\u0010q\u001a\b\u0012\u0004\u0012\u00020\u00190m2\u0006\u0010x\u001a\u00020yH\u0012J\u0016\u0010z\u001a\u00020l2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00070mH\u0016J\u0016\u0010{\u001a\u00020l2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00070mH\u0016J\u0016\u0010|\u001a\u00020l2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00070mH\u0016J\u0016\u0010}\u001a\u00020l2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00070mH\u0016J\u0016\u0010~\u001a\u00020l2\f\u0010q\u001a\b\u0012\u0004\u0012\u00020\u00190mH\u0012J\u0014\u0010\u007f\u001a\u00020l2\n\u0010\u0080\u0001\u001a\u0005\u0018\u00010\u0081\u0001H\u0016J\u0019\u0010\u0082\u0001\u001a\u00020l2\u000e\u0010g\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010hH\u0016J\u001d\u0010\u0083\u0001\u001a\b\u0012\u0004\u0012\u00020\u00070m2\f\u0010q\u001a\b\u0012\u0004\u0012\u00020\u00190mH\u0012J\u001a\u0010\u0084\u0001\u001a\u0004\u0018\u00010Q2\u0007\u0010\u0085\u0001\u001a\u00020QH\u0016\u00a2\u0006\u0003\u0010\u0086\u0001J!\u0010\u0087\u0001\u001a\b\u0012\u0004\u0012\u00020\u00070m2\u0007\u0010\u0088\u0001\u001a\u00020Q2\u0007\u0010\u0089\u0001\u001a\u00020QH\u0016J\u0014\u0010\u008a\u0001\u001a\u0004\u0018\u00010C2\u0007\u0010\u008b\u0001\u001a\u00020QH\u0016J-\u0010\u008c\u0001\u001a\u00020l2\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u008f\u0001\u001a\u00020Q2\t\u0010\u0090\u0001\u001a\u0004\u0018\u00010QH\u0012\u00a2\u0006\u0003\u0010\u0091\u0001J%\u0010\u0092\u0001\u001a\u00020l2\b\u0010\u0093\u0001\u001a\u00030\u0094\u00012\u0007\u0010\u008f\u0001\u001a\u00020Q2\u0007\u0010\u0090\u0001\u001a\u00020QH\u0016J\u001c\u0010\u0095\u0001\u001a\u00020l2\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u008f\u0001\u001a\u00020QH\u0016J\u001c\u0010\u0096\u0001\u001a\u00020l2\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u008f\u0001\u001a\u00020QH\u0016J\u001c\u0010\u0097\u0001\u001a\u00020l2\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u008f\u0001\u001a\u00020QH\u0016J(\u0010\u0098\u0001\u001a\u00020l2\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\n\u0010\u0099\u0001\u001a\u0005\u0018\u00010\u009a\u00012\u0007\u0010\u008f\u0001\u001a\u00020QH\u0016J\u001c\u0010\u009b\u0001\u001a\u00020l2\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u008f\u0001\u001a\u00020QH\u0016J\u001c\u0010\u009c\u0001\u001a\u00020l2\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u008f\u0001\u001a\u00020QH\u0016J\u001c\u0010\u009d\u0001\u001a\u00020l2\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u008f\u0001\u001a\u00020QH\u0016J\u001c\u0010\u009e\u0001\u001a\u00020l2\b\u0010\u008d\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u008f\u0001\u001a\u00020QH\u0016J\t\u0010\u009f\u0001\u001a\u000205H\u0016J%\u0010\u00a0\u0001\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010m2\t\u0010\u00a1\u0001\u001a\u0004\u0018\u00010\u00192\u0007\u0010q\u001a\u00030\u00a2\u0001H\u0012J\u001d\u0010\u00a3\u0001\u001a\u00020l2\b\u0010B\u001a\u0004\u0018\u00010C2\b\u0010I\u001a\u0004\u0018\u00010CH\u0016J\t\u0010\u00a4\u0001\u001a\u00020\u0019H\u0016R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00048\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\u0004\u0018\u00010\u00198\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0017R\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0017R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0017R*\u0010%\u001a\u0004\u0018\u00010\u00192\b\u0010$\u001a\u0004\u0018\u00010\u00198\u0016@VX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001b\"\u0004\b'\u0010\u001dR*\u0010(\u001a\u0004\u0018\u00010\u00192\b\u0010$\u001a\u0004\u0018\u00010\u00198\u0016@VX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001b\"\u0004\b*\u0010\u001dR*\u0010+\u001a\u0004\u0018\u00010\u00192\b\u0010$\u001a\u0004\u0018\u00010\u00198\u0016@VX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u001b\"\u0004\b-\u0010\u001dR \u0010.\u001a\u0004\u0018\u00010\u00198\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u001b\"\u0004\b0\u0010\u001dR*\u00101\u001a\u0004\u0018\u00010\u00192\b\u0010$\u001a\u0004\u0018\u00010\u00198\u0016@VX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u001b\"\u0004\b3\u0010\u001dR\u001e\u00104\u001a\u0002058\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001a\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00070\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u0017R\u001a\u0010<\u001a\b\u0012\u0004\u0012\u00020\f0\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u0017R\u001a\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00070\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u0017R\u001e\u0010@\u001a\u0002058\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u00107\"\u0004\bA\u00109R\u0014\u0010B\u001a\u0004\u0018\u00010C8\u0012@\u0012X\u0093\u000e\u00a2\u0006\u0002\n\u0000R \u0010D\u001a\u0004\u0018\u00010\u00198\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\u001b\"\u0004\bF\u0010\u001dR\u001a\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00070\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u0017R\u0014\u0010I\u001a\u0004\u0018\u00010C8\u0012@\u0012X\u0093\u000e\u00a2\u0006\u0002\n\u0000R \u0010J\u001a\u0004\u0018\u00010\u00198\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010\u001b\"\u0004\bL\u0010\u001dR*\u0010M\u001a\u0004\u0018\u00010\u00192\b\u0010$\u001a\u0004\u0018\u00010\u00198\u0016@VX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010\u001b\"\u0004\bO\u0010\u001dR\u0014\u0010P\u001a\u00020Q8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010SR\u001a\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00070\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bU\u0010\u0017R \u0010V\u001a\u0004\u0018\u00010\u00198\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010\u001b\"\u0004\bX\u0010\u001dR\u001a\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00070\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bZ\u0010\u0017R \u0010[\u001a\u0004\u0018\u00010\\8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010^\"\u0004\b_\u0010`R*\u0010b\u001a\u0004\u0018\u00010a2\b\u0010$\u001a\u0004\u0018\u00010a8\u0016@VX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u0010d\"\u0004\be\u0010fR\u001a\u0010g\u001a\b\u0012\u0004\u0012\u00020\u00130h8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bi\u0010j\u00a8\u0006\u00a8\u0001"}, d2={"Lcom/mopub/mobileads/VastVideoConfig;", "Ljava/io/Serializable;", "()V", "_absoluteTrackers", "", "Lcom/mopub/mobileads/VastAbsoluteProgressTracker;", "_clickTrackers", "Lcom/mopub/mobileads/VastTracker;", "_closeTrackers", "_completeTrackers", "_errorTrackers", "_fractionalTrackers", "Lcom/mopub/mobileads/VastFractionalProgressTracker;", "_impressionTrackers", "_pauseTrackers", "_resumeTrackers", "_skipTrackers", "_viewabilityVendors", "", "Lcom/mopub/common/ViewabilityVendor;", "absoluteTrackers", "Ljava/util/ArrayList;", "getAbsoluteTrackers", "()Ljava/util/ArrayList;", "clickThroughUrl", "", "getClickThroughUrl", "()Ljava/lang/String;", "setClickThroughUrl", "(Ljava/lang/String;)V", "clickTrackers", "getClickTrackers", "closeTrackers", "getCloseTrackers", "completeTrackers", "getCompleteTrackers", "value", "customCloseIconUrl", "getCustomCloseIconUrl", "setCustomCloseIconUrl", "customCtaText", "getCustomCtaText", "setCustomCtaText", "customSkipText", "getCustomSkipText", "setCustomSkipText", "diskMediaFileUrl", "getDiskMediaFileUrl", "setDiskMediaFileUrl", "dspCreativeId", "getDspCreativeId", "setDspCreativeId", "enableClickExperiment", "", "getEnableClickExperiment", "()Z", "setEnableClickExperiment", "(Z)V", "errorTrackers", "getErrorTrackers", "fractionalTrackers", "getFractionalTrackers", "impressionTrackers", "getImpressionTrackers", "isRewarded", "setRewarded", "landscapeVastCompanionAdConfig", "Lcom/mopub/mobileads/VastCompanionAdConfig;", "networkMediaFileUrl", "getNetworkMediaFileUrl", "setNetworkMediaFileUrl", "pauseTrackers", "getPauseTrackers", "portraitVastCompanionAdConfig", "privacyInformationIconClickthroughUrl", "getPrivacyInformationIconClickthroughUrl", "setPrivacyInformationIconClickthroughUrl", "privacyInformationIconImageUrl", "getPrivacyInformationIconImageUrl", "setPrivacyInformationIconImageUrl", "remainingProgressTrackerCount", "", "getRemainingProgressTrackerCount", "()I", "resumeTrackers", "getResumeTrackers", "skipOffset", "getSkipOffset", "setSkipOffset", "skipTrackers", "getSkipTrackers", "vastIconConfig", "Lcom/mopub/mobileads/VastIconConfig;", "getVastIconConfig", "()Lcom/mopub/mobileads/VastIconConfig;", "setVastIconConfig", "(Lcom/mopub/mobileads/VastIconConfig;)V", "Lcom/mopub/mobileads/VideoViewabilityTracker;", "videoViewabilityTracker", "getVideoViewabilityTracker", "()Lcom/mopub/mobileads/VideoViewabilityTracker;", "setVideoViewabilityTracker", "(Lcom/mopub/mobileads/VideoViewabilityTracker;)V", "viewabilityVendors", "", "getViewabilityVendors", "()Ljava/util/Set;", "addAbsoluteTrackers", "", "", "addClickTrackers", "addCloseTrackers", "addCompanionAdClickTrackersForUrls", "urls", "addCompanionAdViewTrackersForUrls", "addCompleteTrackers", "addCompleteTrackersForUrls", "addErrorTrackers", "addFractionalTrackers", "addFractionalTrackersForUrls", "fraction", "", "addImpressionTrackers", "addPauseTrackers", "addResumeTrackers", "addSkipTrackers", "addStartTrackersForUrls", "addVideoTrackers", "videoTrackers", "Lorg/json/JSONObject;", "addViewabilityVendors", "createVastTrackersForUrls", "getSkipOffsetMillis", "videoDuration", "(I)Ljava/lang/Integer;", "getUntriggeredTrackersBefore", "currentPositionMillis", "videoLengthMillis", "getVastCompanionAd", "orientation", "handleClick", "context", "Landroid/content/Context;", "contentPlayHead", "requestCode", "(Landroid/content/Context;ILjava/lang/Integer;)V", "handleClickForResult", "activity", "Landroid/app/Activity;", "handleClickWithoutResult", "handleClose", "handleComplete", "handleError", "errorCode", "Lcom/mopub/mobileads/VastErrorCode;", "handleImpression", "handlePause", "handleResume", "handleSkip", "hasCompanionAd", "hydrateUrls", "event", "Lorg/json/JSONArray;", "setVastCompanionAd", "toJsonString", "Companion", "VastVideoConfigTypeAdapter", "VastVideoConfigTypeAdapterFactory", "mopub-sdk-base_release"})
public class VastVideoConfig
implements Serializable {
    @Expose
    @SerializedName(value="impression_trackers")
    private final List<VastTracker> _impressionTrackers;
    @Expose
    @SerializedName(value="pause_trackers")
    private final List<VastTracker> _pauseTrackers;
    @Expose
    @SerializedName(value="resume_trackers")
    private final List<VastTracker> _resumeTrackers;
    @Expose
    @SerializedName(value="complete_trackers")
    private final List<VastTracker> _completeTrackers;
    @Expose
    @SerializedName(value="close_trackers")
    private final List<VastTracker> _closeTrackers;
    @Expose
    @SerializedName(value="skip_trackers")
    private final List<VastTracker> _skipTrackers;
    @Expose
    @SerializedName(value="click_trackers")
    private final List<VastTracker> _clickTrackers;
    @Expose
    @SerializedName(value="error_trackers")
    private final List<VastTracker> _errorTrackers;
    @Expose
    @SerializedName(value="fractional_trackers")
    private final List<VastFractionalProgressTracker> _fractionalTrackers;
    @Expose
    @SerializedName(value="absolute_trackers")
    private final List<VastAbsoluteProgressTracker> _absoluteTrackers;
    @Expose
    @SerializedName(value="viewability-verification-resources")
    private final Set<ViewabilityVendor> _viewabilityVendors;
    @SerializedName(value="clickthrough_url")
    @Nullable
    private String clickThroughUrl;
    @Expose
    @SerializedName(value="network_media_file_url")
    @Nullable
    private String networkMediaFileUrl;
    @Expose
    @SerializedName(value="disk_media_file_url")
    @Nullable
    private String diskMediaFileUrl;
    @Expose
    @SerializedName(value="skip_offset")
    @Nullable
    private String skipOffset;
    @Expose
    @SerializedName(value="landscape_companion_ad")
    private VastCompanionAdConfig landscapeVastCompanionAdConfig;
    @Expose
    @SerializedName(value="portrait_companion_ad")
    private VastCompanionAdConfig portraitVastCompanionAdConfig;
    @Expose
    @SerializedName(value="icon_config")
    @Nullable
    private VastIconConfig vastIconConfig;
    @Expose
    @SerializedName(value="is_rewarded")
    private boolean isRewarded;
    @Expose
    @SerializedName(value="enable_click_exp")
    private boolean enableClickExperiment;
    @Expose
    @SerializedName(value="custom_cta_text")
    @Nullable
    private String customCtaText;
    @Expose
    @SerializedName(value="custom_skip_text")
    @Nullable
    private String customSkipText;
    @Expose
    @SerializedName(value="custom_close_icon_url")
    @Nullable
    private String customCloseIconUrl;
    @Expose
    @SerializedName(value="video_viewability_tracker")
    @Nullable
    private VideoViewabilityTracker videoViewabilityTracker;
    @Expose
    @SerializedName(value="dsp_creative_id")
    @Nullable
    private String dspCreativeId;
    @Expose
    @SerializedName(value="privacy_icon_image_url")
    @Nullable
    private String privacyInformationIconImageUrl;
    @Expose
    @SerializedName(value="privacy_icon_click_url")
    @Nullable
    private String privacyInformationIconClickthroughUrl;
    private static final long serialVersionUID = 3L;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ArrayList<VastTracker> getImpressionTrackers() {
        return new ArrayList<VastTracker>((Collection)this._impressionTrackers);
    }

    @NotNull
    public ArrayList<VastTracker> getPauseTrackers() {
        return new ArrayList<VastTracker>((Collection)this._pauseTrackers);
    }

    @NotNull
    public ArrayList<VastTracker> getResumeTrackers() {
        return new ArrayList<VastTracker>((Collection)this._resumeTrackers);
    }

    @NotNull
    public ArrayList<VastTracker> getCompleteTrackers() {
        return new ArrayList<VastTracker>((Collection)this._completeTrackers);
    }

    @NotNull
    public ArrayList<VastTracker> getCloseTrackers() {
        return new ArrayList<VastTracker>((Collection)this._closeTrackers);
    }

    @NotNull
    public ArrayList<VastTracker> getSkipTrackers() {
        return new ArrayList<VastTracker>((Collection)this._skipTrackers);
    }

    @NotNull
    public ArrayList<VastTracker> getClickTrackers() {
        return new ArrayList<VastTracker>((Collection)this._clickTrackers);
    }

    @NotNull
    public ArrayList<VastTracker> getErrorTrackers() {
        return new ArrayList<VastTracker>((Collection)this._errorTrackers);
    }

    @NotNull
    public ArrayList<VastFractionalProgressTracker> getFractionalTrackers() {
        return new ArrayList<VastFractionalProgressTracker>((Collection)this._fractionalTrackers);
    }

    @NotNull
    public ArrayList<VastAbsoluteProgressTracker> getAbsoluteTrackers() {
        return new ArrayList<VastAbsoluteProgressTracker>((Collection)this._absoluteTrackers);
    }

    @NotNull
    public Set<ViewabilityVendor> getViewabilityVendors() {
        return new HashSet(this._viewabilityVendors);
    }

    @Nullable
    public String getClickThroughUrl() {
        return this.clickThroughUrl;
    }

    public void setClickThroughUrl(@Nullable String string) {
        this.clickThroughUrl = string;
    }

    @Nullable
    public String getNetworkMediaFileUrl() {
        return this.networkMediaFileUrl;
    }

    public void setNetworkMediaFileUrl(@Nullable String string) {
        this.networkMediaFileUrl = string;
    }

    @Nullable
    public String getDiskMediaFileUrl() {
        return this.diskMediaFileUrl;
    }

    public void setDiskMediaFileUrl(@Nullable String string) {
        this.diskMediaFileUrl = string;
    }

    @Nullable
    public String getSkipOffset() {
        return this.skipOffset;
    }

    public void setSkipOffset(@Nullable String string) {
        this.skipOffset = string;
    }

    @Nullable
    public VastIconConfig getVastIconConfig() {
        return this.vastIconConfig;
    }

    public void setVastIconConfig(@Nullable VastIconConfig vastIconConfig) {
        this.vastIconConfig = vastIconConfig;
    }

    public boolean isRewarded() {
        return this.isRewarded;
    }

    public void setRewarded(boolean bl) {
        this.isRewarded = bl;
    }

    public boolean getEnableClickExperiment() {
        return this.enableClickExperiment;
    }

    public void setEnableClickExperiment(boolean bl) {
        this.enableClickExperiment = bl;
    }

    @Nullable
    public String getCustomCtaText() {
        return this.customCtaText;
    }

    public void setCustomCtaText(@Nullable String value) {
        String string = value;
        if (string == null) {
            string = this.customCtaText;
        }
        this.customCtaText = string;
    }

    @Nullable
    public String getCustomSkipText() {
        return this.customSkipText;
    }

    public void setCustomSkipText(@Nullable String value) {
        String string = value;
        if (string == null) {
            string = this.customSkipText;
        }
        this.customSkipText = string;
    }

    @Nullable
    public String getCustomCloseIconUrl() {
        return this.customCloseIconUrl;
    }

    public void setCustomCloseIconUrl(@Nullable String value) {
        String string = value;
        if (string == null) {
            string = this.customCloseIconUrl;
        }
        this.customCloseIconUrl = string;
    }

    @Nullable
    public VideoViewabilityTracker getVideoViewabilityTracker() {
        return this.videoViewabilityTracker;
    }

    public void setVideoViewabilityTracker(@Nullable VideoViewabilityTracker value) {
        VideoViewabilityTracker videoViewabilityTracker = value;
        if (videoViewabilityTracker == null) {
            videoViewabilityTracker = this.videoViewabilityTracker;
        }
        this.videoViewabilityTracker = videoViewabilityTracker;
    }

    @Nullable
    public String getDspCreativeId() {
        return this.dspCreativeId;
    }

    public void setDspCreativeId(@Nullable String value) {
        String string = value;
        if (string == null) {
            string = this.dspCreativeId;
        }
        this.dspCreativeId = string;
    }

    @Nullable
    public String getPrivacyInformationIconImageUrl() {
        return this.privacyInformationIconImageUrl;
    }

    public void setPrivacyInformationIconImageUrl(@Nullable String value) {
        String string = value;
        if (string == null) {
            string = this.privacyInformationIconImageUrl;
        }
        this.privacyInformationIconImageUrl = string;
    }

    @Nullable
    public String getPrivacyInformationIconClickthroughUrl() {
        return this.privacyInformationIconClickthroughUrl;
    }

    public void setPrivacyInformationIconClickthroughUrl(@Nullable String string) {
        this.privacyInformationIconClickthroughUrl = string;
    }

    public void addImpressionTrackers(@NotNull List<? extends VastTracker> impressionTrackers) {
        Intrinsics.checkParameterIsNotNull(impressionTrackers, (String)"impressionTrackers");
        this._impressionTrackers.addAll((Collection<VastTracker>)impressionTrackers);
    }

    public void addResumeTrackers(@NotNull List<? extends VastTracker> resumeTrackers) {
        Intrinsics.checkParameterIsNotNull(resumeTrackers, (String)"resumeTrackers");
        this._resumeTrackers.addAll((Collection<VastTracker>)resumeTrackers);
    }

    public void addFractionalTrackers(@NotNull List<VastFractionalProgressTracker> fractionalTrackers) {
        Intrinsics.checkParameterIsNotNull(fractionalTrackers, (String)"fractionalTrackers");
        this._fractionalTrackers.addAll((Collection<VastFractionalProgressTracker>)fractionalTrackers);
        CollectionsKt.sort(this._fractionalTrackers);
    }

    public void addAbsoluteTrackers(@NotNull List<? extends VastAbsoluteProgressTracker> absoluteTrackers) {
        Intrinsics.checkParameterIsNotNull(absoluteTrackers, (String)"absoluteTrackers");
        this._absoluteTrackers.addAll((Collection<VastAbsoluteProgressTracker>)absoluteTrackers);
        CollectionsKt.sort(this._absoluteTrackers);
    }

    public void addCompleteTrackers(@NotNull List<? extends VastTracker> completeTrackers) {
        Intrinsics.checkParameterIsNotNull(completeTrackers, (String)"completeTrackers");
        this._completeTrackers.addAll((Collection<VastTracker>)completeTrackers);
    }

    public void addPauseTrackers(@NotNull List<? extends VastTracker> pauseTrackers) {
        Intrinsics.checkParameterIsNotNull(pauseTrackers, (String)"pauseTrackers");
        this._pauseTrackers.addAll((Collection<VastTracker>)pauseTrackers);
    }

    public void addCloseTrackers(@NotNull List<? extends VastTracker> closeTrackers) {
        Intrinsics.checkParameterIsNotNull(closeTrackers, (String)"closeTrackers");
        this._closeTrackers.addAll((Collection<VastTracker>)closeTrackers);
    }

    public void addSkipTrackers(@NotNull List<? extends VastTracker> skipTrackers) {
        Intrinsics.checkParameterIsNotNull(skipTrackers, (String)"skipTrackers");
        this._skipTrackers.addAll((Collection<VastTracker>)skipTrackers);
    }

    public void addClickTrackers(@NotNull List<? extends VastTracker> clickTrackers) {
        Intrinsics.checkParameterIsNotNull(clickTrackers, (String)"clickTrackers");
        this._clickTrackers.addAll((Collection<VastTracker>)clickTrackers);
    }

    public void addErrorTrackers(@NotNull List<? extends VastTracker> errorTrackers) {
        Intrinsics.checkParameterIsNotNull(errorTrackers, (String)"errorTrackers");
        this._errorTrackers.addAll((Collection<VastTracker>)errorTrackers);
    }

    public void addViewabilityVendors(@Nullable Set<? extends ViewabilityVendor> viewabilityVendors) {
        block0: {
            Set<? extends ViewabilityVendor> set = viewabilityVendors;
            if (set == null) break block0;
            Set<? extends ViewabilityVendor> set2 = set;
            boolean bl = false;
            boolean bl2 = false;
            Set<? extends ViewabilityVendor> it = set2;
            boolean bl3 = false;
            this._viewabilityVendors.addAll((Collection<ViewabilityVendor>)it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addVideoTrackers(@Nullable JSONObject videoTrackers) {
        if (videoTrackers == null) {
            return;
        }
        JSONArray urls = videoTrackers.optJSONArray("urls");
        JSONArray events = videoTrackers.optJSONArray("events");
        if (urls == null || events == null) {
            return;
        }
        int n = 0;
        int n2 = events.length();
        while (n < n2) {
            void i;
            String eventName = events.optString((int)i);
            List<String> urlsForEvent = this.hydrateUrls(eventName, urls);
            VideoTrackingEvent event = VideoTrackingEvent.Companion.fromString(eventName);
            if (eventName != null && urlsForEvent != null) {
                switch (VastVideoConfig$WhenMappings.$EnumSwitchMapping$0[event.ordinal()]) {
                    case 1: {
                        this.addStartTrackersForUrls(urlsForEvent);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        this.addFractionalTrackersForUrls(urlsForEvent, event.toFloat());
                        break;
                    }
                    case 5: {
                        this.addCompleteTrackersForUrls(urlsForEvent);
                        break;
                    }
                    case 6: {
                        this.addCompanionAdViewTrackersForUrls(urlsForEvent);
                        break;
                    }
                    case 7: {
                        this.addCompanionAdClickTrackersForUrls(urlsForEvent);
                        break;
                    }
                    default: {
                        MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Encountered unknown video tracking event: " + eventName);
                    }
                }
            }
            ++i;
        }
    }

    public void setVastCompanionAd(@Nullable VastCompanionAdConfig landscapeVastCompanionAdConfig, @Nullable VastCompanionAdConfig portraitVastCompanionAdConfig) {
        this.landscapeVastCompanionAdConfig = landscapeVastCompanionAdConfig;
        this.portraitVastCompanionAdConfig = portraitVastCompanionAdConfig;
    }

    @Nullable
    public VastCompanionAdConfig getVastCompanionAd(int orientation) {
        VastCompanionAdConfig vastCompanionAdConfig;
        switch (orientation) {
            case 1: {
                vastCompanionAdConfig = this.portraitVastCompanionAdConfig;
                break;
            }
            case 2: {
                vastCompanionAdConfig = this.landscapeVastCompanionAdConfig;
                break;
            }
            default: {
                vastCompanionAdConfig = this.landscapeVastCompanionAdConfig;
            }
        }
        return vastCompanionAdConfig;
    }

    public boolean hasCompanionAd() {
        return this.landscapeVastCompanionAdConfig != null && this.portraitVastCompanionAdConfig != null;
    }

    public void handleImpression(@NotNull Context context, int contentPlayHead) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        TrackingRequest.makeVastTrackingHttpRequest(this._impressionTrackers, null, contentPlayHead, this.getNetworkMediaFileUrl(), context);
    }

    public void handleClickForResult(@NotNull Activity activity, int contentPlayHead, int requestCode) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        this.handleClick((Context)activity, contentPlayHead, requestCode);
    }

    public void handleClickWithoutResult(@NotNull Context context, int contentPlayHead) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        this.handleClick(context2, contentPlayHead, null);
    }

    private void handleClick(Context context, int contentPlayHead, Integer requestCode) {
        block1: {
            TrackingRequest.makeVastTrackingHttpRequest(this._clickTrackers, null, contentPlayHead, this.getNetworkMediaFileUrl(), context);
            CharSequence charSequence = this.getClickThroughUrl();
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                return;
            }
            UrlHandler urlHandler2 = new UrlHandler.Builder().withDspCreativeId(this.getDspCreativeId()).withoutMoPubBrowser().withSupportedUrlActions(UrlAction.IGNORE_ABOUT_SCHEME, UrlAction.OPEN_APP_MARKET, UrlAction.OPEN_NATIVE_BROWSER, UrlAction.OPEN_IN_APP_BROWSER, UrlAction.HANDLE_SHARE_TWEET, UrlAction.FOLLOW_DEEP_LINK_WITH_FALLBACK, UrlAction.FOLLOW_DEEP_LINK).withResultActions(new UrlHandler.ResultActions(this, context, requestCode){
                final /* synthetic */ VastVideoConfig this$0;
                final /* synthetic */ Context $context;
                final /* synthetic */ Integer $requestCode;

                public void urlHandlingSucceeded(@NotNull String url, @NotNull UrlAction urlAction) {
                    Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                    Intrinsics.checkParameterIsNotNull((Object)((Object)urlAction), (String)"urlAction");
                    if (urlAction == UrlAction.OPEN_IN_APP_BROWSER) {
                        Bundle bundle;
                        Bundle bundle2 = bundle = new Bundle();
                        boolean bl = false;
                        boolean bl2 = false;
                        Bundle $this$run = bundle2;
                        boolean bl3 = false;
                        $this$run.putString("URL", url);
                        $this$run.putString("mopub-dsp-creative-id", this.this$0.getDspCreativeId());
                        Class<MoPubBrowser> clazz = MoPubBrowser.class;
                        Intent intent = Intents.getStartActivityIntent(this.$context, clazz, bundle);
                        try {
                            if (this.$context instanceof Activity) {
                                Integer n = this.$requestCode;
                                boolean bl4 = false;
                                boolean bl5 = false;
                                if (n == null) {
                                    boolean bl6 = false;
                                    String string = "Activity context requires a requestCode";
                                    throw (Throwable)new IllegalArgumentException(string.toString());
                                }
                                ((Activity)this.$context).startActivityForResult(intent, this.$requestCode.intValue());
                            } else {
                                Intents.startActivity(this.$context, intent);
                            }
                        }
                        catch (ActivityNotFoundException e) {
                            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Activity " + clazz.getName() + " not found. Did you declare " + "it in your AndroidManifest.xml?");
                        }
                        catch (IntentNotResolvableException e) {
                            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Activity " + clazz.getName() + " not found. Did you declare " + "it in your AndroidManifest.xml?");
                        }
                    }
                }

                public void urlHandlingFailed(@NotNull String url, @NotNull UrlAction lastFailedUrlAction) {
                    Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                    Intrinsics.checkParameterIsNotNull((Object)((Object)lastFailedUrlAction), (String)"lastFailedUrlAction");
                }
                {
                    this.this$0 = $outer;
                    this.$context = $captured_local_variable$1;
                    this.$requestCode = $captured_local_variable$2;
                }
            }).build();
            String string = this.getClickThroughUrl();
            if (string == null) break block1;
            String string2 = string;
            bl2 = false;
            boolean bl3 = false;
            String it = string2;
            boolean bl4 = false;
            urlHandler2.handleUrl(context, it);
        }
    }

    public void handleResume(@NotNull Context context, int contentPlayHead) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        TrackingRequest.makeVastTrackingHttpRequest(this._resumeTrackers, null, contentPlayHead, this.getNetworkMediaFileUrl(), context);
    }

    public void handlePause(@NotNull Context context, int contentPlayHead) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        TrackingRequest.makeVastTrackingHttpRequest(this._pauseTrackers, null, contentPlayHead, this.getNetworkMediaFileUrl(), context);
    }

    public void handleClose(@NotNull Context context, int contentPlayHead) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        TrackingRequest.makeVastTrackingHttpRequest(this._closeTrackers, null, contentPlayHead, this.getNetworkMediaFileUrl(), context);
    }

    public void handleSkip(@NotNull Context context, int contentPlayHead) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        TrackingRequest.makeVastTrackingHttpRequest(this._skipTrackers, null, contentPlayHead, this.getNetworkMediaFileUrl(), context);
    }

    public void handleComplete(@NotNull Context context, int contentPlayHead) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        TrackingRequest.makeVastTrackingHttpRequest(this._completeTrackers, null, contentPlayHead, this.getNetworkMediaFileUrl(), context);
    }

    public void handleError(@NotNull Context context, @Nullable VastErrorCode errorCode, int contentPlayHead) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        TrackingRequest.makeVastTrackingHttpRequest(this._errorTrackers, errorCode, contentPlayHead, this.getNetworkMediaFileUrl(), context);
    }

    @NotNull
    public List<VastTracker> getUntriggeredTrackersBefore(int currentPositionMillis, int videoLengthMillis) {
        if (videoLengthMillis <= 0 || currentPositionMillis < 0) {
            return CollectionsKt.emptyList();
        }
        ArrayList<VastTracker> arrayList = new ArrayList<VastTracker>();
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<VastTracker> it = arrayList;
        boolean bl3 = false;
        VastAbsoluteProgressTracker absoluteTest = new VastAbsoluteProgressTracker.Builder("", currentPositionMillis).build();
        Iterable $this$forEach$iv = this._absoluteTrackers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VastAbsoluteProgressTracker tracker = (VastAbsoluteProgressTracker)element$iv;
            boolean bl4 = false;
            if (tracker.compareTo(absoluteTest) > 0 || tracker.isTracked()) continue;
            it.add(tracker);
        }
        VastFractionalProgressTracker fractionalTest = new VastFractionalProgressTracker.Builder("", (float)currentPositionMillis / (float)videoLengthMillis).build();
        Iterable $this$forEach$iv2 = this._fractionalTrackers;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            VastFractionalProgressTracker tracker = (VastFractionalProgressTracker)element$iv;
            boolean bl5 = false;
            if (tracker.compareTo(fractionalTest) > 0 || tracker.isTracked()) continue;
            it.add(tracker);
        }
        return arrayList;
    }

    public int getRemainingProgressTrackerCount() {
        return this.getUntriggeredTrackersBefore(Integer.MAX_VALUE, Integer.MAX_VALUE).size();
    }

    @Nullable
    public Integer getSkipOffsetMillis(int videoDuration) throws NumberFormatException {
        Integer n;
        String string = this.getSkipOffset();
        if (string != null) {
            Integer n2;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            if (VastAbsoluteProgressTracker.Companion.isAbsoluteTracker(it)) {
                n2 = VastAbsoluteProgressTracker.Companion.parseAbsoluteOffset(it);
            } else if (VastFractionalProgressTracker.Companion.isPercentageTracker(it)) {
                n2 = VastFractionalProgressTracker.Companion.parsePercentageOffset(it, videoDuration);
            } else {
                MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Invalid VAST skipoffset format: " + it);
                n2 = null;
            }
            if (n2 != null) {
                Integer n3 = n2;
                boolean bl4 = false;
                boolean bl5 = false;
                int skipMs = ((Number)n3).intValue();
                boolean bl6 = false;
                int n4 = videoDuration;
                boolean bl7 = false;
                n = Math.min(skipMs, n4);
            } else {
                n = null;
            }
        } else {
            n = null;
        }
        return n;
    }

    @NotNull
    public String toJsonString() {
        Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new VastVideoConfigTypeAdapterFactory()).create();
        String string = gson.toJson((Object)this);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gson.toJson(this@VastVideoConfig)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> hydrateUrls(String event, JSONArray urls) {
        if (event == null) {
            return null;
        }
        List hydratedUrls = new ArrayList();
        int n = 0;
        int n2 = urls.length();
        while (n < n2) {
            void i;
            if (urls.optString((int)i) == null) {
            } else {
                String url;
                hydratedUrls.add(StringsKt.replace$default((String)url, (String)"%%VIDEO_EVENT%%", (String)event, (boolean)false, (int)4, null));
            }
            ++i;
        }
        return hydratedUrls;
    }

    /*
     * WARNING - void declaration
     */
    private List<VastTracker> createVastTrackersForUrls(List<String> urls) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = urls;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            VastTracker vastTracker = new VastTracker.Builder((String)it).build();
            collection.add(vastTracker);
        }
        return (List)destination$iv$iv;
    }

    private void addCompleteTrackersForUrls(List<String> urls) {
        this.addCompleteTrackers(this.createVastTrackersForUrls(urls));
    }

    /*
     * WARNING - void declaration
     */
    private void addStartTrackersForUrls(List<String> urls) {
        Collection<VastAbsoluteProgressTracker> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = urls;
        VastVideoConfig vastVideoConfig = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            VastAbsoluteProgressTracker vastAbsoluteProgressTracker = new VastAbsoluteProgressTracker.Builder((String)it, 0).build();
            collection.add(vastAbsoluteProgressTracker);
        }
        collection = (List)destination$iv$iv;
        vastVideoConfig.addAbsoluteTrackers((List<? extends VastAbsoluteProgressTracker>)collection);
    }

    /*
     * WARNING - void declaration
     */
    private void addFractionalTrackersForUrls(List<String> urls, float fraction) {
        Collection<VastFractionalProgressTracker> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = urls;
        VastVideoConfig vastVideoConfig = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            VastFractionalProgressTracker vastFractionalProgressTracker = new VastFractionalProgressTracker.Builder((String)it, fraction).build();
            collection.add(vastFractionalProgressTracker);
        }
        collection = (List)destination$iv$iv;
        vastVideoConfig.addFractionalTrackers((List<VastFractionalProgressTracker>)collection);
    }

    private void addCompanionAdViewTrackersForUrls(List<String> urls) {
        block1: {
            List<VastTracker> companionAdViewTrackers = this.createVastTrackersForUrls(urls);
            VastCompanionAdConfig vastCompanionAdConfig = this.landscapeVastCompanionAdConfig;
            if (vastCompanionAdConfig != null) {
                vastCompanionAdConfig.addCreativeViewTrackers((Collection<? extends VastTracker>)companionAdViewTrackers);
            }
            VastCompanionAdConfig vastCompanionAdConfig2 = this.portraitVastCompanionAdConfig;
            if (vastCompanionAdConfig2 == null) break block1;
            vastCompanionAdConfig2.addCreativeViewTrackers((Collection<? extends VastTracker>)companionAdViewTrackers);
        }
    }

    private void addCompanionAdClickTrackersForUrls(List<String> urls) {
        block1: {
            List<VastTracker> companionAdClickTrackers = this.createVastTrackersForUrls(urls);
            VastCompanionAdConfig vastCompanionAdConfig = this.landscapeVastCompanionAdConfig;
            if (vastCompanionAdConfig != null) {
                vastCompanionAdConfig.addClickTrackers((Collection<? extends VastTracker>)companionAdClickTrackers);
            }
            VastCompanionAdConfig vastCompanionAdConfig2 = this.portraitVastCompanionAdConfig;
            if (vastCompanionAdConfig2 == null) break block1;
            vastCompanionAdConfig2.addClickTrackers((Collection<? extends VastTracker>)companionAdClickTrackers);
        }
    }

    public VastVideoConfig() {
        Collection collection;
        VastVideoConfig vastVideoConfig = this;
        boolean bl = false;
        vastVideoConfig._impressionTrackers = collection = (List)new ArrayList();
        vastVideoConfig = this;
        bl = false;
        vastVideoConfig._pauseTrackers = collection = (List)new ArrayList();
        vastVideoConfig = this;
        bl = false;
        vastVideoConfig._resumeTrackers = collection = (List)new ArrayList();
        vastVideoConfig = this;
        bl = false;
        vastVideoConfig._completeTrackers = collection = (List)new ArrayList();
        vastVideoConfig = this;
        bl = false;
        vastVideoConfig._closeTrackers = collection = (List)new ArrayList();
        vastVideoConfig = this;
        bl = false;
        vastVideoConfig._skipTrackers = collection = (List)new ArrayList();
        vastVideoConfig = this;
        bl = false;
        vastVideoConfig._clickTrackers = collection = (List)new ArrayList();
        vastVideoConfig = this;
        bl = false;
        vastVideoConfig._errorTrackers = collection = (List)new ArrayList();
        vastVideoConfig = this;
        bl = false;
        vastVideoConfig._fractionalTrackers = collection = (List)new ArrayList();
        vastVideoConfig = this;
        bl = false;
        vastVideoConfig._absoluteTrackers = collection = (List)new ArrayList();
        vastVideoConfig = this;
        bl = false;
        collection = new LinkedHashSet();
        vastVideoConfig._viewabilityVendors = collection;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\u0004\"\u0004\b\u0000\u0010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/mopub/mobileads/VastVideoConfig$VastVideoConfigTypeAdapterFactory;", "Lcom/google/gson/TypeAdapterFactory;", "()V", "create", "Lcom/google/gson/TypeAdapter;", "T", "gson", "Lcom/google/gson/Gson;", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "mopub-sdk-base_release"})
    private static final class VastVideoConfigTypeAdapterFactory
    implements TypeAdapterFactory {
        @Nullable
        public <T> TypeAdapter<T> create(@Nullable Gson gson, @Nullable TypeToken<T> typeToken) {
            return typeToken == null || !Class.class.isAssignableFrom(typeToken.getRawType()) ? null : (TypeAdapter)new VastVideoConfigTypeAdapter();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/mopub/mobileads/VastVideoConfig$VastVideoConfigTypeAdapter;", "Lcom/google/gson/TypeAdapter;", "Ljava/lang/Class;", "()V", "read", "jsonReader", "Lcom/google/gson/stream/JsonReader;", "write", "", "jsonWriter", "Lcom/google/gson/stream/JsonWriter;", "clazz", "mopub-sdk-base_release"})
    public static final class VastVideoConfigTypeAdapter
    extends TypeAdapter<Class<?>> {
        public void write(@Nullable JsonWriter jsonWriter, @Nullable Class<?> clazz) throws IOException {
            if (jsonWriter == null) {
                return;
            }
            if (clazz == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.value(clazz.getName());
        }

        @Nullable
        public Class<?> read(@Nullable JsonReader jsonReader) throws IOException {
            Class<?> clazz;
            if (jsonReader == null) {
                clazz = null;
            } else if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                clazz = null;
            } else {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName(jsonReader.nextString());
                }
                catch (ClassNotFoundException exception) {
                    throw (Throwable)new IOException(exception);
                }
                clazz = clazz2;
            }
            return clazz;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/mopub/mobileads/VastVideoConfig$Companion;", "", "()V", "serialVersionUID", "", "fromVastVideoConfigString", "Lcom/mopub/mobileads/VastVideoConfig;", "input", "", "mopub-sdk-base_release"})
    public static final class Companion {
        @NotNull
        public final VastVideoConfig fromVastVideoConfigString(@NotNull String input) throws IOException, ClassNotFoundException {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new VastVideoConfigTypeAdapterFactory()).create();
            Object object = gson.fromJson(input, VastVideoConfig.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gson.fromJson(input, VastVideoConfig::class.java)");
            return (VastVideoConfig)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

