/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.content.res.Configuration;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Dips;
import com.mopub.mobileads.resource.CtaButtonDrawable;

public class VastVideoCtaButtonWidget
extends ImageView {
    @NonNull
    private CtaButtonDrawable mCtaButtonDrawable;
    @NonNull
    private final RelativeLayout.LayoutParams mLandscapeLayoutParams;
    @NonNull
    private final RelativeLayout.LayoutParams mPortraitLayoutParams;
    private boolean mIsVideoSkippable;
    private boolean mIsVideoComplete;
    private boolean mHasCompanionAd;
    private boolean mHasClickthroughUrl;

    public VastVideoCtaButtonWidget(@NonNull Context context, int videoViewId, boolean hasCompanionAd, boolean hasClickthroughUrl) {
        super(context);
        this.mHasCompanionAd = hasCompanionAd;
        this.mHasClickthroughUrl = hasClickthroughUrl;
        this.setId(View.generateViewId());
        int width = Dips.dipsToIntPixels(150.0f, context);
        int height = Dips.dipsToIntPixels(38.0f, context);
        int margin = Dips.dipsToIntPixels(16.0f, context);
        this.mCtaButtonDrawable = new CtaButtonDrawable(context);
        this.setImageDrawable(this.mCtaButtonDrawable);
        this.mLandscapeLayoutParams = new RelativeLayout.LayoutParams(width, height);
        this.mLandscapeLayoutParams.setMargins(margin, margin, margin, margin);
        this.mLandscapeLayoutParams.addRule(8, videoViewId);
        this.mLandscapeLayoutParams.addRule(7, videoViewId);
        this.mPortraitLayoutParams = new RelativeLayout.LayoutParams(width, height);
        this.mPortraitLayoutParams.setMargins(margin, margin, margin, margin);
        this.mPortraitLayoutParams.addRule(12);
        this.mPortraitLayoutParams.addRule(11);
        this.updateLayoutAndVisibility();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.updateLayoutAndVisibility();
    }

    void updateCtaText(@NonNull String customCtaText) {
        this.mCtaButtonDrawable.setCtaText(customCtaText);
    }

    void notifyVideoSkippable() {
        this.mIsVideoSkippable = true;
        this.updateLayoutAndVisibility();
    }

    void notifyVideoComplete() {
        this.mIsVideoSkippable = true;
        this.mIsVideoComplete = true;
        this.updateLayoutAndVisibility();
    }

    void notifyVideoClickable() {
        this.mIsVideoComplete = true;
        this.updateLayoutAndVisibility();
    }

    private void updateLayoutAndVisibility() {
        if (!this.mHasClickthroughUrl) {
            this.setVisibility(8);
            return;
        }
        if (!this.mIsVideoSkippable) {
            this.setVisibility(4);
            return;
        }
        if (this.mIsVideoComplete && this.mHasCompanionAd) {
            this.setVisibility(8);
            return;
        }
        int currentOrientation = this.getResources().getConfiguration().orientation;
        switch (currentOrientation) {
            case 2: {
                this.setLayoutParams((ViewGroup.LayoutParams)this.mLandscapeLayoutParams);
                break;
            }
            case 1: {
                this.setLayoutParams((ViewGroup.LayoutParams)this.mPortraitLayoutParams);
                break;
            }
            case 0: {
                MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Screen orientation undefined: CTA button widget defaulting to portrait layout");
                this.setLayoutParams((ViewGroup.LayoutParams)this.mPortraitLayoutParams);
                break;
            }
            case 3: {
                MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Screen orientation is deprecated ORIENTATION_SQUARE: CTA button widget defaulting to portrait layout");
                this.setLayoutParams((ViewGroup.LayoutParams)this.mPortraitLayoutParams);
                break;
            }
            default: {
                MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Unrecognized screen orientation: CTA button widget defaulting to portrait layout");
                this.setLayoutParams((ViewGroup.LayoutParams)this.mPortraitLayoutParams);
            }
        }
        this.setVisibility(0);
    }

    @Deprecated
    @VisibleForTesting
    String getCtaText() {
        return this.mCtaButtonDrawable.getCtaText();
    }

    @Deprecated
    @VisibleForTesting
    boolean hasPortraitLayoutParams() {
        return this.getLayoutParams().equals(this.mPortraitLayoutParams);
    }

    @Deprecated
    @VisibleForTesting
    boolean hasLandscapeLayoutParams() {
        return this.getLayoutParams().equals(this.mLandscapeLayoutParams);
    }
}

