/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Dips;
import com.mopub.mobileads.resource.DrawableConstants;

public class VastVideoGradientStripWidget
extends ImageView {
    private int mVisibilityForCompanionAd;
    private boolean mHasCompanionAd;
    private boolean mIsVideoComplete;
    private boolean mAlwaysVisibleDuringVideo;

    public VastVideoGradientStripWidget(@NonNull Context context, @NonNull GradientDrawable.Orientation gradientOrientation, boolean hasCompanionAd, int visibilityForCompanionAd, int layoutVerb, int layoutAnchor, boolean alwaysVisibleDuringVideo) {
        super(context);
        this.mVisibilityForCompanionAd = visibilityForCompanionAd;
        this.mHasCompanionAd = hasCompanionAd;
        this.mAlwaysVisibleDuringVideo = alwaysVisibleDuringVideo;
        GradientDrawable gradientDrawable = new GradientDrawable(gradientOrientation, new int[]{DrawableConstants.GradientStrip.START_COLOR, DrawableConstants.GradientStrip.END_COLOR});
        this.setImageDrawable((Drawable)gradientDrawable);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, Dips.dipsToIntPixels(72.0f, context));
        layoutParams.addRule(layoutVerb, layoutAnchor);
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.updateVisibility();
    }

    void notifyVideoComplete() {
        this.mIsVideoComplete = true;
        this.updateVisibility();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.updateVisibility();
    }

    private void updateVisibility() {
        if (this.mIsVideoComplete) {
            if (this.mHasCompanionAd) {
                this.setVisibility(this.mVisibilityForCompanionAd);
            } else {
                this.setVisibility(8);
            }
            return;
        }
        if (this.mAlwaysVisibleDuringVideo) {
            this.setVisibility(0);
            return;
        }
        int currentOrientation = this.getResources().getConfiguration().orientation;
        switch (currentOrientation) {
            case 2: {
                this.setVisibility(0);
                break;
            }
            case 1: {
                this.setVisibility(4);
                break;
            }
            case 0: {
                MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Screen orientation undefined: do not show gradient strip widget");
                this.setVisibility(4);
                break;
            }
            case 3: {
                MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Screen orientation is deprecated ORIENTATION_SQUARE: do not show gradient strip widget");
                this.setVisibility(4);
                break;
            }
            default: {
                MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Unrecognized screen orientation: do not show gradient strip widget");
                this.setVisibility(4);
            }
        }
    }
}

