/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.util.Dips;
import com.mopub.mobileads.resource.ProgressBarDrawable;

public class VastVideoProgressBarWidget
extends ImageView {
    @NonNull
    private ProgressBarDrawable mProgressBarDrawable;
    private final int mProgressBarHeight;

    public VastVideoProgressBarWidget(@NonNull Context context) {
        super(context);
        this.setId(View.generateViewId());
        this.mProgressBarDrawable = new ProgressBarDrawable(context);
        this.setImageDrawable(this.mProgressBarDrawable);
        this.mProgressBarHeight = Dips.dipsToIntPixels(4.0f, context);
    }

    public void setAnchorId(int anchorId) {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, this.mProgressBarHeight);
        layoutParams.addRule(8, anchorId);
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void calibrateAndMakeVisible(int duration, int skipOffset) {
        this.mProgressBarDrawable.setDurationAndSkipOffset(duration, skipOffset);
        this.setVisibility(0);
    }

    public void updateProgress(int progress) {
        this.mProgressBarDrawable.setProgress(progress);
    }

    public void reset() {
        this.mProgressBarDrawable.reset();
        this.mProgressBarDrawable.setProgress(0);
    }

    @Deprecated
    @VisibleForTesting
    ProgressBarDrawable getImageViewDrawable() {
        return this.mProgressBarDrawable;
    }

    @Deprecated
    @VisibleForTesting
    void setImageViewDrawable(@NonNull ProgressBarDrawable drawable2) {
        this.mProgressBarDrawable = drawable2;
    }
}

