/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.Constants;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.mobileads.BaseWebView;
import com.mopub.mobileads.VastResource;
import com.mopub.network.Networking;

public class VastWebView
extends BaseWebView {
    @Nullable
    VastWebViewClickListener mVastWebViewClickListener;

    VastWebView(Context context) {
        super(context);
        this.disableScrollingAndZoom();
        this.getSettings().setJavaScriptEnabled(true);
        this.setBackgroundColor(0);
        this.setOnTouchListener(new VastWebViewOnTouchListener());
        this.setId(View.generateViewId());
    }

    void loadData(String data) {
        this.loadDataWithBaseURL(Networking.getBaseUrlScheme() + "://" + Constants.HOST + "/", data, "text/html", "utf-8", null);
    }

    void setVastWebViewClickListener(@NonNull VastWebViewClickListener vastWebViewClickListener) {
        this.mVastWebViewClickListener = vastWebViewClickListener;
    }

    private void disableScrollingAndZoom() {
        this.setHorizontalScrollBarEnabled(false);
        this.setHorizontalScrollbarOverlay(false);
        this.setVerticalScrollBarEnabled(false);
        this.setVerticalScrollbarOverlay(false);
        this.getSettings().setSupportZoom(false);
        this.setScrollBarStyle(0);
    }

    @NonNull
    static VastWebView createView(@NonNull Context context, @NonNull VastResource vastResource) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(vastResource);
        VastWebView webView = new VastWebView(context);
        vastResource.initializeWebView(webView);
        return webView;
    }

    @Deprecated
    @VisibleForTesting
    @NonNull
    VastWebViewClickListener getVastWebViewClickListener() {
        return this.mVastWebViewClickListener;
    }

    class VastWebViewOnTouchListener
    implements View.OnTouchListener {
        private boolean mClickStarted;

        VastWebViewOnTouchListener() {
        }

        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case 0: {
                    this.mClickStarted = true;
                    break;
                }
                case 1: {
                    if (!this.mClickStarted) {
                        return false;
                    }
                    this.mClickStarted = false;
                    if (VastWebView.this.mVastWebViewClickListener == null) break;
                    VastWebView.this.mVastWebViewClickListener.onVastWebViewClick();
                }
            }
            return false;
        }
    }

    static interface VastWebViewClickListener {
        public void onVastWebViewClick();
    }
}

