/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import com.mopub.common.VisibleForTesting;

public class ViewGestureDetector
extends GestureDetector {
    @NonNull
    private GestureListener mGestureListener;

    public ViewGestureDetector(@NonNull Context context) {
        this(context, new GestureListener());
    }

    private ViewGestureDetector(Context context, @NonNull GestureListener gestureListener) {
        super(context, (GestureDetector.OnGestureListener)gestureListener);
        this.mGestureListener = gestureListener;
        this.setIsLongpressEnabled(false);
    }

    void onResetUserClick() {
        this.mGestureListener.onResetUserClick();
    }

    public boolean isClicked() {
        return this.mGestureListener.isClicked();
    }

    @Deprecated
    @VisibleForTesting
    void setGestureListener(@NonNull GestureListener gestureListener) {
        this.mGestureListener = gestureListener;
    }

    @VisibleForTesting
    public void setClicked(boolean clicked) {
        this.mGestureListener.mIsClicked = clicked;
    }

    static class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        boolean mIsClicked = false;

        GestureListener() {
        }

        void onResetUserClick() {
            this.mIsClicked = false;
        }

        boolean isClicked() {
            return this.mIsClicked;
        }

        public boolean onSingleTapUp(MotionEvent e) {
            this.mIsClicked = true;
            return super.onSingleTapUp(e);
        }
    }
}

