/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.annotation.SuppressLint;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.BaseAd;
import com.mopub.mobileads.BaseWebView;
import com.mopub.mobileads.MoPubWebViewController;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class WebViewCacheService {
    @VisibleForTesting
    static final int MAX_SIZE = 50;
    @VisibleForTesting
    static final long TRIM_CACHE_FREQUENCY_MILLIS = 900000L;
    @SuppressLint(value={"UseSparseArrays"})
    @NonNull
    private static final Map<Long, Config> sWebViewConfigs = Collections.synchronizedMap(new HashMap());
    @VisibleForTesting
    @NonNull
    static final TrimCacheRunnable sTrimCacheRunnable = new TrimCacheRunnable();
    @NonNull
    private static Handler sHandler = new Handler();

    private WebViewCacheService() {
    }

    @VisibleForTesting
    public static void storeWebViewConfig(@NonNull Long broadcastIdentifier, @NonNull BaseWebView baseWebView, @NonNull BaseAd baseAd, @Nullable MoPubWebViewController controller) {
        Preconditions.checkNotNull(broadcastIdentifier);
        Preconditions.checkNotNull((Object)baseWebView);
        Preconditions.checkNotNull(baseAd);
        WebViewCacheService.trimCache();
        if (sWebViewConfigs.size() >= 50) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Unable to cache web view. Please destroy some via MoPubInterstitial#destroy() and try again.");
            return;
        }
        sWebViewConfigs.put(broadcastIdentifier, new Config(baseWebView, baseAd, controller));
    }

    @Nullable
    public static Config popWebViewConfig(@NonNull Long broadcastIdentifier) {
        Preconditions.checkNotNull(broadcastIdentifier);
        return sWebViewConfigs.remove(broadcastIdentifier);
    }

    @VisibleForTesting
    static synchronized void trimCache() {
        Iterator<Map.Entry<Long, Config>> iterator = sWebViewConfigs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Config> entry = iterator.next();
            if (entry.getValue().getWeakBaseAd().get() != null) continue;
            iterator.remove();
        }
        if (!sWebViewConfigs.isEmpty()) {
            sHandler.removeCallbacks((Runnable)sTrimCacheRunnable);
            sHandler.postDelayed((Runnable)sTrimCacheRunnable, 900000L);
        }
    }

    @Deprecated
    @VisibleForTesting
    public static void clearAll() {
        sWebViewConfigs.clear();
        sHandler.removeCallbacks((Runnable)sTrimCacheRunnable);
    }

    @Deprecated
    @VisibleForTesting
    @NonNull
    static Map<Long, Config> getWebViewConfigs() {
        return sWebViewConfigs;
    }

    @Deprecated
    @VisibleForTesting
    static void setHandler(@NonNull Handler handler) {
        sHandler = handler;
    }

    private static class TrimCacheRunnable
    implements Runnable {
        private TrimCacheRunnable() {
        }

        @Override
        public void run() {
            WebViewCacheService.trimCache();
        }
    }

    public static class Config {
        @NonNull
        private final BaseWebView mWebView;
        @NonNull
        private final WeakReference<BaseAd> mWeakBaseAd;
        @Nullable
        private final MoPubWebViewController mController;

        Config(@NonNull BaseWebView baseWebView, @NonNull BaseAd baseAd, @Nullable MoPubWebViewController controller) {
            Preconditions.checkNotNull((Object)baseWebView);
            Preconditions.checkNotNull(baseAd);
            this.mWebView = baseWebView;
            this.mWeakBaseAd = new WeakReference<BaseAd>(baseAd);
            this.mController = controller;
        }

        @NonNull
        public BaseWebView getWebView() {
            return this.mWebView;
        }

        @NonNull
        public WeakReference<BaseAd> getWeakBaseAd() {
            return this.mWeakBaseAd;
        }

        @Nullable
        public MoPubWebViewController getController() {
            return this.mController;
        }
    }
}

