/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtils {
    private XmlUtils() {
    }

    public static Node getFirstMatchingChildNode(Node node, String nodeName) {
        return XmlUtils.getFirstMatchingChildNode(node, nodeName, null, null);
    }

    public static Node getFirstMatchingChildNode(Node node, String nodeName, String attributeName, List<String> attributeValues) {
        if (node == null || nodeName == null) {
            return null;
        }
        List<Node> nodes = XmlUtils.getMatchingChildNodes(node, nodeName, attributeName, attributeValues);
        if (nodes != null && !nodes.isEmpty()) {
            return nodes.get(0);
        }
        return null;
    }

    public static List<Node> getMatchingChildNodes(Node node, String nodeName) {
        return XmlUtils.getMatchingChildNodes(node, nodeName, null, null);
    }

    public static List<Node> getMatchingChildNodes(Node node, String nodeName, String attributeName, List<String> attributeValues) {
        if (node == null || nodeName == null) {
            return null;
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (!childNode.getNodeName().equals(nodeName) || !XmlUtils.nodeMatchesAttributeFilter(childNode, attributeName, attributeValues)) continue;
            nodes.add(childNode);
        }
        return nodes;
    }

    public static boolean nodeMatchesAttributeFilter(Node node, String attributeName, List<String> attributeValues) {
        Node attrNode;
        if (attributeName == null || attributeValues == null) {
            return true;
        }
        NamedNodeMap attrMap = node.getAttributes();
        return attrMap != null && (attrNode = attrMap.getNamedItem(attributeName)) != null && attributeValues.contains(attrNode.getNodeValue());
    }

    public static String getNodeValue(Node node) {
        if (node != null && node.getFirstChild() != null && node.getFirstChild().getNodeValue() != null) {
            return node.getFirstChild().getNodeValue().trim();
        }
        return null;
    }

    public static Integer getAttributeValueAsInt(Node node, String attributeName) {
        if (node == null || attributeName == null) {
            return null;
        }
        try {
            return Integer.parseInt(XmlUtils.getAttributeValue(node, attributeName));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String getAttributeValue(Node node, String attributeName) {
        if (node == null || attributeName == null) {
            return null;
        }
        NamedNodeMap attrMap = node.getAttributes();
        Node attrNode = attrMap.getNamedItem(attributeName);
        if (attrNode != null) {
            return attrNode.getNodeValue();
        }
        return null;
    }

    public static <T> List<T> getListFromDocument(Document vastDoc, String elementName, String attributeName, String attributeValue, NodeProcessor<T> nodeProcessor) {
        ArrayList<T> results = new ArrayList<T>();
        if (vastDoc == null) {
            return results;
        }
        NodeList nodes = vastDoc.getElementsByTagName(elementName);
        if (nodes == null) {
            return results;
        }
        List<String> attributeValues = attributeValue == null ? null : Arrays.asList(attributeValue);
        for (int i = 0; i < nodes.getLength(); ++i) {
            T processed;
            Node node = nodes.item(i);
            if (node == null || !XmlUtils.nodeMatchesAttributeFilter(node, attributeName, attributeValues) || (processed = nodeProcessor.process(node)) == null) continue;
            results.add(processed);
        }
        return results;
    }

    public static <T> T getFirstMatchFromDocument(Document vastDoc, String elementName, String attributeName, String attributeValue, NodeProcessor<T> nodeProcessor) {
        if (vastDoc == null) {
            return null;
        }
        NodeList nodes = vastDoc.getElementsByTagName(elementName);
        if (nodes == null) {
            return null;
        }
        List<String> attributeValues = attributeValue == null ? null : Arrays.asList(attributeValue);
        for (int i = 0; i < nodes.getLength(); ++i) {
            T processed;
            Node node = nodes.item(i);
            if (node == null || !XmlUtils.nodeMatchesAttributeFilter(node, attributeName, attributeValues) || (processed = nodeProcessor.process(node)) == null) continue;
            return processed;
        }
        return null;
    }

    public static String getFirstMatchingStringData(Document vastDoc, String elementName) {
        return XmlUtils.getFirstMatchingStringData(vastDoc, elementName, null, null);
    }

    public static String getFirstMatchingStringData(Document vastDoc, String elementName, String attributeName, String attributeValue) {
        return XmlUtils.getFirstMatchFromDocument(vastDoc, elementName, attributeName, attributeValue, new NodeProcessor<String>(){

            @Override
            public String process(Node node) {
                return XmlUtils.getNodeValue(node);
            }
        });
    }

    public static List<String> getStringDataAsList(Document vastDoc, String elementName) {
        return XmlUtils.getStringDataAsList(vastDoc, elementName, null, null);
    }

    public static List<String> getStringDataAsList(Document vastDoc, String elementName, String attributeName, String attributeValue) {
        return XmlUtils.getListFromDocument(vastDoc, elementName, attributeName, attributeValue, new NodeProcessor<String>(){

            @Override
            public String process(Node node) {
                return XmlUtils.getNodeValue(node);
            }
        });
    }

    public static List<Node> getNodesWithElementAndAttribute(Document vastDoc, String elementName, String attributeName, String attributeValue) {
        return XmlUtils.getListFromDocument(vastDoc, elementName, attributeName, attributeValue, new NodeProcessor<Node>(){

            @Override
            public Node process(Node node) {
                return node;
            }
        });
    }

    public static interface NodeProcessor<T> {
        public T process(Node var1);
    }
}

