/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mraid;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.graphics.Rect;
import android.net.Uri;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.ConsoleMessage;
import android.webkit.JsResult;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.CloseableLayout;
import com.mopub.common.Preconditions;
import com.mopub.common.UrlAction;
import com.mopub.common.UrlHandler;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.DeviceUtils;
import com.mopub.common.util.Dips;
import com.mopub.common.util.ManifestUtils;
import com.mopub.common.util.Utils;
import com.mopub.common.util.Views;
import com.mopub.mobileads.BaseHtmlWebView;
import com.mopub.mobileads.BaseWebView;
import com.mopub.mobileads.BaseWebViewViewability;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MoPubWebViewController;
import com.mopub.mobileads.MraidVideoPlayerActivity;
import com.mopub.mobileads.util.WebViews;
import com.mopub.mraid.MraidBridge;
import com.mopub.mraid.MraidCommandException;
import com.mopub.mraid.MraidNativeCommandHandler;
import com.mopub.mraid.MraidOrientation;
import com.mopub.mraid.MraidScreenMetrics;
import com.mopub.mraid.PlacementType;
import com.mopub.mraid.ViewState;
import com.mopub.mraid.WebViewDebugListener;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.EnumSet;

public class MraidController
extends MoPubWebViewController {
    @NonNull
    private final PlacementType mPlacementType;
    @NonNull
    private final CloseableLayout mCloseableAdContainer;
    @Nullable
    private ViewGroup mRootView;
    @NonNull
    private final MoPubWebViewController.ScreenMetricsWaiter mScreenMetricsWaiter;
    @NonNull
    private final MraidScreenMetrics mScreenMetrics;
    @NonNull
    private ViewState mViewState = ViewState.LOADING;
    @Nullable
    private UseCustomCloseListener mOnCloseButtonListener;
    @Nullable
    private MraidBridge.MraidWebView mTwoPartWebView;
    @NonNull
    private final MraidBridge mMraidBridge;
    @NonNull
    private final MraidBridge mTwoPartBridge;
    @NonNull
    private OrientationBroadcastReceiver mOrientationBroadcastReceiver = new OrientationBroadcastReceiver();
    @Nullable
    private Integer mOriginalActivityOrientation;
    @NonNull
    private UrlHandler.MoPubSchemeListener mDebugSchemeListener = new UrlHandler.MoPubSchemeListener(){

        @Override
        public void onFinishLoad() {
        }

        @Override
        public void onClose() {
        }

        @Override
        public void onFailLoad() {
        }

        @Override
        public void onCrash() {
            if (MraidController.this.mWebView != null) {
                MraidController.this.mWebView.loadUrl("chrome://crash");
            }
        }
    };
    private boolean mAllowOrientationChange = true;
    private MraidOrientation mForceOrientation = MraidOrientation.NONE;
    private final MraidNativeCommandHandler mMraidNativeCommandHandler;
    @Nullable
    private String mDspCreativeId;
    private final MraidBridge.MraidBridgeListener mMraidBridgeListener = new MraidBridge.MraidBridgeListener(){

        @Override
        public void onPageLoaded() {
            MraidController.this.handlePageLoad();
            if (MraidController.this.mBaseWebViewListener != null) {
                MraidController.this.mBaseWebViewListener.onLoaded((View)MraidController.this.mDefaultAdContainer);
            }
        }

        @Override
        public void onPageFailedToLoad() {
            if (MraidController.this.mBaseWebViewListener != null) {
                MraidController.this.mBaseWebViewListener.onFailedToLoad(MoPubErrorCode.MRAID_LOAD_ERROR);
            }
        }

        @Override
        public void onRenderProcessGone(@NonNull MoPubErrorCode errorCode) {
            MraidController.this.handleRenderProcessGone(errorCode);
        }

        @Override
        public void onVisibilityChanged(boolean isVisible) {
            if (!MraidController.this.mTwoPartBridge.isAttached()) {
                MraidController.this.mMraidBridge.notifyViewability(isVisible);
            }
        }

        @Override
        public boolean onJsAlert(@NonNull String message, @NonNull JsResult result) {
            return MraidController.this.handleJsAlert(message, result);
        }

        @Override
        public boolean onConsoleMessage(@NonNull ConsoleMessage consoleMessage) {
            return MraidController.this.handleConsoleMessage(consoleMessage);
        }

        @Override
        public void onClose() {
            MraidController.this.handleClose();
        }

        @Override
        public void onResize(int width, int height, int offsetX, int offsetY, @NonNull CloseableLayout.ClosePosition closePosition, boolean allowOffscreen) throws MraidCommandException {
            MraidController.this.handleResize(width, height, offsetX, offsetY, closePosition, allowOffscreen);
        }

        @Override
        public void onExpand(@Nullable URI uri, boolean shouldUseCustomClose) throws MraidCommandException {
            MraidController.this.handleExpand(uri, shouldUseCustomClose);
        }

        @Override
        public void onUseCustomClose(boolean shouldUseCustomClose) {
            MraidController.this.handleCustomClose(shouldUseCustomClose);
        }

        @Override
        public void onSetOrientationProperties(boolean allowOrientationChange, MraidOrientation forceOrientation) throws MraidCommandException {
            MraidController.this.handleSetOrientationProperties(allowOrientationChange, forceOrientation);
        }

        @Override
        public void onOpen(@NonNull URI uri) {
            MraidController.this.handleOpen(uri.toString());
        }

        @Override
        public void onPlayVideo(@NonNull URI uri) {
            MraidController.this.handleShowVideo(uri.toString());
        }
    };
    private final MraidBridge.MraidBridgeListener mTwoPartBridgeListener = new MraidBridge.MraidBridgeListener(){

        @Override
        public void onPageLoaded() {
            MraidController.this.handleTwoPartPageLoad();
        }

        @Override
        public void onPageFailedToLoad() {
        }

        @Override
        public void onRenderProcessGone(@NonNull MoPubErrorCode errorCode) {
            MraidController.this.handleRenderProcessGone(errorCode);
        }

        @Override
        public void onVisibilityChanged(boolean isVisible) {
            MraidController.this.mMraidBridge.notifyViewability(isVisible);
            MraidController.this.mTwoPartBridge.notifyViewability(isVisible);
        }

        @Override
        public boolean onJsAlert(@NonNull String message, @NonNull JsResult result) {
            return MraidController.this.handleJsAlert(message, result);
        }

        @Override
        public boolean onConsoleMessage(@NonNull ConsoleMessage consoleMessage) {
            return MraidController.this.handleConsoleMessage(consoleMessage);
        }

        @Override
        public void onResize(int width, int height, int offsetX, int offsetY, @NonNull CloseableLayout.ClosePosition closePosition, boolean allowOffscreen) throws MraidCommandException {
            throw new MraidCommandException("Not allowed to resize from an expanded state");
        }

        @Override
        public void onExpand(@Nullable URI uri, boolean shouldUseCustomClose) {
        }

        @Override
        public void onClose() {
            MraidController.this.handleClose();
        }

        @Override
        public void onUseCustomClose(boolean shouldUseCustomClose) {
            MraidController.this.handleCustomClose(shouldUseCustomClose);
        }

        @Override
        public void onSetOrientationProperties(boolean allowOrientationChange, MraidOrientation forceOrientation) throws MraidCommandException {
            MraidController.this.handleSetOrientationProperties(allowOrientationChange, forceOrientation);
        }

        @Override
        public void onOpen(URI uri) {
            MraidController.this.handleOpen(uri.toString());
        }

        @Override
        public void onPlayVideo(@NonNull URI uri) {
            MraidController.this.handleShowVideo(uri.toString());
        }
    };

    public MraidController(@NonNull Context context, @Nullable String dspCreativeId, @NonNull PlacementType placementType, boolean allowCustomClose) {
        this(context, dspCreativeId, placementType, new MraidBridge(placementType, allowCustomClose), new MraidBridge(PlacementType.INTERSTITIAL, allowCustomClose), new MoPubWebViewController.ScreenMetricsWaiter());
    }

    @VisibleForTesting
    MraidController(@NonNull Context context, @Nullable String dspCreativeId, @NonNull PlacementType placementType, @NonNull MraidBridge bridge, @NonNull MraidBridge twoPartBridge, @NonNull MoPubWebViewController.ScreenMetricsWaiter screenMetricsWaiter) {
        super(context, dspCreativeId);
        this.mPlacementType = placementType;
        this.mMraidBridge = bridge;
        this.mTwoPartBridge = twoPartBridge;
        this.mScreenMetricsWaiter = screenMetricsWaiter;
        this.mViewState = ViewState.LOADING;
        DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
        this.mScreenMetrics = new MraidScreenMetrics(this.mContext, displayMetrics.density);
        this.mCloseableAdContainer = new CloseableLayout(this.mContext);
        this.mCloseableAdContainer.setOnCloseListener(new CloseableLayout.OnCloseListener(){

            @Override
            public void onClose() {
                MraidController.this.handleClose();
            }
        });
        View dimmingView = new View(this.mContext);
        dimmingView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
        this.mCloseableAdContainer.addView(dimmingView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mOrientationBroadcastReceiver.register(this.mContext);
        this.mMraidBridge.setMraidBridgeListener(this.mMraidBridgeListener);
        this.mTwoPartBridge.setMraidBridgeListener(this.mTwoPartBridgeListener);
        this.mMraidNativeCommandHandler = new MraidNativeCommandHandler();
    }

    public void setUseCustomCloseListener(@Nullable UseCustomCloseListener listener) {
        this.mOnCloseButtonListener = listener;
    }

    @Override
    public void setDebugListener(@Nullable WebViewDebugListener debugListener) {
        this.mDebugListener = debugListener;
    }

    @Override
    public void onShow(@NonNull Activity activity) {
        super.onShow(activity);
        if (this.mOnCloseButtonListener != null) {
            this.mOnCloseButtonListener.useCustomCloseChanged(this.isUsingCustomClose());
        }
        try {
            this.applyOrientation();
        }
        catch (MraidCommandException e) {
            MoPubLog.d("Failed to apply orientation.");
        }
    }

    private int getDisplayRotation() {
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        return wm.getDefaultDisplay().getRotation();
    }

    @VisibleForTesting
    boolean handleConsoleMessage(@NonNull ConsoleMessage consoleMessage) {
        if (this.mDebugListener != null) {
            return this.mDebugListener.onConsoleMessage(consoleMessage);
        }
        return true;
    }

    @VisibleForTesting
    boolean handleJsAlert(@NonNull String message, @NonNull JsResult result) {
        if (this.mDebugListener != null) {
            return this.mDebugListener.onJsAlert(message, result);
        }
        result.confirm();
        return true;
    }

    @Nullable
    public MraidBridge.MraidWebView getCurrentWebView() {
        return this.mTwoPartBridge.isAttached() ? this.mTwoPartWebView : (MraidBridge.MraidWebView)this.mWebView;
    }

    @VisibleForTesting
    boolean isInlineVideoAvailable() {
        Activity activity = (Activity)this.mWeakActivity.get();
        if (activity == null || this.getCurrentWebView() == null) {
            return false;
        }
        if (this.mPlacementType != PlacementType.INLINE) {
            return true;
        }
        return this.mMraidNativeCommandHandler.isInlineVideoAvailable(activity, (View)this.getCurrentWebView());
    }

    @VisibleForTesting
    void handlePageLoad() {
        this.mMraidBridge.notifySupports(this.mMraidNativeCommandHandler.isSmsAvailable(this.mContext), this.mMraidNativeCommandHandler.isTelAvailable(this.mContext), MraidNativeCommandHandler.isCalendarAvailable(this.mContext), MraidNativeCommandHandler.isStorePictureSupported(this.mContext), this.isInlineVideoAvailable());
        this.mMraidBridge.notifyPlacementType(this.mPlacementType);
        this.mMraidBridge.notifyViewability(this.mMraidBridge.isViewable());
        this.mMraidBridge.notifyScreenMetrics(this.mScreenMetrics);
        this.setViewState(ViewState.DEFAULT);
        this.mMraidBridge.notifyReady();
    }

    @VisibleForTesting
    void handleTwoPartPageLoad() {
        this.updateScreenMetricsAsync(new Runnable(){

            @Override
            public void run() {
                MraidBridge mraidBridge = MraidController.this.mTwoPartBridge;
                boolean bl = MraidController.this.mMraidNativeCommandHandler.isSmsAvailable(MraidController.this.mContext);
                boolean bl2 = MraidController.this.mMraidNativeCommandHandler.isTelAvailable(MraidController.this.mContext);
                MraidController.this.mMraidNativeCommandHandler;
                boolean bl3 = MraidNativeCommandHandler.isCalendarAvailable(MraidController.this.mContext);
                MraidController.this.mMraidNativeCommandHandler;
                mraidBridge.notifySupports(bl, bl2, bl3, MraidNativeCommandHandler.isStorePictureSupported(MraidController.this.mContext), MraidController.this.isInlineVideoAvailable());
                MraidController.this.mTwoPartBridge.notifyViewState(MraidController.this.mViewState);
                MraidController.this.mTwoPartBridge.notifyPlacementType(MraidController.this.mPlacementType);
                MraidController.this.mTwoPartBridge.notifyViewability(MraidController.this.mTwoPartBridge.isViewable());
                MraidController.this.mTwoPartBridge.notifyReady();
            }
        });
    }

    private void updateScreenMetricsAsync(@Nullable Runnable successRunnable) {
        this.mScreenMetricsWaiter.cancelLastRequest();
        MraidBridge.MraidWebView currentWebView = this.getCurrentWebView();
        if (currentWebView == null) {
            return;
        }
        this.mScreenMetricsWaiter.waitFor(new View[]{this.mDefaultAdContainer, currentWebView}).start(new Runnable((View)currentWebView, successRunnable){
            final /* synthetic */ View val$currentWebView;
            final /* synthetic */ Runnable val$successRunnable;
            {
                this.val$currentWebView = view;
                this.val$successRunnable = runnable;
            }

            @Override
            public void run() {
                DisplayMetrics displayMetrics = MraidController.this.mContext.getResources().getDisplayMetrics();
                MraidController.this.mScreenMetrics.setScreenSize(displayMetrics.widthPixels, displayMetrics.heightPixels);
                int[] location = new int[2];
                ViewGroup rootView = MraidController.this.getRootView();
                rootView.getLocationOnScreen(location);
                MraidController.this.mScreenMetrics.setRootViewPosition(location[0], location[1], rootView.getWidth(), rootView.getHeight());
                MraidController.this.mDefaultAdContainer.getLocationOnScreen(location);
                MraidController.this.mScreenMetrics.setDefaultAdPosition(location[0], location[1], MraidController.this.mDefaultAdContainer.getWidth(), MraidController.this.mDefaultAdContainer.getHeight());
                this.val$currentWebView.getLocationOnScreen(location);
                MraidController.this.mScreenMetrics.setCurrentAdPosition(location[0], location[1], this.val$currentWebView.getWidth(), this.val$currentWebView.getHeight());
                MraidController.this.mMraidBridge.notifyScreenMetrics(MraidController.this.mScreenMetrics);
                if (MraidController.this.mTwoPartBridge.isAttached()) {
                    MraidController.this.mTwoPartBridge.notifyScreenMetrics(MraidController.this.mScreenMetrics);
                }
                if (this.val$successRunnable != null) {
                    this.val$successRunnable.run();
                }
            }
        });
    }

    void handleOrientationChange(int currentRotation) {
        this.updateScreenMetricsAsync(null);
    }

    @Override
    protected void pause(boolean isFinishing) {
        super.pause(isFinishing);
        if (this.mTwoPartWebView != null) {
            WebViews.onPause(this.mTwoPartWebView, isFinishing);
        }
    }

    @Override
    protected void resume() {
        super.resume();
        if (this.mTwoPartWebView != null) {
            this.mTwoPartWebView.onResume();
        }
    }

    @Override
    protected void destroy() {
        block2: {
            super.destroy();
            this.mScreenMetricsWaiter.cancelLastRequest();
            try {
                this.mOrientationBroadcastReceiver.unregister();
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().contains("Receiver not registered")) break block2;
                throw e;
            }
        }
        Views.removeFromParent((View)this.mCloseableAdContainer);
        this.detachMraidWebView();
        this.detachTwoPartWebView();
        this.unApplyOrientation();
    }

    private void detachMraidWebView() {
        this.mMraidBridge.detach();
        this.mWebView = null;
    }

    private void detachTwoPartWebView() {
        this.mTwoPartBridge.detach();
        this.mTwoPartWebView = null;
    }

    private void setViewState(@NonNull ViewState viewState) {
        MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "MRAID state set to " + (Object)((Object)viewState));
        ViewState previousViewState = this.mViewState;
        this.mViewState = viewState;
        this.mMraidBridge.notifyViewState(viewState);
        if (this.mTwoPartBridge.isLoaded()) {
            this.mTwoPartBridge.notifyViewState(viewState);
        }
        if (this.mBaseWebViewListener != null) {
            MraidController.callMraidListenerCallbacks(this.mBaseWebViewListener, previousViewState, viewState);
        }
        this.updateScreenMetricsAsync(null);
    }

    @VisibleForTesting
    static void callMraidListenerCallbacks(@NonNull BaseHtmlWebView.BaseWebViewListener baseWebViewListener, @NonNull ViewState previousViewState, @NonNull ViewState currentViewState) {
        Preconditions.checkNotNull(baseWebViewListener);
        Preconditions.checkNotNull((Object)previousViewState);
        Preconditions.checkNotNull((Object)currentViewState);
        if (currentViewState == ViewState.EXPANDED) {
            baseWebViewListener.onExpand();
        } else if (previousViewState == ViewState.EXPANDED && currentViewState == ViewState.DEFAULT) {
            baseWebViewListener.onClose();
        } else if (currentViewState == ViewState.HIDDEN) {
            baseWebViewListener.onClose();
        } else if (previousViewState == ViewState.RESIZED && currentViewState == ViewState.DEFAULT) {
            baseWebViewListener.onResize(true);
        } else if (currentViewState == ViewState.RESIZED) {
            baseWebViewListener.onResize(false);
        }
    }

    int clampInt(int min, int target, int max) {
        return Math.max(min, Math.min(target, max));
    }

    @VisibleForTesting
    void handleResize(int widthDips, int heightDips, int offsetXDips, int offsetYDips, @NonNull CloseableLayout.ClosePosition closePosition, boolean allowOffscreen) throws MraidCommandException {
        if (this.mWebView == null) {
            throw new MraidCommandException("Unable to resize after the WebView is destroyed");
        }
        if (this.mViewState == ViewState.LOADING || this.mViewState == ViewState.HIDDEN) {
            return;
        }
        if (this.mViewState == ViewState.EXPANDED) {
            throw new MraidCommandException("Not allowed to resize from an already expanded ad");
        }
        if (this.mPlacementType == PlacementType.INTERSTITIAL) {
            throw new MraidCommandException("Not allowed to resize from an interstitial ad");
        }
        int width = Dips.dipsToIntPixels(widthDips, this.mContext);
        int height = Dips.dipsToIntPixels(heightDips, this.mContext);
        int offsetX = Dips.dipsToIntPixels(offsetXDips, this.mContext);
        int offsetY = Dips.dipsToIntPixels(offsetYDips, this.mContext);
        int left = this.mScreenMetrics.getDefaultAdRect().left + offsetX;
        int top = this.mScreenMetrics.getDefaultAdRect().top + offsetY;
        Rect resizeRect = new Rect(left, top, left + width, top + height);
        if (!allowOffscreen) {
            Rect bounds = this.mScreenMetrics.getRootViewRect();
            if (resizeRect.width() > bounds.width() || resizeRect.height() > bounds.height()) {
                throw new MraidCommandException("resizeProperties specified a size (" + widthDips + ", " + heightDips + ") and offset (" + offsetXDips + ", " + offsetYDips + ") that doesn't allow the ad to appear within the max allowed size (" + this.mScreenMetrics.getRootViewRectDips().width() + ", " + this.mScreenMetrics.getRootViewRectDips().height() + ")");
            }
            int newLeft = this.clampInt(bounds.left, resizeRect.left, bounds.right - resizeRect.width());
            int newTop = this.clampInt(bounds.top, resizeRect.top, bounds.bottom - resizeRect.height());
            resizeRect.offsetTo(newLeft, newTop);
        }
        Rect closeRect = new Rect();
        this.mCloseableAdContainer.applyCloseRegionBounds(closePosition, resizeRect, closeRect);
        if (!this.mScreenMetrics.getRootViewRect().contains(closeRect)) {
            throw new MraidCommandException("resizeProperties specified a size (" + widthDips + ", " + heightDips + ") and offset (" + offsetXDips + ", " + offsetYDips + ") that doesn't allow the close region to appear within the max allowed size (" + this.mScreenMetrics.getRootViewRectDips().width() + ", " + this.mScreenMetrics.getRootViewRectDips().height() + ")");
        }
        if (!resizeRect.contains(closeRect)) {
            throw new MraidCommandException("resizeProperties specified a size (" + widthDips + ", " + height + ") and offset (" + offsetXDips + ", " + offsetYDips + ") that don't allow the close region to appear within the resized ad.");
        }
        this.mCloseableAdContainer.setClosePosition(closePosition);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(resizeRect.width(), resizeRect.height());
        layoutParams.leftMargin = resizeRect.left - this.mScreenMetrics.getRootViewRect().left;
        layoutParams.topMargin = resizeRect.top - this.mScreenMetrics.getRootViewRect().top;
        if (this.mViewState == ViewState.DEFAULT) {
            if (this.mWebView instanceof BaseWebViewViewability) {
                ((BaseWebViewViewability)this.mWebView).disableTracking();
            }
            this.mDefaultAdContainer.removeView((View)this.mWebView);
            this.mDefaultAdContainer.setVisibility(4);
            this.mCloseableAdContainer.addView((View)this.mWebView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.getAndMemoizeRootView().addView((View)this.mCloseableAdContainer, (ViewGroup.LayoutParams)layoutParams);
            if (this.mWebView instanceof BaseWebViewViewability) {
                ((BaseWebViewViewability)this.mWebView).enableTracking();
            }
        } else if (this.mViewState == ViewState.RESIZED) {
            this.mCloseableAdContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        this.mCloseableAdContainer.setClosePosition(closePosition);
        this.setViewState(ViewState.RESIZED);
    }

    void handleExpand(@Nullable URI uri, boolean shouldUseCustomClose) throws MraidCommandException {
        boolean isTwoPart;
        if (this.mWebView == null) {
            throw new MraidCommandException("Unable to expand after the WebView is destroyed");
        }
        if (this.mPlacementType == PlacementType.INTERSTITIAL) {
            return;
        }
        if (this.mViewState != ViewState.DEFAULT && this.mViewState != ViewState.RESIZED) {
            return;
        }
        this.applyOrientation();
        boolean bl = isTwoPart = uri != null;
        if (isTwoPart) {
            this.mTwoPartWebView = (MraidBridge.MraidWebView)this.createWebView();
            this.mTwoPartWebView.disableTracking();
            this.mTwoPartBridge.attachView(this.mTwoPartWebView);
            this.mTwoPartBridge.setContentUrl(uri.toString());
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        if (this.mViewState == ViewState.DEFAULT) {
            if (isTwoPart) {
                this.mCloseableAdContainer.addView((View)this.mTwoPartWebView, (ViewGroup.LayoutParams)layoutParams);
            } else {
                if (this.mWebView instanceof BaseWebViewViewability) {
                    ((BaseWebViewViewability)this.mWebView).disableTracking();
                }
                this.mDefaultAdContainer.removeView((View)this.mWebView);
                this.mDefaultAdContainer.setVisibility(4);
                this.mCloseableAdContainer.addView((View)this.mWebView, (ViewGroup.LayoutParams)layoutParams);
                if (this.mWebView instanceof BaseWebViewViewability) {
                    ((BaseWebViewViewability)this.mWebView).enableTracking();
                }
            }
            this.getAndMemoizeRootView().addView((View)this.mCloseableAdContainer, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        } else if (this.mViewState == ViewState.RESIZED && isTwoPart) {
            if (this.mWebView instanceof BaseWebViewViewability) {
                ((BaseWebViewViewability)this.mWebView).disableTracking();
            }
            this.mCloseableAdContainer.removeView((View)this.mWebView);
            this.mDefaultAdContainer.addView((View)this.mWebView, (ViewGroup.LayoutParams)layoutParams);
            if (this.mWebView instanceof BaseWebViewViewability) {
                ((BaseWebViewViewability)this.mWebView).enableTracking();
            }
            this.mDefaultAdContainer.setVisibility(4);
            this.mCloseableAdContainer.addView((View)this.mTwoPartWebView, (ViewGroup.LayoutParams)layoutParams);
        }
        this.mCloseableAdContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.handleCustomClose(shouldUseCustomClose);
        this.setViewState(ViewState.EXPANDED);
    }

    @VisibleForTesting
    protected void handleClose() {
        if (this.mWebView == null) {
            return;
        }
        if (this.mViewState == ViewState.LOADING || this.mViewState == ViewState.HIDDEN) {
            return;
        }
        if (this.mViewState == ViewState.EXPANDED || this.mPlacementType == PlacementType.INTERSTITIAL) {
            this.unApplyOrientation();
        }
        if (this.mViewState == ViewState.RESIZED || this.mViewState == ViewState.EXPANDED) {
            if (this.mTwoPartBridge.isAttached() && this.mTwoPartWebView != null) {
                MraidBridge.MraidWebView twoPartWebView = this.mTwoPartWebView;
                this.detachTwoPartWebView();
                this.mCloseableAdContainer.removeView((View)twoPartWebView);
            } else {
                this.mCloseableAdContainer.removeView((View)this.mWebView);
                this.mDefaultAdContainer.addView((View)this.mWebView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.mDefaultAdContainer.setVisibility(0);
            }
            Views.removeFromParent((View)this.mCloseableAdContainer);
            this.setViewState(ViewState.DEFAULT);
        } else if (this.mViewState == ViewState.DEFAULT) {
            this.mDefaultAdContainer.setVisibility(4);
            this.setViewState(ViewState.HIDDEN);
        }
    }

    @VisibleForTesting
    void handleRenderProcessGone(@NonNull MoPubErrorCode errorCode) {
        if (this.mBaseWebViewListener != null) {
            this.mBaseWebViewListener.onRenderProcessGone(errorCode);
        }
    }

    @NonNull
    private ViewGroup getRootView() {
        if (this.mRootView != null) {
            return this.mRootView;
        }
        View bestRootView = Views.getTopmostView((Context)this.mWeakActivity.get(), (View)this.mDefaultAdContainer);
        return bestRootView instanceof ViewGroup ? (ViewGroup)bestRootView : this.mDefaultAdContainer;
    }

    @NonNull
    private ViewGroup getAndMemoizeRootView() {
        if (this.mRootView == null) {
            this.mRootView = this.getRootView();
        }
        return this.mRootView;
    }

    @VisibleForTesting
    void handleShowVideo(@NonNull String videoUrl) {
        MraidVideoPlayerActivity.startMraid(this.mContext, videoUrl);
    }

    @VisibleForTesting
    void lockOrientation(int screenOrientation) throws MraidCommandException {
        Activity activity = (Activity)this.mWeakActivity.get();
        if (activity == null || !this.shouldAllowForceOrientation(this.mForceOrientation)) {
            throw new MraidCommandException("Attempted to lock orientation to unsupported value: " + this.mForceOrientation.name());
        }
        if (this.mOriginalActivityOrientation == null) {
            this.mOriginalActivityOrientation = activity.getRequestedOrientation();
        }
        activity.setRequestedOrientation(screenOrientation);
    }

    @VisibleForTesting
    void applyOrientation() throws MraidCommandException {
        if (this.mForceOrientation == MraidOrientation.NONE) {
            if (this.mAllowOrientationChange) {
                this.unApplyOrientation();
            } else {
                Activity activity = (Activity)this.mWeakActivity.get();
                if (activity == null) {
                    throw new MraidCommandException("Unable to set MRAID expand orientation to 'none'; expected passed in Activity Context.");
                }
                this.lockOrientation(DeviceUtils.getScreenOrientation(activity));
            }
        } else {
            this.lockOrientation(this.mForceOrientation.getActivityInfoOrientation());
        }
    }

    @VisibleForTesting
    void unApplyOrientation() {
        Activity activity = (Activity)this.mWeakActivity.get();
        if (activity != null && this.mOriginalActivityOrientation != null) {
            activity.setRequestedOrientation(this.mOriginalActivityOrientation.intValue());
        }
        this.mOriginalActivityOrientation = null;
    }

    @VisibleForTesting
    boolean shouldAllowForceOrientation(MraidOrientation newOrientation) {
        ActivityInfo activityInfo;
        if (newOrientation == MraidOrientation.NONE) {
            return true;
        }
        Activity activity = (Activity)this.mWeakActivity.get();
        if (activity == null) {
            return false;
        }
        try {
            activityInfo = activity.getPackageManager().getActivityInfo(new ComponentName((Context)activity, activity.getClass()), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        int activityOrientation = activityInfo.screenOrientation;
        if (activityOrientation != -1) {
            return activityOrientation == newOrientation.getActivityInfoOrientation();
        }
        boolean containsNecessaryConfigChanges = Utils.bitMaskContainsFlag(activityInfo.configChanges, 128);
        containsNecessaryConfigChanges = containsNecessaryConfigChanges && Utils.bitMaskContainsFlag(activityInfo.configChanges, 1024);
        return containsNecessaryConfigChanges;
    }

    @VisibleForTesting
    protected void handleCustomClose(boolean useCustomClose) {
        boolean wasUsingCustomClose = this.isUsingCustomClose();
        if (useCustomClose == wasUsingCustomClose) {
            return;
        }
        this.mCloseableAdContainer.setCloseVisible(!useCustomClose);
        if (this.mOnCloseButtonListener != null) {
            this.mOnCloseButtonListener.useCustomCloseChanged(useCustomClose);
        }
    }

    private boolean isUsingCustomClose() {
        return !this.mCloseableAdContainer.isCloseVisible();
    }

    @Override
    public BaseWebView createWebView() {
        return new MraidBridge.MraidWebView(this.mContext);
    }

    @Override
    protected void doFillContent(@NonNull String htmlData) {
        this.mMraidBridge.attachView((MraidBridge.MraidWebView)this.mWebView);
        this.mDefaultAdContainer.addView((View)this.mWebView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mMraidBridge.setContentHtml(htmlData);
    }

    @Override
    protected ViewGroup.LayoutParams getLayoutParams() {
        return new ViewGroup.LayoutParams(-1, -1);
    }

    @Override
    public void loadJavascript(@NonNull String javascript) {
        this.mMraidBridge.injectJavaScript(javascript);
    }

    @Override
    @NonNull
    public Context getContext() {
        return this.mContext;
    }

    @NonNull
    WeakReference<Activity> getWeakActivity() {
        return this.mWeakActivity;
    }

    @VisibleForTesting
    void handleSetOrientationProperties(boolean allowOrientationChange, MraidOrientation forceOrientation) throws MraidCommandException {
        if (!this.shouldAllowForceOrientation(forceOrientation)) {
            throw new MraidCommandException("Unable to force orientation to " + (Object)((Object)forceOrientation));
        }
        this.mAllowOrientationChange = allowOrientationChange;
        this.mForceOrientation = forceOrientation;
        if (this.mViewState == ViewState.EXPANDED || this.mPlacementType == PlacementType.INTERSTITIAL && !this.mIsPaused) {
            this.applyOrientation();
        }
    }

    @VisibleForTesting
    void handleOpen(@NonNull String url) {
        Uri uri;
        if (this.mBaseWebViewListener != null) {
            this.mBaseWebViewListener.onClicked();
        }
        if (UrlAction.HANDLE_PHONE_SCHEME.shouldTryHandlingUrl(uri = Uri.parse((String)url))) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM_WITH_THROWABLE, String.format("Uri scheme %s is not allowed.", uri.getScheme()), new MraidCommandException("Unsupported MRAID Javascript command"));
            return;
        }
        UrlHandler.Builder builder = new UrlHandler.Builder();
        if (!TextUtils.isEmpty((CharSequence)this.mDspCreativeId)) {
            builder.withDspCreativeId(this.mDspCreativeId);
        }
        EnumSet<UrlAction[]> urlActions = EnumSet.of(UrlAction.IGNORE_ABOUT_SCHEME, new UrlAction[]{UrlAction.OPEN_NATIVE_BROWSER, UrlAction.OPEN_IN_APP_BROWSER, UrlAction.HANDLE_SHARE_TWEET, UrlAction.FOLLOW_DEEP_LINK_WITH_FALLBACK, UrlAction.FOLLOW_DEEP_LINK});
        if (ManifestUtils.isDebuggable(this.mContext)) {
            urlActions.add((UrlAction[])UrlAction.HANDLE_MOPUB_SCHEME);
            builder.withMoPubSchemeListener(this.mDebugSchemeListener);
        }
        builder.withSupportedUrlActions(urlActions).build().handleUrl(this.mContext, url);
    }

    @Deprecated
    @VisibleForTesting
    @NonNull
    ViewState getViewState() {
        return this.mViewState;
    }

    @Deprecated
    @VisibleForTesting
    void setViewStateForTesting(@NonNull ViewState viewState) {
        this.mViewState = viewState;
    }

    @Deprecated
    @VisibleForTesting
    @NonNull
    CloseableLayout getExpandedAdContainer() {
        return this.mCloseableAdContainer;
    }

    @Deprecated
    @VisibleForTesting
    void setRootView(FrameLayout rootView) {
        this.mRootView = rootView;
    }

    @Deprecated
    @VisibleForTesting
    void setRootViewSize(int width, int height) {
        this.mScreenMetrics.setRootViewPosition(0, 0, width, height);
    }

    @Deprecated
    @VisibleForTesting
    Integer getOriginalActivityOrientation() {
        return this.mOriginalActivityOrientation;
    }

    @Deprecated
    @VisibleForTesting
    boolean getAllowOrientationChange() {
        return this.mAllowOrientationChange;
    }

    @Deprecated
    @VisibleForTesting
    MraidOrientation getForceOrientation() {
        return this.mForceOrientation;
    }

    @Deprecated
    @VisibleForTesting
    void setOrientationBroadcastReceiver(OrientationBroadcastReceiver receiver) {
        this.mOrientationBroadcastReceiver = receiver;
    }

    @Deprecated
    @VisibleForTesting
    MraidBridge.MraidWebView getMraidWebView() {
        return (MraidBridge.MraidWebView)this.mWebView;
    }

    @Deprecated
    @VisibleForTesting
    MraidBridge.MraidWebView getTwoPartWebView() {
        return this.mTwoPartWebView;
    }

    @VisibleForTesting
    class OrientationBroadcastReceiver
    extends BroadcastReceiver {
        @Nullable
        private Context mContext;
        private int mLastRotation = -1;

        OrientationBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            int orientation;
            if (this.mContext == null) {
                return;
            }
            if ("android.intent.action.CONFIGURATION_CHANGED".equals(intent.getAction()) && (orientation = MraidController.this.getDisplayRotation()) != this.mLastRotation) {
                this.mLastRotation = orientation;
                MraidController.this.handleOrientationChange(this.mLastRotation);
            }
        }

        public void register(@NonNull Context context) {
            Preconditions.checkNotNull(context);
            this.mContext = context.getApplicationContext();
            if (this.mContext != null) {
                this.mContext.registerReceiver((BroadcastReceiver)this, new IntentFilter("android.intent.action.CONFIGURATION_CHANGED"));
            }
        }

        public void unregister() {
            if (this.mContext != null) {
                this.mContext.unregisterReceiver((BroadcastReceiver)this);
                this.mContext = null;
            }
        }
    }

    public static interface UseCustomCloseListener {
        public void useCustomCloseChanged(boolean var1);
    }
}

