/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mraid;

import android.content.Context;
import android.content.res.Configuration;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import android.widget.VideoView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.mopub.common.util.Dips;
import com.mopub.mobileads.BaseVideoViewController;
import com.mopub.mobileads.base.R;

public class MraidVideoViewController
extends BaseVideoViewController {
    private static final float CLOSE_BUTTON_SIZE = 50.0f;
    private static final float CLOSE_BUTTON_PADDING = 8.0f;
    private final VideoView mVideoView;
    private ImageButton mCloseButton;
    private int mButtonPadding;
    private int mButtonSize;

    public MraidVideoViewController(Context context, Bundle intentExtras, Bundle savedInstanceState, BaseVideoViewController.BaseVideoViewControllerListener baseVideoViewControllerListener) {
        super(context, null, baseVideoViewControllerListener);
        this.mVideoView = new VideoView(context);
        this.mVideoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                mp.setVideoScalingMode(1);
            }
        });
        this.mVideoView.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                MraidVideoViewController.this.mCloseButton.setVisibility(0);
                MraidVideoViewController.this.videoCompleted(true);
            }
        });
        this.mVideoView.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mediaPlayer, int what, int extra) {
                MraidVideoViewController.this.mCloseButton.setVisibility(0);
                MraidVideoViewController.this.videoError(false);
                return false;
            }
        });
        this.mVideoView.setVideoPath(intentExtras.getString("video_url"));
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this.mButtonSize = Dips.asIntPixels(50.0f, this.getContext());
        this.mButtonPadding = Dips.asIntPixels(8.0f, this.getContext());
        this.createInterstitialCloseButton();
        this.mCloseButton.setVisibility(8);
        this.mVideoView.start();
    }

    protected VideoView getVideoView() {
        return this.mVideoView;
    }

    @Override
    protected void onDestroy() {
    }

    @Override
    protected void onPause() {
    }

    @Override
    protected void onResume() {
    }

    @Override
    protected void onSaveInstanceState(@NonNull Bundle outState) {
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
    }

    @Override
    protected void onBackPressed() {
    }

    private void createInterstitialCloseButton() {
        this.mCloseButton = new ImageButton(this.getContext());
        this.mCloseButton.setBackgroundDrawable(null);
        this.mCloseButton.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_mopub_close_button));
        this.mCloseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MraidVideoViewController.this.getBaseVideoViewControllerListener().onFinish();
            }
        });
        RelativeLayout.LayoutParams buttonLayout = new RelativeLayout.LayoutParams(this.mButtonSize, this.mButtonSize);
        buttonLayout.addRule(11);
        buttonLayout.setMargins(this.mButtonPadding, 0, this.mButtonPadding, 0);
        this.getLayout().addView((View)this.mCloseButton, (ViewGroup.LayoutParams)buttonLayout);
    }
}

