/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mraid;

import android.net.Uri;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.mopub.mobileads.resource.MraidJavascript;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Locale;

public class MraidWebViewClient
extends WebViewClient {
    private static final String MRAID_JS = "mraid.js";
    private static final String MRAID_INJECTION_JAVASCRIPT = "javascript:" + MraidJavascript.JAVASCRIPT_SOURCE;

    public WebResourceResponse shouldInterceptRequest(@NonNull WebView view, @NonNull String url) {
        if (this.matchesInjectionUrl(url)) {
            return this.createMraidInjectionResponse();
        }
        return super.shouldInterceptRequest(view, url);
    }

    @VisibleForTesting
    boolean matchesInjectionUrl(@NonNull String url) {
        Uri uri = Uri.parse((String)url.toLowerCase(Locale.US));
        return MRAID_JS.equals(uri.getLastPathSegment());
    }

    private WebResourceResponse createMraidInjectionResponse() {
        ByteArrayInputStream data = new ByteArrayInputStream(MRAID_INJECTION_JAVASCRIPT.getBytes());
        return new WebResourceResponse("text/javascript", "UTF-8", (InputStream)data);
    }
}

