/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.network;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.AdFormat;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.MoPubError;
import com.mopub.network.AdResponse;
import com.mopub.network.ContentDownloadAnalytics;
import com.mopub.network.MoPubNetworkError;
import com.mopub.network.MoPubRequestQueue;
import com.mopub.network.MultiAdRequest;
import com.mopub.network.MultiAdResponse;
import com.mopub.network.Networking;
import com.mopub.network.RequestRateTracker;
import com.mopub.volley.Request;
import com.mopub.volley.Response;
import com.mopub.volley.VolleyError;
import java.lang.ref.WeakReference;

public class AdLoader {
    private final MultiAdRequest.Listener mAdListener;
    private final WeakReference<Context> mContext;
    private final Listener mOriginalListener;
    @NonNull
    private MultiAdRequest mMultiAdRequest;
    @Nullable
    protected MultiAdResponse mMultiAdResponse;
    @NonNull
    private final Object lock = new Object();
    @Nullable
    protected AdResponse mLastDeliveredResponse = null;
    @Nullable
    private ContentDownloadAnalytics mDownloadTracker;
    private volatile boolean mRunning;
    private volatile boolean mFailed;
    private boolean mContentDownloaded;
    @NonNull
    private Handler mHandler;

    public AdLoader(@NonNull String url, @NonNull AdFormat adFormat, @Nullable String adUnitId, @NonNull Context context, @NonNull Listener listener) {
        Preconditions.checkArgument(!TextUtils.isEmpty((CharSequence)url));
        Preconditions.checkNotNull((Object)adFormat);
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(listener);
        this.mContext = new WeakReference<Context>(context);
        this.mOriginalListener = listener;
        this.mHandler = new Handler();
        this.mAdListener = new MultiAdRequest.Listener(){

            public void onErrorResponse(VolleyError volleyError) {
                MoPubLog.log(MoPubLog.AdLogEvent.RESPONSE_RECEIVED, volleyError.getMessage());
                AdLoader.this.mFailed = true;
                AdLoader.this.mRunning = false;
                AdLoader.this.deliverError(volleyError);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccessResponse(MultiAdResponse response) {
                Object object = AdLoader.this.lock;
                synchronized (object) {
                    AdLoader.this.mRunning = false;
                    AdLoader.this.mMultiAdResponse = response;
                    if (AdLoader.this.mMultiAdResponse.hasNext()) {
                        AdLoader.this.deliverResponse(AdLoader.this.mMultiAdResponse.next());
                    }
                }
            }
        };
        this.mRunning = false;
        this.mFailed = false;
        this.mMultiAdRequest = new MultiAdRequest(url, adFormat, adUnitId, context, this.mAdListener);
    }

    public boolean hasMoreAds() {
        if (this.mFailed) {
            return false;
        }
        if (this.mContentDownloaded) {
            return false;
        }
        MultiAdResponse response = this.mMultiAdResponse;
        return response == null || response.hasNext() || !response.isWaterfallFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Request<?> loadNextAd(@Nullable MoPubError errorCode) {
        if (this.mRunning) {
            return this.mMultiAdRequest;
        }
        if (this.mFailed) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    AdLoader.this.deliverError(new MoPubNetworkError(MoPubNetworkError.Reason.UNSPECIFIED));
                }
            });
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.mMultiAdResponse == null) {
                if (RequestRateTracker.getInstance().isBlockedByRateLimit(this.mMultiAdRequest.mAdUnitId)) {
                    MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, this.mMultiAdRequest.mAdUnitId + " is blocked by request rate limiting.");
                    this.mFailed = true;
                    this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            AdLoader.this.deliverError(new MoPubNetworkError(MoPubNetworkError.Reason.TOO_MANY_REQUESTS));
                        }
                    });
                    return null;
                }
                return this.fetchAd(this.mMultiAdRequest, (Context)this.mContext.get());
            }
            if (null != errorCode) {
                this.creativeDownloadFailed(errorCode);
            }
            if (this.mMultiAdResponse.hasNext()) {
                final AdResponse adResponse = this.mMultiAdResponse.next();
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        AdLoader.this.deliverResponse(adResponse);
                    }
                });
                return this.mMultiAdRequest;
            }
            if (!this.mMultiAdResponse.isWaterfallFinished()) {
                this.mMultiAdRequest = new MultiAdRequest(this.mMultiAdResponse.getFailURL(), this.mMultiAdRequest.mAdFormat, this.mMultiAdRequest.mAdUnitId, (Context)this.mContext.get(), this.mAdListener);
                return this.fetchAd(this.mMultiAdRequest, (Context)this.mContext.get());
            }
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                AdLoader.this.deliverError(new MoPubNetworkError(MoPubNetworkError.Reason.NO_FILL));
            }
        });
        return null;
    }

    public void creativeDownloadSuccess() {
        this.mContentDownloaded = true;
        if (null == this.mDownloadTracker) {
            MoPubLog.log(MoPubLog.AdLogEvent.CUSTOM, "Response analytics should not be null here");
            return;
        }
        Context context = (Context)this.mContext.get();
        if (null == context || null == this.mLastDeliveredResponse) {
            MoPubLog.log(MoPubLog.AdLogEvent.CUSTOM, "Cannot send 'x-after-load-url' analytics.");
            return;
        }
        this.mDownloadTracker.reportAfterLoad(context, null);
        this.mDownloadTracker.reportAfterLoadSuccess(context);
    }

    private void creativeDownloadFailed(@Nullable MoPubError errorCode) {
        if (null == errorCode) {
            MoPubLog.log(MoPubLog.AdLogEvent.CUSTOM, "Must provide error code to report creative download error");
            return;
        }
        Context context = (Context)this.mContext.get();
        if (null == context || null == this.mLastDeliveredResponse) {
            MoPubLog.log(MoPubLog.AdLogEvent.CUSTOM, "Cannot send creative mFailed analytics.");
            return;
        }
        if (this.mDownloadTracker != null) {
            this.mDownloadTracker.reportAfterLoad(context, errorCode);
            this.mDownloadTracker.reportAfterLoadFail(context, errorCode);
        }
    }

    @Nullable
    private Request<?> fetchAd(@NonNull MultiAdRequest request, @Nullable Context context) {
        Preconditions.checkNotNull((Object)request);
        if (context == null) {
            return null;
        }
        String bodyString = "<no body>";
        if (request.getBody() != null) {
            bodyString = new String(request.getBody());
        }
        MoPubLog.log(MoPubLog.AdLogEvent.REQUESTED, request.getUrl(), bodyString);
        this.mRunning = true;
        MoPubRequestQueue requestQueue = Networking.getRequestQueue(context);
        this.mMultiAdRequest = request;
        requestQueue.add(request);
        return request;
    }

    private void deliverError(@NonNull VolleyError volleyError) {
        Preconditions.checkNotNull(volleyError);
        this.mLastDeliveredResponse = null;
        if (this.mOriginalListener != null) {
            if (volleyError instanceof MoPubNetworkError) {
                this.mOriginalListener.onErrorResponse(volleyError);
            } else {
                this.mOriginalListener.onErrorResponse(new MoPubNetworkError(volleyError.getMessage(), volleyError.getCause(), MoPubNetworkError.Reason.UNSPECIFIED));
            }
        }
    }

    private void deliverResponse(@NonNull AdResponse adResponse) {
        Preconditions.checkNotNull(adResponse);
        Context context = (Context)this.mContext.get();
        this.mDownloadTracker = new ContentDownloadAnalytics(adResponse);
        this.mDownloadTracker.reportBeforeLoad(context);
        if (this.mOriginalListener != null) {
            this.mLastDeliveredResponse = adResponse;
            this.mOriginalListener.onSuccess(adResponse);
        }
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public boolean isFailed() {
        return this.mFailed;
    }

    public static interface Listener
    extends Response.ErrorListener {
        public void onSuccess(AdResponse var1);
    }
}

