/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.network;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.MoPub;
import com.mopub.common.Preconditions;
import com.mopub.common.ViewabilityVendor;
import com.mopub.common.util.DateAndTime;
import com.mopub.network.ImpressionData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.json.JSONObject;

public class AdResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final String mAdType;
    @Nullable
    private final String mAdGroupId;
    @Nullable
    private final String mAdUnitId;
    @Nullable
    private final String mFullAdType;
    @Nullable
    private final String mNetworkType;
    @Nullable
    private final String mRewardedVideoCurrencyName;
    @Nullable
    private final String mRewardedVideoCurrencyAmount;
    @Nullable
    private final String mRewardedCurrencies;
    @Nullable
    private final String mRewardedVideoCompletionUrl;
    @Nullable
    private final Integer mRewardedDuration;
    private final boolean mShouldRewardOnClick;
    @Nullable
    private final ImpressionData mImpressionData;
    @NonNull
    private final List<String> mClickTrackingUrls;
    @NonNull
    private final List<String> mImpressionTrackingUrls;
    @Nullable
    private final String mFailoverUrl;
    @NonNull
    private final List<String> mBeforeLoadUrls;
    @NonNull
    private final List<String> mAfterLoadUrls;
    @NonNull
    private final List<String> mAfterLoadSuccessUrls;
    @NonNull
    private final List<String> mAfterLoadFailUrls;
    @Nullable
    private final String mRequestId;
    @Nullable
    private final Integer mWidth;
    @Nullable
    private final Integer mHeight;
    @Nullable
    private final Integer mAdTimeoutDelayMillis;
    @Nullable
    private final Integer mRefreshTimeMillis;
    @Nullable
    private final String mBannerImpressionMinVisibleDips;
    @Nullable
    private final String mBannerImpressionMinVisibleMs;
    @Nullable
    private final String mDspCreativeId;
    @Nullable
    private final String mResponseBody;
    @Nullable
    private final JSONObject mJsonBody;
    @Nullable
    private final String mBaseAdClassName;
    @Nullable
    private final MoPub.BrowserAgent mBrowserAgent;
    @NonNull
    private final Map<String, String> mServerExtras;
    private final long mTimestamp;
    private final boolean mAllowCustomClose;
    @Nullable
    private final Set<ViewabilityVendor> mViewabilityVendors;

    private AdResponse(@NonNull Builder builder) {
        this.mAdType = builder.adType;
        this.mAdGroupId = builder.adGroupId;
        this.mAdUnitId = builder.adUnitId;
        this.mFullAdType = builder.fullAdType;
        this.mNetworkType = builder.networkType;
        this.mRewardedVideoCurrencyName = builder.rewardedVideoCurrencyName;
        this.mRewardedVideoCurrencyAmount = builder.rewardedVideoCurrencyAmount;
        this.mRewardedCurrencies = builder.rewardedCurrencies;
        this.mRewardedVideoCompletionUrl = builder.rewardedVideoCompletionUrl;
        this.mRewardedDuration = builder.rewardedDuration;
        this.mShouldRewardOnClick = builder.shouldRewardOnClick;
        this.mImpressionData = builder.impressionData;
        this.mClickTrackingUrls = builder.clickTrackingUrls;
        this.mImpressionTrackingUrls = builder.impressionTrackingUrls;
        this.mFailoverUrl = builder.failoverUrl;
        this.mBeforeLoadUrls = builder.beforeLoadUrls;
        this.mAfterLoadUrls = builder.afterLoadUrls;
        this.mAfterLoadSuccessUrls = builder.afterLoadSuccessUrls;
        this.mAfterLoadFailUrls = builder.afterLoadFailUrls;
        this.mRequestId = builder.requestId;
        this.mWidth = builder.width;
        this.mHeight = builder.height;
        this.mAdTimeoutDelayMillis = builder.adTimeoutDelayMillis;
        this.mRefreshTimeMillis = builder.refreshTimeMillis;
        this.mBannerImpressionMinVisibleDips = builder.bannerImpressionMinVisibleDips;
        this.mBannerImpressionMinVisibleMs = builder.bannerImpressionMinVisibleMs;
        this.mDspCreativeId = builder.dspCreativeId;
        this.mResponseBody = builder.responseBody;
        this.mJsonBody = builder.jsonBody;
        this.mBaseAdClassName = builder.customEventClassName;
        this.mBrowserAgent = builder.browserAgent;
        this.mServerExtras = builder.serverExtras;
        this.mTimestamp = DateAndTime.now().getTime();
        this.mAllowCustomClose = builder.allowCustomClose;
        this.mViewabilityVendors = builder.viewabilityVendors;
    }

    public boolean hasJson() {
        return this.mJsonBody != null;
    }

    @Nullable
    public JSONObject getJsonBody() {
        return this.mJsonBody;
    }

    @Nullable
    public String getStringBody() {
        return this.mResponseBody;
    }

    @Nullable
    public String getAdType() {
        return this.mAdType;
    }

    @Nullable
    public String getAdGroupId() {
        return this.mAdGroupId;
    }

    @Nullable
    public String getFullAdType() {
        return this.mFullAdType;
    }

    @Nullable
    public String getAdUnitId() {
        return this.mAdUnitId;
    }

    @Nullable
    public String getNetworkType() {
        return this.mNetworkType;
    }

    @Nullable
    public String getRewardedVideoCurrencyName() {
        return this.mRewardedVideoCurrencyName;
    }

    @Nullable
    public String getRewardedVideoCurrencyAmount() {
        return this.mRewardedVideoCurrencyAmount;
    }

    @Nullable
    public String getRewardedCurrencies() {
        return this.mRewardedCurrencies;
    }

    @Nullable
    public String getRewardedVideoCompletionUrl() {
        return this.mRewardedVideoCompletionUrl;
    }

    @Nullable
    public Integer getRewardedDuration() {
        return this.mRewardedDuration;
    }

    public boolean shouldRewardOnClick() {
        return this.mShouldRewardOnClick;
    }

    @Nullable
    public ImpressionData getImpressionData() {
        return this.mImpressionData;
    }

    @NonNull
    public List<String> getClickTrackingUrls() {
        return this.mClickTrackingUrls;
    }

    @NonNull
    public List<String> getImpressionTrackingUrls() {
        return this.mImpressionTrackingUrls;
    }

    @Deprecated
    @Nullable
    public String getFailoverUrl() {
        return this.mFailoverUrl;
    }

    @NonNull
    public List<String> getBeforeLoadUrls() {
        return this.mBeforeLoadUrls;
    }

    @NonNull
    public List<String> getAfterLoadUrls() {
        return this.mAfterLoadUrls;
    }

    @NonNull
    public List<String> getAfterLoadSuccessUrls() {
        return this.mAfterLoadSuccessUrls;
    }

    @NonNull
    public List<String> getAfterLoadFailUrls() {
        return this.mAfterLoadFailUrls;
    }

    @Nullable
    public String getRequestId() {
        return this.mRequestId;
    }

    @Nullable
    public Integer getWidth() {
        return this.mWidth;
    }

    @Nullable
    public Integer getHeight() {
        return this.mHeight;
    }

    @NonNull
    public Integer getAdTimeoutMillis(int defaultValue) {
        if (this.mAdTimeoutDelayMillis == null || this.mAdTimeoutDelayMillis < 1000) {
            return defaultValue;
        }
        return this.mAdTimeoutDelayMillis;
    }

    @Nullable
    public Integer getRefreshTimeMillis() {
        return this.mRefreshTimeMillis;
    }

    @Nullable
    public String getImpressionMinVisibleDips() {
        return this.mBannerImpressionMinVisibleDips;
    }

    @Nullable
    public String getImpressionMinVisibleMs() {
        return this.mBannerImpressionMinVisibleMs;
    }

    @Nullable
    public String getDspCreativeId() {
        return this.mDspCreativeId;
    }

    @Deprecated
    @Nullable
    public String getCustomEventClassName() {
        return this.getBaseAdClassName();
    }

    @Nullable
    public String getBaseAdClassName() {
        return this.mBaseAdClassName;
    }

    @Nullable
    public MoPub.BrowserAgent getBrowserAgent() {
        return this.mBrowserAgent;
    }

    @NonNull
    public Map<String, String> getServerExtras() {
        return new TreeMap<String, String>(this.mServerExtras);
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    public boolean allowCustomClose() {
        return this.mAllowCustomClose;
    }

    @Nullable
    public Set<ViewabilityVendor> getViewabilityVendors() {
        return this.mViewabilityVendors;
    }

    public Builder toBuilder() {
        return new Builder().setAdType(this.mAdType).setAdGroupId(this.mAdGroupId).setNetworkType(this.mNetworkType).setRewardedVideoCurrencyName(this.mRewardedVideoCurrencyName).setRewardedVideoCurrencyAmount(this.mRewardedVideoCurrencyAmount).setRewardedCurrencies(this.mRewardedCurrencies).setRewardedVideoCompletionUrl(this.mRewardedVideoCompletionUrl).setRewardedDuration(this.mRewardedDuration).setShouldRewardOnClick(this.mShouldRewardOnClick).setAllowCustomClose(this.mAllowCustomClose).setImpressionData(this.mImpressionData).setClickTrackingUrls(this.mClickTrackingUrls).setImpressionTrackingUrls(this.mImpressionTrackingUrls).setFailoverUrl(this.mFailoverUrl).setBeforeLoadUrls(this.mBeforeLoadUrls).setAfterLoadUrls(this.mAfterLoadUrls).setAfterLoadSuccessUrls(this.mAfterLoadSuccessUrls).setAfterLoadFailUrls(this.mAfterLoadFailUrls).setDimensions(this.mWidth, this.mHeight).setAdTimeoutDelayMilliseconds(this.mAdTimeoutDelayMillis).setRefreshTimeMilliseconds(this.mRefreshTimeMillis).setBannerImpressionMinVisibleDips(this.mBannerImpressionMinVisibleDips).setBannerImpressionMinVisibleMs(this.mBannerImpressionMinVisibleMs).setDspCreativeId(this.mDspCreativeId).setResponseBody(this.mResponseBody).setJsonBody(this.mJsonBody).setBaseAdClassName(this.mBaseAdClassName).setBrowserAgent(this.mBrowserAgent).setAllowCustomClose(this.mAllowCustomClose).setServerExtras(this.mServerExtras).setViewabilityVendors(this.mViewabilityVendors);
    }

    public static class Builder {
        private String adType;
        private String adGroupId;
        private String adUnitId;
        private String fullAdType;
        private String networkType;
        private String rewardedVideoCurrencyName;
        private String rewardedVideoCurrencyAmount;
        private String rewardedCurrencies;
        private String rewardedVideoCompletionUrl;
        private Integer rewardedDuration;
        private boolean shouldRewardOnClick;
        private ImpressionData impressionData;
        private List<String> clickTrackingUrls = new ArrayList<String>();
        private List<String> impressionTrackingUrls = new ArrayList<String>();
        private String failoverUrl;
        private List<String> beforeLoadUrls = new ArrayList<String>();
        private List<String> afterLoadUrls = new ArrayList<String>();
        private List<String> afterLoadSuccessUrls = new ArrayList<String>();
        private List<String> afterLoadFailUrls = new ArrayList<String>();
        private String requestId;
        private Integer width;
        private Integer height;
        private Integer adTimeoutDelayMillis;
        private Integer refreshTimeMillis;
        private String bannerImpressionMinVisibleDips;
        private String bannerImpressionMinVisibleMs;
        private String dspCreativeId;
        private String responseBody;
        private JSONObject jsonBody;
        private String customEventClassName;
        private MoPub.BrowserAgent browserAgent;
        private Map<String, String> serverExtras = new TreeMap<String, String>();
        private boolean allowCustomClose = false;
        private Set<ViewabilityVendor> viewabilityVendors = null;

        public Builder setAdType(@Nullable String adType) {
            this.adType = adType;
            return this;
        }

        public Builder setAdGroupId(@Nullable String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder setAdUnitId(@Nullable String adUnitId) {
            this.adUnitId = adUnitId;
            return this;
        }

        public Builder setFullAdType(@Nullable String fullAdType) {
            this.fullAdType = fullAdType;
            return this;
        }

        public Builder setNetworkType(@Nullable String networkType) {
            this.networkType = networkType;
            return this;
        }

        public Builder setRewardedVideoCurrencyName(@Nullable String rewardedVideoCurrencyName) {
            this.rewardedVideoCurrencyName = rewardedVideoCurrencyName;
            return this;
        }

        public Builder setRewardedVideoCurrencyAmount(@Nullable String rewardedVideoCurrencyAmount) {
            this.rewardedVideoCurrencyAmount = rewardedVideoCurrencyAmount;
            return this;
        }

        public Builder setRewardedCurrencies(@Nullable String rewardedCurrencies) {
            this.rewardedCurrencies = rewardedCurrencies;
            return this;
        }

        public Builder setRewardedVideoCompletionUrl(@Nullable String rewardedVideoCompletionUrl) {
            this.rewardedVideoCompletionUrl = rewardedVideoCompletionUrl;
            return this;
        }

        public Builder setRewardedDuration(@Nullable Integer rewardedDuration) {
            this.rewardedDuration = rewardedDuration;
            return this;
        }

        public Builder setShouldRewardOnClick(boolean shouldRewardOnClick) {
            this.shouldRewardOnClick = shouldRewardOnClick;
            return this;
        }

        public Builder setImpressionData(@Nullable ImpressionData impressionData) {
            this.impressionData = impressionData;
            return this;
        }

        public Builder setClickTrackingUrls(@NonNull List<String> clickTrackingUrls) {
            Preconditions.checkNotNull(clickTrackingUrls);
            this.clickTrackingUrls = clickTrackingUrls;
            return this;
        }

        public Builder setImpressionTrackingUrls(@NonNull List<String> impressionTrackingUrls) {
            Preconditions.checkNotNull(impressionTrackingUrls);
            this.impressionTrackingUrls = impressionTrackingUrls;
            return this;
        }

        public Builder setFailoverUrl(@Nullable String failoverUrl) {
            this.failoverUrl = failoverUrl;
            return this;
        }

        public Builder setBeforeLoadUrls(@NonNull List<String> beforeLoadUrls) {
            Preconditions.checkNotNull(beforeLoadUrls);
            this.beforeLoadUrls = beforeLoadUrls;
            return this;
        }

        public Builder setAfterLoadUrls(@NonNull List<String> afterLoadUrls) {
            Preconditions.checkNotNull(afterLoadUrls);
            this.afterLoadUrls = afterLoadUrls;
            return this;
        }

        public Builder setAfterLoadSuccessUrls(@NonNull List<String> afterLoadSuccessUrls) {
            Preconditions.checkNotNull(afterLoadSuccessUrls);
            this.afterLoadSuccessUrls = afterLoadSuccessUrls;
            return this;
        }

        public Builder setAfterLoadFailUrls(@NonNull List<String> afterLoadFailUrls) {
            Preconditions.checkNotNull(afterLoadFailUrls);
            this.afterLoadFailUrls = afterLoadFailUrls;
            return this;
        }

        public Builder setRequestId(@Nullable String requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder setDimensions(@Nullable Integer width, @Nullable Integer height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder setAdTimeoutDelayMilliseconds(@Nullable Integer adTimeoutDelayMilliseconds) {
            this.adTimeoutDelayMillis = adTimeoutDelayMilliseconds;
            return this;
        }

        public Builder setRefreshTimeMilliseconds(@Nullable Integer refreshTimeMilliseconds) {
            this.refreshTimeMillis = refreshTimeMilliseconds;
            return this;
        }

        public Builder setBannerImpressionMinVisibleDips(@Nullable String bannerImpressionMinVisibleDips) {
            this.bannerImpressionMinVisibleDips = bannerImpressionMinVisibleDips;
            return this;
        }

        public Builder setBannerImpressionMinVisibleMs(@Nullable String bannerImpressionMinVisibleMs) {
            this.bannerImpressionMinVisibleMs = bannerImpressionMinVisibleMs;
            return this;
        }

        public Builder setDspCreativeId(@Nullable String dspCreativeId) {
            this.dspCreativeId = dspCreativeId;
            return this;
        }

        public Builder setResponseBody(@Nullable String responseBody) {
            this.responseBody = responseBody;
            return this;
        }

        public Builder setJsonBody(@Nullable JSONObject jsonBody) {
            this.jsonBody = jsonBody;
            return this;
        }

        public Builder setBaseAdClassName(@Nullable String customEventClassName) {
            this.customEventClassName = customEventClassName;
            return this;
        }

        public Builder setBrowserAgent(@Nullable MoPub.BrowserAgent browserAgent) {
            this.browserAgent = browserAgent;
            return this;
        }

        public Builder setServerExtras(@Nullable Map<String, String> serverExtras) {
            this.serverExtras = serverExtras == null ? new TreeMap<String, String>() : new TreeMap<String, String>(serverExtras);
            return this;
        }

        public Builder setAllowCustomClose(boolean allow) {
            this.allowCustomClose = allow;
            return this;
        }

        public Builder setViewabilityVendors(@Nullable Set<ViewabilityVendor> viewabilityVendors) {
            this.viewabilityVendors = viewabilityVendors;
            return this;
        }

        public AdResponse build() {
            return new AdResponse(this);
        }
    }
}

