/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.network;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.ResponseHeader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HeaderUtils {
    @NonNull
    public static String extractHeader(@Nullable JSONObject headers, @NonNull ResponseHeader responseHeader) {
        Preconditions.checkNotNull((Object)responseHeader);
        if (headers == null) {
            return "";
        }
        return headers.optString(responseHeader.getKey());
    }

    @Nullable
    public static JSONObject extractJsonObjectHeader(@Nullable JSONObject headers, @NonNull ResponseHeader responseHeader) {
        Preconditions.checkNotNull((Object)responseHeader);
        if (headers == null) {
            return null;
        }
        return headers.optJSONObject(responseHeader.getKey());
    }

    @Nullable
    public static JSONArray extractJsonArrayHeader(@Nullable JSONObject headers, @NonNull ResponseHeader responseHeader) {
        Preconditions.checkNotNull((Object)responseHeader);
        if (headers == null) {
            return null;
        }
        return headers.optJSONArray(responseHeader.getKey());
    }

    @Nullable
    public static Integer extractIntegerHeader(JSONObject headers, ResponseHeader responseHeader) {
        return HeaderUtils.formatIntHeader(HeaderUtils.extractHeader(headers, responseHeader));
    }

    @NonNull
    public static Integer extractIntegerHeader(JSONObject headers, ResponseHeader responseHeader, int defaultValue) {
        return HeaderUtils.formatIntHeader(HeaderUtils.extractHeader(headers, responseHeader), defaultValue);
    }

    public static boolean extractBooleanHeader(JSONObject headers, ResponseHeader responseHeader, boolean defaultValue) {
        return HeaderUtils.formatBooleanHeader(HeaderUtils.extractHeader(headers, responseHeader), defaultValue);
    }

    @Nullable
    public static Integer extractPercentHeader(JSONObject headers, ResponseHeader responseHeader) {
        return HeaderUtils.formatPercentHeader(HeaderUtils.extractHeader(headers, responseHeader));
    }

    @NonNull
    static List<String> extractStringArray(@NonNull JSONObject headers, @NonNull ResponseHeader responseHeader) {
        Preconditions.checkNotNull(headers);
        Preconditions.checkNotNull((Object)responseHeader);
        ArrayList<String> stringArray = new ArrayList<String>();
        JSONArray jsonArray = headers.optJSONArray(responseHeader.getKey());
        if (jsonArray == null) {
            return stringArray;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            try {
                stringArray.add(jsonArray.getString(i));
                continue;
            }
            catch (JSONException e) {
                MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Unable to parse item " + i + " from " + responseHeader.getKey());
            }
        }
        return stringArray;
    }

    @Nullable
    static String extractPercentHeaderString(JSONObject headers, ResponseHeader responseHeader) {
        Integer percentHeaderValue = HeaderUtils.extractPercentHeader(headers, responseHeader);
        return percentHeaderValue != null ? percentHeaderValue.toString() : null;
    }

    private static boolean formatBooleanHeader(@Nullable String headerValue, boolean defaultValue) {
        if (headerValue == null) {
            return defaultValue;
        }
        return headerValue.equals("1");
    }

    @NonNull
    private static Integer formatIntHeader(String headerValue, int defaultValue) {
        Integer value = HeaderUtils.formatIntHeader(headerValue);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Nullable
    private static Integer formatIntHeader(String headerValue) {
        try {
            return Integer.parseInt(headerValue);
        }
        catch (Exception exception) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setParseIntegerOnly(true);
            try {
                Number value = numberFormat.parse(headerValue.trim());
                return value.intValue();
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    @Nullable
    private static Integer formatPercentHeader(@Nullable String headerValue) {
        if (headerValue == null) {
            return null;
        }
        Integer percentValue = HeaderUtils.formatIntHeader(headerValue.replace("%", ""));
        if (percentValue == null || percentValue < 0 || percentValue > 100) {
            return null;
        }
        return percentValue;
    }
}

