/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.network;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.logging.MoPubLog;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

public class ImpressionData
implements Serializable {
    private static final long serialVersionUID = 82L;
    public static final String APP_VERSION = "app_version";
    public static final String ADUNIT_ID = "adunit_id";
    public static final String ADUNIT_NAME = "adunit_name";
    public static final String ADUNIT_FORMAT = "adunit_format";
    public static final String IMPRESSION_ID = "id";
    public static final String CURRENCY = "currency";
    public static final String PUBLISHER_REVENUE = "publisher_revenue";
    public static final String ADGROUP_ID = "adgroup_id";
    public static final String ADGROUP_NAME = "adgroup_name";
    public static final String ADGROUP_TYPE = "adgroup_type";
    public static final String ADGROUP_PRIORITY = "adgroup_priority";
    public static final String COUNTRY = "country";
    public static final String PRECISION = "precision";
    public static final String NETWORK_NAME = "network_name";
    public static final String NETWORK_PLACEMENT_ID = "network_placement_id";
    @NonNull
    private SerializableJson mJson;

    private ImpressionData(@NonNull JSONObject json) throws JSONException {
        this.mJson = new SerializableJson(json);
    }

    @Nullable
    static ImpressionData create(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        try {
            return new ImpressionData(jsonObject);
        }
        catch (Exception ex) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, ex.toString());
            return null;
        }
    }

    @Nullable
    public String getAppVersion() {
        return this.mJson.optString(APP_VERSION, null);
    }

    @Nullable
    public String getAdUnitId() {
        return this.mJson.optString(ADUNIT_ID, null);
    }

    @Nullable
    public String getAdUnitName() {
        return this.mJson.optString(ADUNIT_NAME, null);
    }

    @Nullable
    public String getAdUnitFormat() {
        return this.mJson.optString(ADUNIT_FORMAT, null);
    }

    @Nullable
    public String getImpressionId() {
        return this.mJson.optString(IMPRESSION_ID, null);
    }

    @Nullable
    public String getCurrency() {
        return this.mJson.optString(CURRENCY, null);
    }

    @Nullable
    public Double getPublisherRevenue() {
        try {
            return this.mJson.getDouble(PUBLISHER_REVENUE);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    public String getAdGroupId() {
        return this.mJson.optString(ADGROUP_ID, null);
    }

    @Nullable
    public String getAdGroupName() {
        return this.mJson.optString(ADGROUP_NAME, null);
    }

    @Nullable
    public String getAdGroupType() {
        return this.mJson.optString(ADGROUP_TYPE, null);
    }

    @Nullable
    public Integer getAdGroupPriority() {
        try {
            return this.mJson.getInt(ADGROUP_PRIORITY);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Nullable
    public String getCountry() {
        return this.mJson.optString(COUNTRY, null);
    }

    @Nullable
    public String getPrecision() {
        return this.mJson.optString(PRECISION, null);
    }

    @Nullable
    public String getNetworkName() {
        return this.mJson.optString(NETWORK_NAME, null);
    }

    @Nullable
    public String getNetworkPlacementId() {
        return this.mJson.optString(NETWORK_PLACEMENT_ID, null);
    }

    @NonNull
    public JSONObject getJsonRepresentation() {
        return this.mJson;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeUTF(this.mJson.toString());
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException, JSONException {
        ois.defaultReadObject();
        this.mJson = new SerializableJson(ois.readUTF());
    }

    private static class SerializableJson
    extends JSONObject
    implements Serializable {
        SerializableJson(@NonNull JSONObject json) throws JSONException {
            super(json.toString());
        }

        SerializableJson(@NonNull String json) throws JSONException {
            super(json);
        }
    }
}

