/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.network;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.network.ImpressionData;
import com.mopub.network.ImpressionListener;
import java.util.HashSet;
import java.util.Set;

public class ImpressionsEmitter {
    private static final HashSet<ImpressionListener> mListeners = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(@NonNull ImpressionListener listener) {
        Preconditions.checkNotNull(listener);
        Class<ImpressionsEmitter> clazz = ImpressionsEmitter.class;
        synchronized (ImpressionsEmitter.class) {
            mListeners.add(listener);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(@NonNull ImpressionListener listener) {
        Preconditions.checkNotNull(listener);
        Class<ImpressionsEmitter> clazz = ImpressionsEmitter.class;
        synchronized (ImpressionsEmitter.class) {
            mListeners.remove(listener);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static void send(@NonNull String adUnitId, @Nullable ImpressionData impressionData) {
        Preconditions.checkNotNull(adUnitId);
        Set<ImpressionListener> listenerSet = ImpressionsEmitter.cloneListeners();
        for (ImpressionListener listener : listenerSet) {
            listener.onImpression(adUnitId, impressionData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<ImpressionListener> cloneListeners() {
        Class<ImpressionsEmitter> clazz = ImpressionsEmitter.class;
        synchronized (ImpressionsEmitter.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return new HashSet<ImpressionListener>(mListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void clear() {
        Class<ImpressionsEmitter> clazz = ImpressionsEmitter.class;
        synchronized (ImpressionsEmitter.class) {
            mListeners.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

