/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.network;

import android.content.Context;
import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.common.util.ResponseHeader;
import com.mopub.network.MoPubRequestUtils;
import com.mopub.volley.NetworkResponse;
import com.mopub.volley.Request;
import com.mopub.volley.Response;
import com.mopub.volley.toolbox.HttpHeaderParser;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public abstract class MoPubRequest<T>
extends Request<T> {
    private static final String JSON_CONTENT_TYPE = "application/json; charset=UTF-8";
    @NonNull
    private final String mOriginalUrl;
    @NonNull
    private final Context mContext;

    public MoPubRequest(@NonNull Context context, @NonNull String url, @Nullable Response.ErrorListener listener) {
        super(MoPubRequestUtils.chooseMethod(url), MoPubRequestUtils.truncateQueryParamsIfPost(url), listener);
        this.mOriginalUrl = url;
        this.mContext = context.getApplicationContext();
    }

    protected Map<String, String> getParams() {
        if (!MoPubRequestUtils.isMoPubRequest(this.getUrl())) {
            return null;
        }
        return MoPubRequestUtils.convertQueryToMap(this.mContext, this.mOriginalUrl);
    }

    public String getBodyContentType() {
        if (MoPubRequestUtils.isMoPubRequest(this.getUrl())) {
            return JSON_CONTENT_TYPE;
        }
        return super.getBodyContentType();
    }

    public byte[] getBody() {
        String body = MoPubRequestUtils.generateBodyFromParams(this.getParams(), this.getUrl());
        if (body == null) {
            return null;
        }
        return body.getBytes();
    }

    @NonNull
    protected String parseStringBody(@NonNull NetworkResponse response) {
        String parsed;
        Preconditions.checkNotNull(response);
        try {
            parsed = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers));
        }
        catch (UnsupportedEncodingException e) {
            parsed = new String(response.data);
        }
        return parsed;
    }

    @NonNull
    public String getOriginalUrl() {
        return this.mOriginalUrl;
    }

    public Map<String, String> getHeaders() {
        String country;
        String language;
        TreeMap<String, String> headers = new TreeMap<String, String>();
        Locale userLocale = null;
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleList list = this.mContext.getResources().getConfiguration().getLocales();
            if (list.size() > 0) {
                userLocale = list.get(0);
            }
        } else {
            userLocale = this.mContext.getResources().getConfiguration().locale;
        }
        if (userLocale != null && !TextUtils.isEmpty((CharSequence)userLocale.toString().trim())) {
            language = userLocale.getLanguage().trim();
            country = userLocale.getCountry().trim();
        } else {
            language = Locale.getDefault().getLanguage().trim();
            country = Locale.getDefault().getCountry().trim();
        }
        if (!TextUtils.isEmpty((CharSequence)language)) {
            String languageCode = language;
            if (!TextUtils.isEmpty((CharSequence)country)) {
                languageCode = languageCode + "-" + country.toLowerCase();
            }
            headers.put(ResponseHeader.ACCEPT_LANGUAGE.getKey(), languageCode);
        }
        return headers;
    }
}

