/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.network;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.Constants;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.network.Networking;
import com.mopub.volley.toolbox.HurlStack;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class MoPubRequestUtils {
    public static String truncateQueryParamsIfPost(@NonNull String url) {
        Preconditions.checkNotNull(url);
        if (!MoPubRequestUtils.isMoPubRequest(url)) {
            return url;
        }
        int queryPosition = url.indexOf(63);
        if (queryPosition == -1) {
            return url;
        }
        return url.substring(0, queryPosition);
    }

    public static boolean isMoPubRequest(@NonNull String url) {
        Preconditions.checkNotNull(url);
        String httpHost = "http://" + Constants.HOST;
        String httpsHost = "https://" + Constants.HOST;
        return url.startsWith(httpHost) || url.startsWith(httpsHost);
    }

    public static int chooseMethod(String url) {
        if (MoPubRequestUtils.isMoPubRequest(url)) {
            return 1;
        }
        return 0;
    }

    @NonNull
    public static Map<String, String> convertQueryToMap(@NonNull Context context, @NonNull String url) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(url);
        HurlStack.UrlRewriter rewriter = Networking.getUrlRewriter(context);
        Uri uri = Uri.parse((String)rewriter.rewriteUrl(url));
        return MoPubRequestUtils.getQueryParamMap(uri);
    }

    @NonNull
    public static Map<String, String> getQueryParamMap(@NonNull Uri uri) {
        Preconditions.checkNotNull(uri);
        HashMap<String, String> params = new HashMap<String, String>();
        for (String queryParam : uri.getQueryParameterNames()) {
            params.put(queryParam, TextUtils.join((CharSequence)",", (Iterable)uri.getQueryParameters(queryParam)));
        }
        return params;
    }

    @Nullable
    public static String generateBodyFromParams(@Nullable Map<String, String> params, @NonNull String url) {
        Preconditions.checkNotNull(url);
        if (!MoPubRequestUtils.isMoPubRequest(url) || params == null || params.isEmpty()) {
            return null;
        }
        JSONObject jsonBody = new JSONObject();
        for (String queryName : params.keySet()) {
            try {
                jsonBody.put(queryName, (Object)params.get(queryName));
            }
            catch (JSONException e) {
                MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Unable to add " + queryName + " to JSON body.");
            }
        }
        return jsonBody.toString();
    }

    private MoPubRequestUtils() {
    }
}

