/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.network;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.AdFormat;
import com.mopub.common.MoPub;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.privacy.PersonalInfoManager;
import com.mopub.network.MoPubNetworkError;
import com.mopub.network.MoPubRequest;
import com.mopub.network.MultiAdResponse;
import com.mopub.volley.Cache;
import com.mopub.volley.DefaultRetryPolicy;
import com.mopub.volley.NetworkResponse;
import com.mopub.volley.Response;
import com.mopub.volley.RetryPolicy;
import com.mopub.volley.VolleyError;
import com.mopub.volley.toolbox.HttpHeaderParser;

public class MultiAdRequest
extends MoPubRequest<MultiAdResponse> {
    @NonNull
    public final Listener mListener;
    @NonNull
    final AdFormat mAdFormat;
    @Nullable
    final String mAdUnitId;
    @NonNull
    private final Context mContext;
    private int hashCode = 0;

    MultiAdRequest(@NonNull String url, @NonNull AdFormat adFormat, @Nullable String adUnitId, @NonNull Context context, @NonNull Listener listener) {
        super(context, MultiAdRequest.clearUrlIfSdkNotInitialized(url), listener);
        Preconditions.checkNotNull(url);
        Preconditions.checkNotNull((Object)adFormat);
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(listener);
        this.mAdUnitId = adUnitId;
        this.mListener = listener;
        this.mAdFormat = adFormat;
        this.mContext = context.getApplicationContext();
        DefaultRetryPolicy retryPolicy = new DefaultRetryPolicy(2500, 1, 1.0f);
        this.setRetryPolicy((RetryPolicy)retryPolicy);
        this.setShouldCache(false);
        PersonalInfoManager personalInfoManager = MoPub.getPersonalInformationManager();
        if (personalInfoManager != null) {
            personalInfoManager.requestSync(false);
        }
    }

    @NonNull
    private static String clearUrlIfSdkNotInitialized(@NonNull String url) {
        if (MoPub.getPersonalInformationManager() == null || !MoPub.isSdkInitialized()) {
            MoPubLog.log(MoPubLog.AdLogEvent.CUSTOM, "Make sure to call MoPub#initializeSdk before loading an ad.");
            return "";
        }
        return url;
    }

    @Nullable
    protected Response<MultiAdResponse> parseNetworkResponse(NetworkResponse networkResponse) {
        MultiAdResponse multiAdResponse;
        try {
            multiAdResponse = new MultiAdResponse(this.mContext, networkResponse, this.mAdFormat, this.mAdUnitId);
        }
        catch (Exception ex) {
            if (ex instanceof MoPubNetworkError) {
                return Response.error((VolleyError)((MoPubNetworkError)((Object)ex)));
            }
            return Response.error((VolleyError)new MoPubNetworkError(ex, MoPubNetworkError.Reason.UNSPECIFIED));
        }
        return Response.success((Object)multiAdResponse, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)networkResponse));
    }

    protected void deliverResponse(MultiAdResponse multiAdResponse) {
        if (!this.isCanceled()) {
            this.mListener.onSuccessResponse(multiAdResponse);
        }
    }

    public void cancel() {
        super.cancel();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MultiAdRequest)) {
            return false;
        }
        MultiAdRequest other = (MultiAdRequest)((Object)obj);
        int res = 0;
        if (this.mAdUnitId != null) {
            res = other.mAdUnitId == null ? 1 : this.mAdUnitId.compareTo(other.mAdUnitId);
        } else if (other.mAdUnitId != null) {
            res = -1;
        }
        return res == 0 && this.mAdFormat == other.mAdFormat && this.getUrl().compareTo(other.getUrl()) == 0;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = this.mAdUnitId == null ? 29 : this.mAdUnitId.hashCode();
            result = 31 * result + this.mAdFormat.hashCode();
            this.hashCode = result = 31 * result + this.getOriginalUrl().hashCode();
        }
        return this.hashCode;
    }

    public static interface Listener
    extends Response.ErrorListener {
        public void onSuccessResponse(MultiAdResponse var1);
    }
}

