/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.network;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.AdFormat;
import com.mopub.common.MoPub;
import com.mopub.common.Preconditions;
import com.mopub.common.ViewabilityVendor;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Json;
import com.mopub.common.util.ResponseHeader;
import com.mopub.mobileads.AdTypeTranslator;
import com.mopub.network.AdResponse;
import com.mopub.network.HeaderUtils;
import com.mopub.network.ImpressionData;
import com.mopub.network.MoPubNetworkError;
import com.mopub.network.RequestRateTracker;
import com.mopub.volley.NetworkResponse;
import com.mopub.volley.toolbox.HttpHeaderParser;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MultiAdResponse
implements Iterator<AdResponse> {
    private static final String EMPTY_JSON_ARRAY = "[]";
    @NonNull
    private final Iterator<AdResponse> mResponseIterator;
    @NonNull
    private String mFailUrl;
    @Nullable
    private static ServerOverrideListener sServerOverrideListener;

    @NonNull
    public String getFailURL() {
        return this.mFailUrl;
    }

    public MultiAdResponse(@NonNull Context appContext, @NonNull NetworkResponse networkResponse, @NonNull AdFormat adFormat, @Nullable String adUnitId) throws JSONException, MoPubNetworkError {
        boolean enableDebugLogging;
        String responseBody = MultiAdResponse.parseStringBody(networkResponse);
        JSONObject jsonObject = new JSONObject(responseBody);
        this.mFailUrl = jsonObject.optString(ResponseHeader.FAIL_URL.getKey());
        String adUnitFormat = jsonObject.optString(ResponseHeader.ADUNIT_FORMAT.getKey());
        String requestId = jsonObject.optString(ResponseHeader.REQUEST_ID.getKey());
        Integer backoffMs = HeaderUtils.extractIntegerHeader(jsonObject, ResponseHeader.BACKOFF_MS);
        String backoffReason = HeaderUtils.extractHeader(jsonObject, ResponseHeader.BACKOFF_REASON);
        RequestRateTracker.getInstance().registerRateLimit(adUnitId, backoffMs, backoffReason);
        boolean invalidateConsent = HeaderUtils.extractBooleanHeader(jsonObject, ResponseHeader.INVALIDATE_CONSENT, false);
        boolean forceExplicitNo = HeaderUtils.extractBooleanHeader(jsonObject, ResponseHeader.FORCE_EXPLICIT_NO, false);
        boolean reacquireConsent = HeaderUtils.extractBooleanHeader(jsonObject, ResponseHeader.REACQUIRE_CONSENT, false);
        String consentChangeReason = HeaderUtils.extractHeader(jsonObject, ResponseHeader.CONSENT_CHANGE_REASON);
        boolean forceGdprApplies = HeaderUtils.extractBooleanHeader(jsonObject, ResponseHeader.FORCE_GDPR_APPLIES, false);
        if (sServerOverrideListener != null) {
            if (forceGdprApplies) {
                sServerOverrideListener.onForceGdprApplies();
            }
            if (forceExplicitNo) {
                sServerOverrideListener.onForceExplicitNo(consentChangeReason);
            } else if (invalidateConsent) {
                sServerOverrideListener.onInvalidateConsent(consentChangeReason);
            } else if (reacquireConsent) {
                sServerOverrideListener.onReacquireConsent(consentChangeReason);
            }
            sServerOverrideListener.onRequestSuccess(adUnitId);
        }
        if (enableDebugLogging = HeaderUtils.extractBooleanHeader(jsonObject, ResponseHeader.ENABLE_DEBUG_LOGGING, false)) {
            MoPubLog.setLogLevel(MoPubLog.LogLevel.DEBUG);
        }
        JSONArray adResponses = jsonObject.getJSONArray(ResponseHeader.AD_RESPONSES.getKey());
        int ADS_PER_RESPONSE = 3;
        ArrayList<AdResponse> list = new ArrayList<AdResponse>(ADS_PER_RESPONSE);
        AdResponse adResponseClear = null;
        for (int i = 0; i < adResponses.length(); ++i) {
            try {
                JSONObject item = adResponses.getJSONObject(i);
                AdResponse singleAdResponse = MultiAdResponse.parseSingleAdResponse(appContext, networkResponse, item, adUnitId, adFormat, adUnitFormat, requestId);
                if (!"clear".equals(singleAdResponse.getAdType())) {
                    list.add(singleAdResponse);
                    continue;
                }
                this.mFailUrl = "";
                adResponseClear = singleAdResponse;
                if (!MultiAdResponse.extractWarmup(item)) break;
                throw new MoPubNetworkError("Server is preparing this Ad Unit.", MoPubNetworkError.Reason.WARMING_UP, adResponseClear.getRefreshTimeMillis());
            }
            catch (JSONException ex) {
                MoPubLog.log(MoPubLog.AdLogEvent.CUSTOM, "Invalid response item. Body: " + responseBody);
                continue;
            }
            catch (MoPubNetworkError ex) {
                if (ex.getReason() == MoPubNetworkError.Reason.WARMING_UP) {
                    throw ex;
                }
                MoPubLog.log(MoPubLog.AdLogEvent.CUSTOM, "Invalid response item. Error: " + (Object)((Object)ex.getReason()));
                continue;
            }
            catch (Exception ex) {
                MoPubLog.log(MoPubLog.AdLogEvent.CUSTOM, "Unexpected error parsing response item. " + ex.getMessage());
            }
        }
        this.mResponseIterator = list.iterator();
        if (!this.mResponseIterator.hasNext()) {
            Integer refreshTimeMilliseconds = 30000;
            if (adResponseClear != null) {
                refreshTimeMilliseconds = adResponseClear.getRefreshTimeMillis();
            }
            throw new MoPubNetworkError("No ads found for ad unit.", MoPubNetworkError.Reason.NO_FILL, refreshTimeMilliseconds);
        }
    }

    @Override
    public boolean hasNext() {
        return this.mResponseIterator.hasNext();
    }

    @Override
    @NonNull
    public AdResponse next() {
        return this.mResponseIterator.next();
    }

    boolean isWaterfallFinished() {
        return TextUtils.isEmpty((CharSequence)this.mFailUrl);
    }

    public static void setServerOverrideListener(@NonNull ServerOverrideListener serverOverrideListener) {
        sServerOverrideListener = serverOverrideListener;
    }

    @NonNull
    protected static AdResponse parseSingleAdResponse(@NonNull Context appContext, @NonNull NetworkResponse networkResponse, @NonNull JSONObject jsonObject, @Nullable String adUnitId, @NonNull AdFormat adFormat, @NonNull String adUnitFormat, @Nullable String requestId) throws JSONException, MoPubNetworkError {
        String disabledViewabilityVendors;
        String videoTrackers;
        Map<String, String> serverExtras;
        String afterLoadFailUrl;
        String afterLoadSuccessUrl;
        String afterLoadUrl;
        String beforeLoadUrl;
        String impressionUrl;
        String clickTrackingUrl;
        Preconditions.checkNotNull(appContext);
        Preconditions.checkNotNull(networkResponse);
        Preconditions.checkNotNull(jsonObject);
        Preconditions.checkNotNull((Object)adFormat);
        Preconditions.checkNotNull(adUnitFormat);
        MoPubLog.log(MoPubLog.AdLogEvent.RESPONSE_RECEIVED, jsonObject.toString());
        AdResponse.Builder builder = new AdResponse.Builder();
        String content = jsonObject.optString(ResponseHeader.CONTENT.getKey());
        JSONObject jsonHeaders = jsonObject.getJSONObject(ResponseHeader.METADATA.getKey());
        builder.setAdUnitId(adUnitId);
        builder.setResponseBody(content);
        String adTypeString = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.AD_TYPE);
        String adGroupIdString = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.AD_GROUP_ID);
        String fullAdTypeString = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.FULL_AD_TYPE);
        builder.setAdType(adTypeString);
        builder.setAdGroupId(adGroupIdString);
        builder.setFullAdType(fullAdTypeString);
        Integer refreshTimeMilliseconds = MultiAdResponse.extractRefreshTimeMS(jsonObject);
        builder.setRefreshTimeMilliseconds(refreshTimeMilliseconds);
        if ("clear".equals(adTypeString)) {
            return builder.build();
        }
        String dspCreativeId = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.DSP_CREATIVE_ID);
        builder.setDspCreativeId(dspCreativeId);
        String networkType = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.NETWORK_TYPE);
        builder.setNetworkType(networkType);
        JSONObject impressionJson = HeaderUtils.extractJsonObjectHeader(jsonHeaders, ResponseHeader.IMPRESSION_DATA);
        builder.setImpressionData(ImpressionData.create(impressionJson));
        List<String> clickTrackingUrls = HeaderUtils.extractStringArray(jsonHeaders, ResponseHeader.CLICK_TRACKING_URL);
        if (clickTrackingUrls.isEmpty() && !TextUtils.isEmpty((CharSequence)(clickTrackingUrl = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.CLICK_TRACKING_URL))) && !EMPTY_JSON_ARRAY.equals(clickTrackingUrl)) {
            clickTrackingUrls.add(clickTrackingUrl);
        }
        builder.setClickTrackingUrls(clickTrackingUrls);
        List<String> impressionUrls = HeaderUtils.extractStringArray(jsonHeaders, ResponseHeader.IMPRESSION_URLS);
        if (impressionUrls.isEmpty() && !TextUtils.isEmpty((CharSequence)(impressionUrl = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.IMPRESSION_URL))) && !EMPTY_JSON_ARRAY.equals(impressionUrl)) {
            impressionUrls.add(impressionUrl);
        }
        builder.setImpressionTrackingUrls(impressionUrls);
        List<String> beforeLoadUrls = HeaderUtils.extractStringArray(jsonHeaders, ResponseHeader.BEFORE_LOAD_URL);
        if (beforeLoadUrls.isEmpty() && !TextUtils.isEmpty((CharSequence)(beforeLoadUrl = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.BEFORE_LOAD_URL))) && !EMPTY_JSON_ARRAY.equals(beforeLoadUrl)) {
            beforeLoadUrls.add(beforeLoadUrl);
        }
        builder.setBeforeLoadUrls(beforeLoadUrls);
        List<String> afterLoadUrls = HeaderUtils.extractStringArray(jsonHeaders, ResponseHeader.AFTER_LOAD_URL);
        if (afterLoadUrls.isEmpty() && !TextUtils.isEmpty((CharSequence)(afterLoadUrl = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.AFTER_LOAD_URL))) && !EMPTY_JSON_ARRAY.equals(afterLoadUrl)) {
            afterLoadUrls.add(afterLoadUrl);
        }
        builder.setAfterLoadUrls(afterLoadUrls);
        List<String> afterLoadSuccessUrls = HeaderUtils.extractStringArray(jsonHeaders, ResponseHeader.AFTER_LOAD_SUCCESS_URL);
        if (afterLoadSuccessUrls.isEmpty() && !TextUtils.isEmpty((CharSequence)(afterLoadSuccessUrl = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.AFTER_LOAD_SUCCESS_URL))) && !EMPTY_JSON_ARRAY.equals(afterLoadSuccessUrl)) {
            afterLoadSuccessUrls.add(afterLoadSuccessUrl);
        }
        builder.setAfterLoadSuccessUrls(afterLoadSuccessUrls);
        List<String> afterLoadFailUrls = HeaderUtils.extractStringArray(jsonHeaders, ResponseHeader.AFTER_LOAD_FAIL_URL);
        if (afterLoadFailUrls.isEmpty() && !TextUtils.isEmpty((CharSequence)(afterLoadFailUrl = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.AFTER_LOAD_FAIL_URL))) && !EMPTY_JSON_ARRAY.equals(afterLoadFailUrl)) {
            afterLoadFailUrls.add(afterLoadFailUrl);
        }
        builder.setAfterLoadFailUrls(afterLoadFailUrls);
        builder.setRequestId(requestId);
        Integer width = HeaderUtils.extractIntegerHeader(jsonHeaders, ResponseHeader.WIDTH);
        Integer height = HeaderUtils.extractIntegerHeader(jsonHeaders, ResponseHeader.HEIGHT);
        builder.setDimensions(width, height);
        Integer adTimeoutDelayMilliseconds = HeaderUtils.extractIntegerHeader(jsonHeaders, ResponseHeader.AD_TIMEOUT);
        builder.setAdTimeoutDelayMilliseconds(adTimeoutDelayMilliseconds);
        if ("json".equals(adTypeString) || "json_video".equals(adTypeString)) {
            try {
                builder.setJsonBody(new JSONObject(content));
            }
            catch (JSONException e) {
                throw new MoPubNetworkError("Failed to decode body JSON for native ad format", e, MoPubNetworkError.Reason.BAD_BODY);
            }
        }
        String customEventClassName = AdTypeTranslator.getBaseAdClassName(adFormat, adTypeString, fullAdTypeString, jsonHeaders);
        builder.setBaseAdClassName(customEventClassName);
        MoPub.BrowserAgent browserAgent = MoPub.BrowserAgent.fromHeader(HeaderUtils.extractIntegerHeader(jsonHeaders, ResponseHeader.BROWSER_AGENT));
        MoPub.setBrowserAgentFromAdServer(browserAgent);
        builder.setBrowserAgent(browserAgent);
        String customEventData = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.CUSTOM_EVENT_DATA);
        if (TextUtils.isEmpty((CharSequence)customEventData)) {
            customEventData = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.NATIVE_PARAMS);
        }
        try {
            serverExtras = Json.jsonStringToMap(customEventData);
        }
        catch (JSONException e) {
            throw new MoPubNetworkError("Failed to decode server extras for base ad data.", e, MoPubNetworkError.Reason.BAD_HEADER_DATA);
        }
        try {
            if (!jsonHeaders.optString("adm").isEmpty()) {
                serverExtras.put("adm", jsonHeaders.getString("adm"));
            }
        }
        catch (JSONException e) {
            throw new MoPubNetworkError("Failed to parse ADM for advanced bidding", e, MoPubNetworkError.Reason.BAD_BODY);
        }
        int shouldEnableVastClickInt = HeaderUtils.extractIntegerHeader(jsonHeaders, ResponseHeader.VAST_CLICK_ENABLED, 0);
        serverExtras.put("com_mopub_vast_click_exp_enabled", Boolean.toString(shouldEnableVastClickInt == 1));
        serverExtras.put("adunit_format", adUnitFormat);
        if (MultiAdResponse.eventDataIsInResponseBody(adTypeString, fullAdTypeString)) {
            serverExtras.put("html-response-body", content);
            serverExtras.put("com_mopub_orientation", HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.ORIENTATION));
        }
        boolean allowCustomClose = HeaderUtils.extractBooleanHeader(jsonHeaders, ResponseHeader.ALLOW_CUSTOM_CLOSE, false);
        builder.setAllowCustomClose(allowCustomClose);
        if ("json".equals(adTypeString) || "json_video".equals(adTypeString)) {
            String impressionMinVisiblePercent = HeaderUtils.extractPercentHeaderString(jsonHeaders, ResponseHeader.IMPRESSION_MIN_VISIBLE_PERCENT);
            String impressionVisibleMS = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.IMPRESSION_VISIBLE_MS);
            String impressionMinVisiblePx = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.IMPRESSION_MIN_VISIBLE_PX);
            if (!TextUtils.isEmpty((CharSequence)impressionMinVisiblePercent)) {
                serverExtras.put("impression-min-visible-percent", impressionMinVisiblePercent);
            }
            if (!TextUtils.isEmpty((CharSequence)impressionVisibleMS)) {
                serverExtras.put("impression-visible-ms", impressionVisibleMS);
            }
            if (!TextUtils.isEmpty((CharSequence)impressionMinVisiblePx)) {
                serverExtras.put("impression-min-visible-px", impressionMinVisiblePx);
            }
        }
        if ("json_video".equals(adTypeString)) {
            serverExtras.put("play-visible-percent", HeaderUtils.extractPercentHeaderString(jsonHeaders, ResponseHeader.PLAY_VISIBLE_PERCENT));
            serverExtras.put("pause-visible-percent", HeaderUtils.extractPercentHeaderString(jsonHeaders, ResponseHeader.PAUSE_VISIBLE_PERCENT));
            serverExtras.put("max-buffer-ms", HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.MAX_BUFFER_MS));
        }
        if (!TextUtils.isEmpty((CharSequence)(videoTrackers = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.VIDEO_TRACKERS)))) {
            serverExtras.put("video-trackers", videoTrackers);
        }
        if (AdFormat.BANNER.equals((Object)adFormat)) {
            builder.setBannerImpressionMinVisibleMs(HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.BANNER_IMPRESSION_MIN_VISIBLE_MS));
            builder.setBannerImpressionMinVisibleDips(HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.BANNER_IMPRESSION_MIN_VISIBLE_DIPS));
        }
        if (!TextUtils.isEmpty((CharSequence)(disabledViewabilityVendors = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.DISABLE_VIEWABILITY)))) {
            try {
                int disableViewabilityMask = Integer.parseInt(disabledViewabilityVendors);
                if (disableViewabilityMask > 0) {
                    MoPub.disableViewability();
                }
            }
            catch (Exception ex) {
                MoPubLog.log(MoPubLog.AdLogEvent.CUSTOM, "Error: invalid response value DISABLE_VIEWABILITY");
            }
        }
        JSONArray viewabilityVerification = HeaderUtils.extractJsonArrayHeader(jsonHeaders, ResponseHeader.VIEWABILITY_VERIFICATION);
        Set<ViewabilityVendor> vendors = ViewabilityVendor.createFromJsonArray(viewabilityVerification);
        builder.setViewabilityVendors(vendors);
        builder.setServerExtras(serverExtras);
        String rewardedVideoCurrencyName = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.REWARDED_VIDEO_CURRENCY_NAME);
        String rewardedVideoCurrencyAmount = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.REWARDED_VIDEO_CURRENCY_AMOUNT);
        String rewardedCurrencies = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.REWARDED_CURRENCIES);
        String rewardedVideoCompletionUrl = HeaderUtils.extractHeader(jsonHeaders, ResponseHeader.REWARDED_VIDEO_COMPLETION_URL);
        Integer rewardedDuration = HeaderUtils.extractIntegerHeader(jsonHeaders, ResponseHeader.REWARDED_DURATION);
        boolean shouldRewardOnClick = HeaderUtils.extractBooleanHeader(jsonHeaders, ResponseHeader.SHOULD_REWARD_ON_CLICK, false);
        builder.setRewardedVideoCurrencyName(rewardedVideoCurrencyName);
        builder.setRewardedVideoCurrencyAmount(rewardedVideoCurrencyAmount);
        builder.setRewardedCurrencies(rewardedCurrencies);
        builder.setRewardedVideoCompletionUrl(rewardedVideoCompletionUrl);
        builder.setRewardedDuration(rewardedDuration);
        builder.setShouldRewardOnClick(shouldRewardOnClick);
        return builder.build();
    }

    @Nullable
    private static Integer extractRefreshTimeMS(@NonNull JSONObject item) throws JSONException {
        Preconditions.checkNotNull(item);
        JSONObject jsonHeaders = item.getJSONObject(ResponseHeader.METADATA.getKey());
        Integer refreshTimeSeconds = HeaderUtils.extractIntegerHeader(jsonHeaders, ResponseHeader.REFRESH_TIME);
        return refreshTimeSeconds == null ? null : Integer.valueOf(refreshTimeSeconds * 1000);
    }

    private static boolean extractWarmup(@NonNull JSONObject item) {
        Preconditions.checkNotNull(item);
        JSONObject jsonHeaders = item.optJSONObject(ResponseHeader.METADATA.getKey());
        return HeaderUtils.extractBooleanHeader(jsonHeaders, ResponseHeader.WARMUP, false);
    }

    private static String parseStringBody(@NonNull NetworkResponse response) {
        String parsed;
        Preconditions.checkNotNull(response);
        try {
            parsed = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers));
        }
        catch (UnsupportedEncodingException e) {
            parsed = new String(response.data);
        }
        return parsed;
    }

    private static boolean eventDataIsInResponseBody(@Nullable String adType, @Nullable String fullAdType) {
        return "mraid".equals(adType) || "html".equals(adType) || "interstitial".equals(adType) && "vast".equals(fullAdType) || "rewarded_video".equals(adType) && "vast".equals(fullAdType) || "rewarded_playable".equals(adType) || "fullscreen".equals(adType);
    }

    public static interface ServerOverrideListener {
        public void onForceExplicitNo(@Nullable String var1);

        public void onInvalidateConsent(@Nullable String var1);

        public void onReacquireConsent(@Nullable String var1);

        public void onForceGdprApplies();

        public void onRequestSuccess(@Nullable String var1);
    }
}

