/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.network;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Looper;
import android.text.TextUtils;
import android.webkit.WebSettings;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.LruCache;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.DeviceUtils;
import com.mopub.network.CustomSSLSocketFactory;
import com.mopub.network.MaxWidthImageLoader;
import com.mopub.network.MoPubRequestQueue;
import com.mopub.network.PlayServicesUrlRewriter;
import com.mopub.network.RequestQueueHttpStack;
import com.mopub.volley.Cache;
import com.mopub.volley.Network;
import com.mopub.volley.toolbox.BaseHttpStack;
import com.mopub.volley.toolbox.BasicNetwork;
import com.mopub.volley.toolbox.DiskBasedCache;
import com.mopub.volley.toolbox.HurlStack;
import com.mopub.volley.toolbox.ImageLoader;
import java.io.File;

public class Networking {
    @VisibleForTesting
    static final String CACHE_DIRECTORY_NAME = "mopub-volley-cache";
    @NonNull
    private static final String DEFAULT_USER_AGENT;
    private static volatile MoPubRequestQueue sRequestQueue;
    private static volatile String sUserAgent;
    private static volatile MaxWidthImageLoader sMaxWidthImageLoader;
    private static boolean sUseHttps;
    private static HurlStack.UrlRewriter sUrlRewriter;

    @Nullable
    public static MoPubRequestQueue getRequestQueue() {
        return sRequestQueue;
    }

    @NonNull
    public static HurlStack.UrlRewriter getUrlRewriter(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        if (sUrlRewriter == null) {
            sUrlRewriter = new PlayServicesUrlRewriter();
        }
        return sUrlRewriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static MoPubRequestQueue getRequestQueue(@NonNull Context context) {
        MoPubRequestQueue requestQueue = sRequestQueue;
        if (requestQueue != null) return requestQueue;
        Class<Networking> clazz = Networking.class;
        synchronized (Networking.class) {
            requestQueue = sRequestQueue;
            if (requestQueue != null) return requestQueue;
            CustomSSLSocketFactory socketFactory = CustomSSLSocketFactory.getDefault(10000);
            String userAgent = Networking.getUserAgent(context.getApplicationContext());
            RequestQueueHttpStack httpStack = new RequestQueueHttpStack(userAgent, Networking.getUrlRewriter(context), socketFactory);
            BasicNetwork network = new BasicNetwork((BaseHttpStack)httpStack);
            File volleyCacheDir = new File(context.getCacheDir().getPath() + File.separator + CACHE_DIRECTORY_NAME);
            DiskBasedCache cache = new DiskBasedCache(volleyCacheDir, (int)DeviceUtils.diskCacheSizeBytes(volleyCacheDir, 0xA00000L));
            sRequestQueue = requestQueue = new MoPubRequestQueue((Cache)cache, (Network)network);
            requestQueue.start();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return requestQueue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static ImageLoader getImageLoader(@NonNull Context context) {
        MaxWidthImageLoader imageLoader = sMaxWidthImageLoader;
        if (imageLoader != null) return imageLoader;
        Class<Networking> clazz = Networking.class;
        synchronized (Networking.class) {
            imageLoader = sMaxWidthImageLoader;
            if (imageLoader != null) return imageLoader;
            MoPubRequestQueue queue = Networking.getRequestQueue(context);
            int cacheSize = DeviceUtils.memoryCacheSizeBytes(context);
            LruCache<String, Bitmap> imageCache = new LruCache<String, Bitmap>(cacheSize){

                protected int sizeOf(String key, Bitmap value) {
                    if (value != null) {
                        return value.getRowBytes() * value.getHeight();
                    }
                    return super.sizeOf((Object)key, (Object)value);
                }
            };
            sMaxWidthImageLoader = imageLoader = new MaxWidthImageLoader(queue, context, new ImageLoader.ImageCache((LruCache)imageCache){
                final /* synthetic */ LruCache val$imageCache;
                {
                    this.val$imageCache = lruCache;
                }

                public Bitmap getBitmap(String key) {
                    return (Bitmap)this.val$imageCache.get((Object)key);
                }

                public void putBitmap(String key, Bitmap bitmap) {
                    this.val$imageCache.put((Object)key, (Object)bitmap);
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return imageLoader;
        }
    }

    @NonNull
    public static String getUserAgent(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        String volatileUserAgentCopy = sUserAgent;
        if (!TextUtils.isEmpty((CharSequence)volatileUserAgentCopy)) {
            return volatileUserAgentCopy;
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            return DEFAULT_USER_AGENT;
        }
        String userAgent = DEFAULT_USER_AGENT;
        try {
            userAgent = WebSettings.getDefaultUserAgent((Context)context);
        }
        catch (Exception e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Failed to get a user agent. Defaulting to the system user agent.");
        }
        sUserAgent = userAgent;
        return userAgent;
    }

    @NonNull
    public static String getCachedUserAgent() {
        String userAgent = sUserAgent;
        if (userAgent == null) {
            return DEFAULT_USER_AGENT;
        }
        return userAgent;
    }

    @VisibleForTesting
    public static synchronized void clearForTesting() {
        sRequestQueue = null;
        sMaxWidthImageLoader = null;
        sUserAgent = null;
    }

    @VisibleForTesting
    public static synchronized void setRequestQueueForTesting(MoPubRequestQueue queue) {
        sRequestQueue = queue;
    }

    @VisibleForTesting
    public static synchronized void setImageLoaderForTesting(MaxWidthImageLoader imageLoader) {
        sMaxWidthImageLoader = imageLoader;
    }

    @Deprecated
    @VisibleForTesting
    public static synchronized void setUserAgentForTesting(String userAgent) {
        sUserAgent = userAgent;
    }

    public static void useHttps(boolean useHttps) {
        sUseHttps = useHttps;
    }

    public static boolean shouldUseHttps() {
        return sUseHttps;
    }

    public static String getScheme() {
        return "https";
    }

    public static String getBaseUrlScheme() {
        return Networking.shouldUseHttps() ? "https" : "http";
    }

    static {
        String userAgent = "";
        try {
            userAgent = System.getProperty("http.agent", "");
        }
        catch (SecurityException e) {
            MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Unable to get system user agent.");
        }
        DEFAULT_USER_AGENT = userAgent != null ? userAgent : "";
        sUseHttps = false;
    }
}

