/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.network;

import android.net.Uri;
import com.mopub.common.ClientMetadata;
import com.mopub.common.MoPub;
import com.mopub.common.privacy.AdvertisingId;
import com.mopub.common.privacy.MoPubIdentifier;
import com.mopub.volley.toolbox.HurlStack;

public class PlayServicesUrlRewriter
implements HurlStack.UrlRewriter {
    public static final String IFA_TEMPLATE = "mp_tmpl_advertising_id";
    public static final String DO_NOT_TRACK_TEMPLATE = "mp_tmpl_do_not_track";
    public static final String MOPUB_ID_TEMPLATE = "mp_tmpl_mopub_id";
    public static final String TAS_TEMPLATE = "mp_tmpl_tas";

    public String rewriteUrl(String url) {
        ClientMetadata clientMetadata = ClientMetadata.getInstance();
        if (clientMetadata == null) {
            return url;
        }
        MoPubIdentifier identifier = clientMetadata.getMoPubIdentifier();
        AdvertisingId info = identifier.getAdvertisingInfo();
        String toReturn = url.replace(DO_NOT_TRACK_TEMPLATE, info.isDoNotTrack() ? "1" : "0");
        toReturn = toReturn.replace(TAS_TEMPLATE, info.isDoNotTrack() ? "denied" : "authorized");
        if (MoPub.canCollectPersonalInformation() && !info.isDoNotTrack()) {
            toReturn = toReturn.replace(IFA_TEMPLATE, Uri.encode((String)info.getIdentifier(true)));
        } else {
            String ifaFullTemplate = "&ifa=mp_tmpl_advertising_id";
            toReturn = toReturn.replace("&ifa=mp_tmpl_advertising_id", "");
        }
        toReturn = toReturn.replace(MOPUB_ID_TEMPLATE, Uri.encode((String)info.getIdentifier(false)));
        return toReturn;
    }
}

