/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.network;

import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RequestRateTracker {
    @NonNull
    private Map<String, TimeRecord> mTimeRecordMap = Collections.synchronizedMap(new HashMap());

    RequestRateTracker() {
    }

    @NonNull
    public static RequestRateTracker getInstance() {
        return Helper.sInstance;
    }

    void registerRateLimit(@Nullable String adUnit, @Nullable Integer blockIntervalMs, @Nullable String reason) {
        if (TextUtils.isEmpty((CharSequence)adUnit)) {
            return;
        }
        if (blockIntervalMs != null && blockIntervalMs > 0) {
            this.mTimeRecordMap.put(adUnit, new TimeRecord(blockIntervalMs, reason));
        } else {
            this.mTimeRecordMap.remove(adUnit);
        }
    }

    boolean isBlockedByRateLimit(@Nullable String adUnitId) {
        return this.getTimeUntilLimitEnds(adUnitId) > 0L;
    }

    @Nullable
    public TimeRecord getRecordForAdUnit(@Nullable String adUnitId) {
        return this.mTimeRecordMap.get(adUnitId);
    }

    private long getTimeUntilLimitEnds(@Nullable String adUnitId) {
        TimeRecord record = this.mTimeRecordMap.get(adUnitId);
        if (record == null) {
            return 0L;
        }
        return record.getTargetTime() - RequestRateTracker.currentTimeMs();
    }

    private static long currentTimeMs() {
        return SystemClock.elapsedRealtime();
    }

    @Deprecated
    @VisibleForTesting
    static void setInstance(@NonNull RequestRateTracker mockInstance) {
        Helper.sInstance = mockInstance;
    }

    static /* synthetic */ long access$000() {
        return RequestRateTracker.currentTimeMs();
    }

    private static class Helper {
        @NonNull
        private static RequestRateTracker sInstance = new RequestRateTracker();

        private Helper() {
        }
    }

    public static class TimeRecord {
        final long mBlockStartTime = RequestRateTracker.access$000();
        public final int mBlockIntervalMs;
        @NonNull
        public final String mReason;

        TimeRecord(int interval, @Nullable String reason) {
            this.mBlockIntervalMs = interval;
            this.mReason = reason == null ? "unknown" : reason;
        }

        long getTargetTime() {
            return this.mBlockStartTime + (long)this.mBlockIntervalMs;
        }
    }
}

