/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.network;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.VastErrorCode;
import com.mopub.mobileads.VastMacroHelper;
import com.mopub.mobileads.VastTracker;
import com.mopub.network.MoPubNetworkError;
import com.mopub.network.MoPubRequest;
import com.mopub.network.MoPubRequestQueue;
import com.mopub.network.Networking;
import com.mopub.volley.Cache;
import com.mopub.volley.DefaultRetryPolicy;
import com.mopub.volley.NetworkResponse;
import com.mopub.volley.Response;
import com.mopub.volley.RetryPolicy;
import com.mopub.volley.VolleyError;
import com.mopub.volley.toolbox.HttpHeaderParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TrackingRequest
extends MoPubRequest<Void> {
    private static final int ZERO_RETRIES = 0;
    @Nullable
    private final Listener mListener;

    private TrackingRequest(@NonNull Context context, @NonNull String url, @Nullable Listener listener) {
        super(context, url, listener);
        this.mListener = listener;
        this.setShouldCache(false);
        this.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(2500, 0, 1.0f));
    }

    protected Response<Void> parseNetworkResponse(NetworkResponse networkResponse) {
        if (networkResponse.statusCode != 200) {
            return Response.error((VolleyError)new MoPubNetworkError("Failed to log tracking request. Response code: " + networkResponse.statusCode + " for url: " + this.getUrl(), MoPubNetworkError.Reason.TRACKING_FAILURE));
        }
        return Response.success(null, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)networkResponse));
    }

    public void deliverResponse(Void aVoid) {
        if (this.mListener != null) {
            this.mListener.onResponse(this.getUrl());
        }
    }

    public static void makeVastTrackingHttpRequest(@NonNull List<VastTracker> vastTrackers, @Nullable VastErrorCode vastErrorCode, @Nullable Integer contentPlayHead, @Nullable String assetUri, @Nullable Context context) {
        Preconditions.checkNotNull(vastTrackers);
        ArrayList<String> trackers = new ArrayList<String>(vastTrackers.size());
        for (VastTracker vastTracker : vastTrackers) {
            if (vastTracker == null || vastTracker.isTracked() && !vastTracker.isRepeatable()) continue;
            trackers.add(vastTracker.getContent());
            vastTracker.setTracked();
        }
        TrackingRequest.makeTrackingHttpRequest(new VastMacroHelper(trackers).withErrorCode(vastErrorCode).withContentPlayHead(contentPlayHead).withAssetUri(assetUri).getUris(), context);
    }

    public static void makeTrackingHttpRequest(@Nullable Iterable<String> urls, @Nullable Context context, final @Nullable Listener listener) {
        if (urls == null || context == null) {
            return;
        }
        MoPubRequestQueue requestQueue = Networking.getRequestQueue(context);
        for (final String url : urls) {
            if (TextUtils.isEmpty((CharSequence)url)) continue;
            Listener internalListener = new Listener(){

                @Override
                public void onResponse(@NonNull String url2) {
                    MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Successfully hit tracking endpoint: " + url2);
                    if (listener != null) {
                        listener.onResponse(url2);
                    }
                }

                public void onErrorResponse(VolleyError volleyError) {
                    MoPubLog.log(MoPubLog.SdkLogEvent.CUSTOM, "Failed to hit tracking endpoint: " + url);
                    if (listener != null) {
                        listener.onErrorResponse(volleyError);
                    }
                }
            };
            TrackingRequest trackingRequest = new TrackingRequest(context, url, internalListener);
            requestQueue.add(trackingRequest);
        }
    }

    public static void makeTrackingHttpRequest(@Nullable String url, @Nullable Context context) {
        TrackingRequest.makeTrackingHttpRequest(url, context, null);
    }

    public static void makeTrackingHttpRequest(@Nullable String url, @Nullable Context context, @Nullable Listener listener) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            TrackingRequest.makeTrackingHttpRequest(Arrays.asList(url), context, listener);
        }
    }

    public static void makeTrackingHttpRequest(@Nullable Iterable<String> urls, @Nullable Context context) {
        TrackingRequest.makeTrackingHttpRequest(urls, context, null);
    }

    public static interface Listener
    extends Response.ErrorListener {
        public void onResponse(@NonNull String var1);
    }
}

