/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.AdFormat;
import com.mopub.common.Preconditions;
import com.mopub.network.AdLoader;
import com.mopub.network.AdResponse;
import com.mopub.network.SingleImpression;
import com.mopub.network.TrackingRequest;
import java.util.Collections;
import java.util.List;

class AdLoaderRewardedVideo
extends AdLoader {
    private boolean mImpressionTrackerFired = false;
    private boolean mClickTrackerFired = false;

    AdLoaderRewardedVideo(@NonNull String url, @NonNull AdFormat adFormat, @NonNull String adUnitId, @NonNull Context context, @NonNull AdLoader.Listener listener) {
        super(url, adFormat, adUnitId, context, listener);
    }

    @Nullable
    String getFailurl() {
        if (this.mMultiAdResponse != null) {
            return this.mMultiAdResponse.getFailURL();
        }
        return null;
    }

    @NonNull
    List<String> getImpressionUrls() {
        if (this.mLastDeliveredResponse != null) {
            return this.mLastDeliveredResponse.getImpressionTrackingUrls();
        }
        return Collections.emptyList();
    }

    @NonNull
    List<String> getClickUrls() {
        if (this.mLastDeliveredResponse != null) {
            return this.mLastDeliveredResponse.getClickTrackingUrls();
        }
        return Collections.emptyList();
    }

    @Nullable
    AdResponse getLastDeliveredResponse() {
        return this.mLastDeliveredResponse;
    }

    void trackImpression(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        if (this.mLastDeliveredResponse == null || this.mImpressionTrackerFired) {
            return;
        }
        this.mImpressionTrackerFired = true;
        TrackingRequest.makeTrackingHttpRequest(this.getImpressionUrls(), (Context)context);
        String adUnitId = this.mLastDeliveredResponse.getAdUnitId();
        new SingleImpression(adUnitId, this.mLastDeliveredResponse.getImpressionData()).sendImpression();
    }

    void trackClick(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        if (this.mLastDeliveredResponse == null || this.mClickTrackerFired) {
            return;
        }
        this.mClickTrackerFired = true;
        TrackingRequest.makeTrackingHttpRequest(this.getClickUrls(), (Context)context);
    }
}

