/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import com.mopub.common.CloseableLayout;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Utils;
import com.mopub.mobileads.AdData;

abstract class BaseInterstitialActivity
extends Activity {
    @Nullable
    protected AdData mAdData;
    @Nullable
    private CloseableLayout mCloseableLayout;
    private long mBroadcastIdentifier;

    BaseInterstitialActivity() {
    }

    public abstract View getAdView();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        if (intent == null) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"Null intent on Activity. Unable to show ad."});
            this.finish();
            return;
        }
        this.mAdData = BaseInterstitialActivity.getAdDataFromIntent(intent);
        if (this.mAdData == null) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"Null ad data on Activity. Unable to show ad."});
            this.finish();
            return;
        }
        this.mBroadcastIdentifier = this.mAdData.getBroadcastIdentifier();
        View adView = this.getAdView();
        this.mCloseableLayout = new CloseableLayout((Context)this);
        int blackColor = this.getResources().getColor(17170444);
        this.mCloseableLayout.setBackgroundColor(blackColor);
        this.mCloseableLayout.setOnCloseListener(new CloseableLayout.OnCloseListener(){

            public void onClose() {
                BaseInterstitialActivity.this.finish();
            }
        });
        this.mCloseableLayout.addView(adView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.setContentView((View)this.mCloseableLayout);
    }

    protected void onStart() {
        super.onStart();
        Utils.hideNavigationBar((Activity)this);
    }

    protected void onDestroy() {
        if (this.mCloseableLayout != null) {
            this.mCloseableLayout.removeAllViews();
        }
        super.onDestroy();
    }

    @Nullable
    protected CloseableLayout getCloseableLayout() {
        return this.mCloseableLayout;
    }

    long getBroadcastIdentifier() {
        return this.mBroadcastIdentifier;
    }

    protected void showInterstitialCloseButton() {
        if (this.mCloseableLayout != null) {
            this.mCloseableLayout.setCloseVisible(true);
        }
    }

    protected void hideInterstitialCloseButton() {
        if (this.mCloseableLayout != null) {
            this.mCloseableLayout.setCloseVisible(false);
        }
    }

    @Nullable
    protected static AdData getAdDataFromIntent(Intent intent) {
        try {
            return (AdData)intent.getParcelableExtra("com_mopub_ad_data");
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

