/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import androidx.annotation.NonNull;
import com.mopub.mobileads.AdLifecycleListener;
import com.mopub.mobileads.BaseBroadcastReceiver;
import com.mopub.mobileads.MoPubErrorCode;

public class EventForwardingBroadcastReceiver
extends BaseBroadcastReceiver {
    private final AdLifecycleListener.InteractionListener mInteractionListener;
    private static IntentFilter sIntentFilter;

    public EventForwardingBroadcastReceiver(AdLifecycleListener.InteractionListener interactionListener, long broadcastIdentifier) {
        super(broadcastIdentifier);
        this.mInteractionListener = interactionListener;
        this.getIntentFilter();
    }

    @NonNull
    public IntentFilter getIntentFilter() {
        if (sIntentFilter == null) {
            sIntentFilter = new IntentFilter();
            sIntentFilter.addAction("com.mopub.action.fullscreen.fail");
            sIntentFilter.addAction("com.mopub.action.fullscreen.show");
            sIntentFilter.addAction("com.mopub.action.fullscreen.dismiss");
            sIntentFilter.addAction("com.mopub.action.fullscreen.click");
            sIntentFilter.addAction("com.mopub.action.rewardedad.complete");
        }
        return sIntentFilter;
    }

    public void onReceive(Context context, Intent intent) {
        if (this.mInteractionListener == null) {
            return;
        }
        if (!this.shouldConsumeBroadcast(intent)) {
            return;
        }
        String action = intent.getAction();
        if ("com.mopub.action.fullscreen.fail".equals(action)) {
            this.mInteractionListener.onAdFailed(MoPubErrorCode.NETWORK_INVALID_STATE);
        } else if ("com.mopub.action.fullscreen.show".equals(action)) {
            this.mInteractionListener.onAdShown();
            this.mInteractionListener.onAdImpression();
        } else if ("com.mopub.action.fullscreen.dismiss".equals(action)) {
            this.mInteractionListener.onAdDismissed();
            this.unregister((BroadcastReceiver)this);
        } else if ("com.mopub.action.fullscreen.click".equals(action)) {
            this.mInteractionListener.onAdClicked();
        } else if ("com.mopub.action.rewardedad.complete".equals(action)) {
            this.mInteractionListener.onAdComplete(null);
        }
    }
}

