/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.AdAdapter;
import com.mopub.mobileads.AdData;
import com.mopub.mobileads.AdLifecycleListener;
import com.mopub.mobileads.BaseAd;
import com.mopub.mobileads.MoPubAd;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.WebViewCacheService;
import com.mopub.mobileads.factories.BaseAdFactory;
import java.util.Map;

public class FullscreenAdAdapter
extends AdAdapter {
    private Map<String, String> mExtras;
    private long mBroadcastIdentifier;
    private String mDspCreativeId;

    public FullscreenAdAdapter(@NonNull Context context, @NonNull String className, @NonNull AdData adData) throws AdAdapter.BaseAdNotFoundException {
        super(context, className, adData);
        this.mBroadcastIdentifier = adData.getBroadcastIdentifier();
        this.mExtras = adData.getExtras();
        this.mDspCreativeId = adData.getDspCreativeId();
        if (!(context instanceof Activity)) {
            throw new IllegalArgumentException("An Activity Context is required.");
        }
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.CUSTOM, (Object[])new Object[]{"Attempting to invoke base ad: " + className});
        try {
            this.mBaseAd = BaseAdFactory.create((String)className);
        }
        catch (Exception exception) {
            throw new AdAdapter.BaseAdNotFoundException(exception);
        }
    }

    void show(@Nullable MoPubAd moPubAd) {
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.SHOW_ATTEMPTED, (Object[])new Object[0]);
        if (this.isInvalidated() || this.mBaseAd == null) {
            return;
        }
        try {
            this.mBaseAd.internalShow((AdLifecycleListener.InteractionListener)this);
        }
        catch (Exception e) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.CUSTOM_WITH_THROWABLE, (Object[])new Object[]{"Calling show on base ad threw an exception.", e});
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.SHOW_FAILED, (Object[])new Object[]{MoPubErrorCode.FULLSCREEN_SHOW_ERROR, MoPubErrorCode.FULLSCREEN_SHOW_ERROR.getIntCode()});
            this.onAdFailed(MoPubErrorCode.FULLSCREEN_SHOW_ERROR);
        }
    }

    void doInvalidate() {
        WebViewCacheService.Config config;
        if (this.mBaseAd != null) {
            try {
                this.mBaseAd.onInvalidate();
            }
            catch (Exception e) {
                MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.CUSTOM_WITH_THROWABLE, (Object[])new Object[]{"Invalidating a base ad interstitial threw an exception.", e});
            }
        }
        if ((config = WebViewCacheService.popWebViewConfig((Long)this.mBroadcastIdentifier)) != null) {
            config.getWebView().destroy();
        }
    }

    public void onAdPauseAutoRefresh() {
    }

    public void onAdResumeAutoRefresh() {
    }

    @Deprecated
    void setBaseAd(BaseAd baseAd) {
        this.mBaseAd = baseAd;
    }

    @Deprecated
    @VisibleForTesting
    void setBroadcastIdentifier(long broadcastIdentifier) {
        this.mBroadcastIdentifier = broadcastIdentifier;
    }

    @VisibleForTesting
    long getBroadcastIdentifier() {
        return this.mBroadcastIdentifier;
    }
}

