/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.mopub.common.CloseableLayout;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Dips;
import com.mopub.common.util.Intents;
import com.mopub.common.util.JavaScriptWebViewCallbacks;
import com.mopub.mobileads.AdData;
import com.mopub.mobileads.BaseBroadcastReceiver;
import com.mopub.mobileads.BaseHtmlWebView;
import com.mopub.mobileads.BaseVideoViewController;
import com.mopub.mobileads.BaseWebView;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MoPubWebViewController;
import com.mopub.mobileads.RadialCountdownWidget;
import com.mopub.mobileads.RepeatingHandlerRunnable;
import com.mopub.mobileads.VastVideoViewController;
import com.mopub.mobileads.WebViewCacheService;
import com.mopub.mobileads.factories.HtmlControllerFactory;
import com.mopub.mraid.MraidController;
import com.mopub.mraid.MraidVideoViewController;
import com.mopub.mraid.PlacementType;
import com.mopub.mraid.WebViewDebugListener;

public class FullscreenAdController
implements BaseVideoViewController.BaseVideoViewControllerListener,
MraidController.UseCustomCloseListener {
    @NonNull
    private final Activity mActivity;
    @Nullable
    private BaseVideoViewController mVideoViewController;
    @NonNull
    private final MoPubWebViewController mMoPubWebViewController;
    @NonNull
    private final AdData mAdData;
    @NonNull
    private ControllerState mState = ControllerState.MRAID;
    @Nullable
    private WebViewDebugListener mDebugListener;
    @Nullable
    private CloseableLayout mCloseableLayout;
    @Nullable
    private RadialCountdownWidget mRadialCountdownWidget;
    @Nullable
    private CloseButtonCountdownRunnable mCountdownRunnable;
    private int mCurrentElapsedTimeMillis;
    private int mShowCloseButtonDelayMillis;
    private boolean mShowCloseButtonEventFired;
    private boolean mIsCalibrationDone;
    private boolean mIsRewarded;

    public FullscreenAdController(final @NonNull Activity activity, @Nullable Bundle savedInstanceState, @NonNull Intent intent, final @NonNull AdData adData) {
        this.mActivity = activity;
        this.mAdData = adData;
        boolean preloaded = false;
        WebViewCacheService.Config config = WebViewCacheService.popWebViewConfig((Long)adData.getBroadcastIdentifier());
        if (config != null && config.getController() != null) {
            preloaded = true;
            this.mMoPubWebViewController = config.getController();
        } else {
            this.mMoPubWebViewController = "html".equals(adData.getAdType()) ? HtmlControllerFactory.create((Context)activity, (String)adData.getDspCreativeId()) : new MraidController((Context)activity, adData.getDspCreativeId(), PlacementType.INTERSTITIAL, this.mAdData.getAllowCustomClose());
        }
        String htmlData = adData.getAdPayload();
        if (TextUtils.isEmpty((CharSequence)htmlData)) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"MoPubFullscreenActivity received an empty HTML body. Finishing the activity."});
            activity.finish();
            return;
        }
        if (this.mMoPubWebViewController instanceof MraidController) {
            ((MraidController)this.mMoPubWebViewController).setUseCustomCloseListener((MraidController.UseCustomCloseListener)this);
        }
        this.mMoPubWebViewController.setDebugListener(this.mDebugListener);
        this.mMoPubWebViewController.setMoPubWebViewListener(new BaseHtmlWebView.BaseWebViewListener(){

            public void onLoaded(View view) {
                FullscreenAdController.this.mMoPubWebViewController.loadJavascript(JavaScriptWebViewCallbacks.WEB_VIEW_DID_APPEAR.getJavascript());
            }

            public void onFailedToLoad(MoPubErrorCode errorCode) {
            }

            public void onFailed() {
                MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"FullscreenAdController failed to load. Finishing MoPubFullscreenActivity."});
                BaseBroadcastReceiver.broadcastAction((Context)activity, (long)adData.getBroadcastIdentifier(), (String)"com.mopub.action.fullscreen.fail");
                activity.finish();
            }

            public void onRenderProcessGone(@NonNull MoPubErrorCode errorCode) {
                MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"Finishing the activity due to a problem: " + errorCode});
                activity.finish();
            }

            public void onClicked() {
                BaseBroadcastReceiver.broadcastAction((Context)activity, (long)adData.getBroadcastIdentifier(), (String)"com.mopub.action.fullscreen.click");
            }

            public void onClose() {
                BaseBroadcastReceiver.broadcastAction((Context)activity, (long)adData.getBroadcastIdentifier(), (String)"com.mopub.action.fullscreen.dismiss");
                FullscreenAdController.this.mMoPubWebViewController.loadJavascript(JavaScriptWebViewCallbacks.WEB_VIEW_DID_CLOSE.getJavascript());
                activity.finish();
            }

            public void onExpand() {
            }

            public void onResize(boolean toOriginalSize) {
                boolean i = false;
            }
        });
        if (!preloaded) {
            this.mMoPubWebViewController.fillContent(htmlData, adData.getViewabilityVendors(), new MoPubWebViewController.WebViewCacheListener(){

                public void onReady(@NonNull BaseWebView webView) {
                }
            });
        }
        this.mCloseableLayout = new CloseableLayout((Context)this.mActivity);
        if ("vast".equals(this.mAdData.getFullAdType())) {
            this.mVideoViewController = this.createVideoViewController(activity, savedInstanceState, intent, adData.getBroadcastIdentifier());
            this.mState = ControllerState.VIDEO;
            this.mVideoViewController.onCreate();
        } else {
            this.mState = "html".equals(this.mAdData.getAdType()) ? ControllerState.HTML : ControllerState.MRAID;
            int blackColor = this.mActivity.getResources().getColor(17170444);
            this.mCloseableLayout.setBackgroundColor(blackColor);
            this.mCloseableLayout.setOnCloseListener(new CloseableLayout.OnCloseListener(){

                public void onClose() {
                    FullscreenAdController.this.mActivity.finish();
                }
            });
            this.mCloseableLayout.addView(this.mMoPubWebViewController.getAdContainer(), (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            if (this.mAdData.isRewarded()) {
                this.mCloseableLayout.setCloseAlwaysInteractable(false);
                this.mCloseableLayout.setCloseVisible(false);
            }
            this.mActivity.setContentView((View)this.mCloseableLayout);
            this.mMoPubWebViewController.onShow(this.mActivity);
            if (this.mAdData.isRewarded()) {
                this.addRadialCountdownWidget((Context)activity, 4);
                this.mShowCloseButtonDelayMillis = adData.getRewardedDurationSeconds() >= 0 ? adData.getRewardedDurationSeconds() * 1000 : 30000;
                this.mRadialCountdownWidget.calibrateAndMakeVisible(this.mShowCloseButtonDelayMillis);
                this.mIsCalibrationDone = true;
                Handler mainHandler = new Handler(Looper.getMainLooper());
                this.mCountdownRunnable = new CloseButtonCountdownRunnable(this, mainHandler);
            } else {
                this.mShowCloseButtonEventFired = true;
            }
        }
    }

    @VisibleForTesting
    BaseVideoViewController createVideoViewController(Activity activity, Bundle savedInstanceState, Intent intent, Long broadcastIdentifier) throws IllegalStateException {
        if ("vast".equals(this.mAdData.getFullAdType())) {
            return new VastVideoViewController(activity, intent.getExtras(), savedInstanceState, broadcastIdentifier.longValue(), (BaseVideoViewController.BaseVideoViewControllerListener)this);
        }
        return new MraidVideoViewController((Context)activity, intent.getExtras(), savedInstanceState, (BaseVideoViewController.BaseVideoViewControllerListener)this);
    }

    public void onSetContentView(View view) {
        this.mActivity.setContentView(view);
    }

    public void onSetRequestedOrientation(int requestedOrientation) {
        this.mActivity.setRequestedOrientation(requestedOrientation);
    }

    public void onFinish() {
        this.mActivity.finish();
    }

    public void onStartActivityForResult(Class<? extends Activity> clazz, int requestCode, Bundle extras) {
        if (clazz == null) {
            return;
        }
        Intent intent = Intents.getStartActivityIntent((Context)this.mActivity, clazz, (Bundle)extras);
        try {
            this.mActivity.startActivityForResult(intent, requestCode);
        }
        catch (ActivityNotFoundException e) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"Activity " + clazz.getName() + " not found. Did you declare it in your AndroidManifest.xml?"});
        }
    }

    public void useCustomCloseChanged(boolean useCustomClose) {
        if (this.mCloseableLayout == null) {
            return;
        }
        if (useCustomClose && !this.mAdData.isRewarded()) {
            this.mCloseableLayout.setCloseVisible(false);
            return;
        }
        if (this.mShowCloseButtonEventFired) {
            this.mCloseableLayout.setCloseVisible(true);
        }
    }

    public void pause() {
        if (ControllerState.VIDEO.equals((Object)this.mState) && this.mVideoViewController != null) {
            this.mVideoViewController.onPause();
        } else if (ControllerState.MRAID.equals((Object)this.mState) || ControllerState.HTML.equals((Object)this.mState)) {
            this.mMoPubWebViewController.pause(false);
        }
        this.stopRunnables();
    }

    public void resume() {
        if (ControllerState.VIDEO.equals((Object)this.mState) && this.mVideoViewController != null) {
            this.mVideoViewController.onResume();
        } else if (ControllerState.MRAID.equals((Object)this.mState) || ControllerState.HTML.equals((Object)this.mState)) {
            this.mMoPubWebViewController.resume();
        }
        this.startRunnables();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.mVideoViewController != null) {
            this.mVideoViewController.onActivityResult(requestCode, resultCode, data);
        }
    }

    public void destroy() {
        this.mMoPubWebViewController.destroy();
        if (this.mVideoViewController != null) {
            this.mVideoViewController.onDestroy();
        }
        this.stopRunnables();
        BaseBroadcastReceiver.broadcastAction((Context)this.mActivity, (long)this.mAdData.getBroadcastIdentifier(), (String)"com.mopub.action.fullscreen.dismiss");
    }

    boolean backButtonEnabled() {
        if (ControllerState.VIDEO.equals((Object)this.mState) && this.mVideoViewController != null) {
            return this.mVideoViewController.backButtonEnabled();
        }
        if (ControllerState.MRAID.equals((Object)this.mState)) {
            return this.mShowCloseButtonEventFired;
        }
        return true;
    }

    private boolean isCloseable() {
        return !this.mShowCloseButtonEventFired && this.mCurrentElapsedTimeMillis >= this.mShowCloseButtonDelayMillis;
    }

    @VisibleForTesting
    void showCloseButton() {
        this.mShowCloseButtonEventFired = true;
        if (this.mRadialCountdownWidget != null) {
            this.mRadialCountdownWidget.setVisibility(8);
        }
        if (this.mCloseableLayout != null) {
            this.mCloseableLayout.setCloseVisible(true);
        }
        if (!this.mIsRewarded) {
            BaseBroadcastReceiver.broadcastAction((Context)this.mActivity, (long)this.mAdData.getBroadcastIdentifier(), (String)"com.mopub.action.rewardedad.complete");
            this.mIsRewarded = true;
        }
    }

    private void updateCountdown(int currentElapsedTimeMillis) {
        this.mCurrentElapsedTimeMillis = currentElapsedTimeMillis;
        if (this.mIsCalibrationDone && this.mRadialCountdownWidget != null) {
            this.mRadialCountdownWidget.updateCountdownProgress(this.mShowCloseButtonDelayMillis, this.mCurrentElapsedTimeMillis);
        }
    }

    private void startRunnables() {
        if (this.mCountdownRunnable != null) {
            this.mCountdownRunnable.startRepeating(250L);
        }
    }

    private void stopRunnables() {
        if (this.mCountdownRunnable != null) {
            this.mCountdownRunnable.stop();
        }
    }

    private void addRadialCountdownWidget(@NonNull Context context, int initialVisibility) {
        this.mRadialCountdownWidget = new RadialCountdownWidget(context);
        this.mRadialCountdownWidget.setVisibility(initialVisibility);
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.mRadialCountdownWidget.getLayoutParams();
        int widgetWidth = lp.width;
        int widgetHeight = lp.height;
        FrameLayout.LayoutParams widgetLayoutParams = new FrameLayout.LayoutParams(widgetWidth, widgetHeight);
        widgetLayoutParams.rightMargin = Dips.dipsToIntPixels((float)4.0f, (Context)context);
        widgetLayoutParams.topMargin = Dips.dipsToIntPixels((float)4.0f, (Context)context);
        widgetLayoutParams.gravity = 53;
        this.mCloseableLayout.addView((View)this.mRadialCountdownWidget, (ViewGroup.LayoutParams)widgetLayoutParams);
    }

    @Deprecated
    @VisibleForTesting
    void setDebugListener(@Nullable WebViewDebugListener debugListener) {
        this.mDebugListener = debugListener;
        this.mMoPubWebViewController.setDebugListener(this.mDebugListener);
    }

    @Deprecated
    @VisibleForTesting
    int getShowCloseButtonDelayMillis() {
        return this.mShowCloseButtonDelayMillis;
    }

    @Deprecated
    @VisibleForTesting
    @NonNull
    CloseableLayout getCloseableLayout() {
        return this.mCloseableLayout;
    }

    @Deprecated
    @VisibleForTesting
    void setCloseableLayout(@Nullable CloseableLayout closeableLayout) {
        this.mCloseableLayout = closeableLayout;
    }

    @Deprecated
    @VisibleForTesting
    @Nullable
    CloseButtonCountdownRunnable getCountdownRunnable() {
        return this.mCountdownRunnable;
    }

    @Deprecated
    @VisibleForTesting
    @Nullable
    RadialCountdownWidget getRadialCountdownWidget() {
        return this.mRadialCountdownWidget;
    }

    @Deprecated
    @VisibleForTesting
    boolean isCalibrationDone() {
        return this.mIsCalibrationDone;
    }

    @Deprecated
    @VisibleForTesting
    boolean isRewarded() {
        return this.mIsRewarded;
    }

    @Deprecated
    @VisibleForTesting
    boolean isShowCloseButtonEventFired() {
        return this.mShowCloseButtonEventFired;
    }

    static class CloseButtonCountdownRunnable
    extends RepeatingHandlerRunnable {
        @NonNull
        private final FullscreenAdController mController;
        private int mCurrentElapsedTimeMillis;

        private CloseButtonCountdownRunnable(@NonNull FullscreenAdController controller, @NonNull Handler handler) {
            super(handler);
            Preconditions.checkNotNull((Object)handler);
            Preconditions.checkNotNull((Object)controller);
            this.mController = controller;
        }

        public void doWork() {
            this.mCurrentElapsedTimeMillis = (int)((long)this.mCurrentElapsedTimeMillis + this.mUpdateIntervalMillis);
            this.mController.updateCountdown(this.mCurrentElapsedTimeMillis);
            if (this.mController.isCloseable()) {
                this.mController.showCloseButton();
            }
        }

        @Deprecated
        @VisibleForTesting
        int getCurrentElapsedTimeMillis() {
            return this.mCurrentElapsedTimeMillis;
        }
    }

    private static enum ControllerState {
        VIDEO,
        MRAID,
        HTML,
        IMAGE;

    }
}

