/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.CacheService;
import com.mopub.common.CreativeOrientation;
import com.mopub.common.LifecycleListener;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.AdData;
import com.mopub.mobileads.AdLifecycleListener;
import com.mopub.mobileads.BaseAd;
import com.mopub.mobileads.BaseHtmlWebView;
import com.mopub.mobileads.BaseWebView;
import com.mopub.mobileads.EventForwardingBroadcastReceiver;
import com.mopub.mobileads.HtmlController;
import com.mopub.mobileads.HtmlWebView;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MoPubFullscreenActivity;
import com.mopub.mobileads.MoPubWebViewController;
import com.mopub.mobileads.VastManager;
import com.mopub.mobileads.VastVideoConfig;
import com.mopub.mobileads.WebViewCacheService;
import com.mopub.mobileads.factories.HtmlControllerFactory;
import com.mopub.mobileads.factories.VastManagerFactory;
import com.mopub.mraid.MraidBridge;
import com.mopub.mraid.MraidController;
import com.mopub.mraid.PlacementType;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class MoPubFullscreen
extends BaseAd
implements VastManager.VastManagerListener {
    public static final String ADAPTER_NAME = MoPubFullscreen.class.getSimpleName();
    private static final String HTML = "html";
    private static final String MRAID = "mraid";
    @Nullable
    private EventForwardingBroadcastReceiver mBroadcastReceiver;
    @Nullable
    private Context mContext;
    private long mBroadcastIdentifier;
    @Nullable
    AdData mAdData;
    @Nullable
    private VastManager mVastManager;
    @Nullable
    private JSONObject mVideoTrackers;
    @Nullable
    private Handler mHandler;
    @Nullable
    private Runnable mAdExpiration;
    private boolean mReady;

    @Nullable
    protected LifecycleListener getLifecycleListener() {
        return null;
    }

    public void load(@NonNull Context context, @NonNull AdData adData) {
        Preconditions.checkNotNull((Object)this.mLoadListener);
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)adData);
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_ATTEMPTED, (Object[])new Object[]{ADAPTER_NAME});
        this.mContext = context;
        this.mAdData = adData;
        this.extractExtras(adData.getExtras());
        try {
            this.mBroadcastIdentifier = adData.getBroadcastIdentifier();
        }
        catch (ClassCastException e) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.CUSTOM, (Object[])new Object[]{"LocalExtras contained an incorrect type."});
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_FAILED, (Object[])new Object[]{ADAPTER_NAME, MoPubErrorCode.INTERNAL_ERROR.getIntCode(), MoPubErrorCode.INTERNAL_ERROR});
            this.mLoadListener.onAdLoadFailed(MoPubErrorCode.INTERNAL_ERROR);
            return;
        }
        this.preRender();
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_SUCCESS, (Object[])new Object[]{ADAPTER_NAME});
    }

    @NonNull
    public String getAdNetworkId() {
        String adNetworkId = MoPubFullscreen.class.getName();
        if (this.mAdData != null && !TextUtils.isEmpty((CharSequence)this.mAdData.getAdUnit())) {
            adNetworkId = this.mAdData.getAdUnit();
        }
        if (MoPubFullscreen.class.getName().equals(adNetworkId)) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"Called getAdNetworkId before load() or no ad unit associated. Returning class name."});
        }
        return adNetworkId;
    }

    protected void extractExtras(Map<String, String> serverExtras) {
        if (this.mAdData == null) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.CUSTOM, (Object[])new Object[]{"Error extracting extras due to null ad data."});
            throw new IllegalStateException("Ad Data cannot be null here.");
        }
        this.mAdData.setOrientation(CreativeOrientation.fromString((String)serverExtras.get("com_mopub_orientation")));
        String videoTrackers = serverExtras.get("video-trackers");
        if (!TextUtils.isEmpty((CharSequence)videoTrackers)) {
            try {
                this.mVideoTrackers = new JSONObject(videoTrackers);
            }
            catch (JSONException e) {
                MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.CUSTOM_WITH_THROWABLE, (Object[])new Object[]{"Failed to parse video trackers to JSON: " + videoTrackers, e});
                this.mVideoTrackers = null;
            }
        }
    }

    protected void preRender() {
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_ATTEMPTED, (Object[])new Object[]{ADAPTER_NAME});
        if (!CacheService.initializeDiskCache((Context)this.mContext)) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_FAILED, (Object[])new Object[]{ADAPTER_NAME, MoPubErrorCode.VIDEO_CACHE_ERROR.getIntCode(), MoPubErrorCode.VIDEO_CACHE_ERROR});
            this.mLoadListener.onAdLoadFailed(MoPubErrorCode.VIDEO_CACHE_ERROR);
            return;
        }
        if (this.mAdData == null) {
            this.mLoadListener.onAdLoadFailed(MoPubErrorCode.NETWORK_INVALID_STATE);
            return;
        }
        this.mHandler = new Handler();
        this.mAdExpiration = () -> {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.EXPIRED, (Object[])new Object[]{ADAPTER_NAME, "time in seconds"});
            this.mLoadListener.onAdLoadFailed(MoPubErrorCode.EXPIRED);
            this.onInvalidate();
        };
        if ("vast".equals(this.mAdData.getFullAdType())) {
            this.mVastManager = VastManagerFactory.create((Context)this.mContext);
            this.mVastManager.prepareVastVideoConfiguration(this.mAdData.getAdPayload(), (VastManager.VastManagerListener)this, this.mAdData.getDspCreativeId(), this.mContext);
        } else {
            this.preRenderWeb(this.mContext, this.mAdData);
        }
    }

    public void preRenderWeb(@NonNull Context context, @NonNull AdData adData) {
        HtmlController moPubWebViewController;
        MraidBridge.MraidWebView baseWebView;
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)adData);
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_ATTEMPTED, (Object[])new Object[]{ADAPTER_NAME});
        Long broadcastIdentifier = adData.getBroadcastIdentifier();
        Preconditions.checkNotNull((Object)broadcastIdentifier);
        String htmlData = adData.getAdPayload();
        Preconditions.checkNotNull((Object)htmlData);
        if (MRAID.equals(adData.getAdType())) {
            baseWebView = new MraidBridge.MraidWebView(context);
            baseWebView.enableJavascriptCaching();
            moPubWebViewController = new MraidController(context, adData.getDspCreativeId(), PlacementType.INTERSTITIAL, adData.getAllowCustomClose());
            baseWebView.enableJavascriptCaching();
        } else if (HTML.equals(adData.getAdType())) {
            baseWebView = new HtmlWebView(context);
            moPubWebViewController = HtmlControllerFactory.create((Context)context, (String)adData.getDspCreativeId());
        } else {
            this.mLoadListener.onAdLoadFailed(MoPubErrorCode.FULLSCREEN_LOAD_ERROR);
            return;
        }
        moPubWebViewController.setMoPubWebViewListener((BaseHtmlWebView.BaseWebViewListener)new MoPubFullScreenWebListener(this.mLoadListener));
        moPubWebViewController.fillContent(htmlData, adData.getViewabilityVendors(), null);
        WebViewCacheService.storeWebViewConfig((Long)broadcastIdentifier, (BaseWebView)baseWebView, (BaseAd)this, (MoPubWebViewController)moPubWebViewController);
    }

    protected void show() {
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.SHOW_ATTEMPTED, (Object[])new Object[]{ADAPTER_NAME});
        if (!this.mReady || this.mContext == null) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.SHOW_FAILED, (Object[])new Object[]{ADAPTER_NAME, MoPubErrorCode.ADAPTER_CONFIGURATION_ERROR.getIntCode(), MoPubErrorCode.ADAPTER_CONFIGURATION_ERROR});
            return;
        }
        this.mBroadcastReceiver = new EventForwardingBroadcastReceiver(this.mInteractionListener, this.mBroadcastIdentifier);
        this.mBroadcastReceiver.register((BroadcastReceiver)this.mBroadcastReceiver, this.mContext);
        MoPubFullscreenActivity.start(this.mContext, this.mAdData);
    }

    public void onInvalidate() {
        if (this.mVastManager != null) {
            this.mVastManager.cancel();
        }
        this.markNotReady();
        this.mAdExpiration = null;
        this.mHandler = null;
        this.mLoadListener = null;
        this.mInteractionListener = null;
        if (this.mBroadcastReceiver != null) {
            this.mBroadcastReceiver.unregister((BroadcastReceiver)this.mBroadcastReceiver);
            this.mBroadcastReceiver = null;
        }
    }

    protected boolean checkAndInitializeSdk(@NonNull Activity launcherActivity, @NonNull AdData adData) {
        return false;
    }

    public void onVastVideoConfigurationPrepared(@Nullable VastVideoConfig vastVideoConfig) {
        if (vastVideoConfig == null || this.mAdData == null) {
            if (this.mLoadListener != null) {
                this.mLoadListener.onAdLoadFailed(MoPubErrorCode.VIDEO_DOWNLOAD_ERROR);
            }
            return;
        }
        vastVideoConfig.addVideoTrackers(this.mVideoTrackers);
        vastVideoConfig.addViewabilityVendors(this.mAdData.getViewabilityVendors());
        if (this.mAdData.isRewarded()) {
            vastVideoConfig.setRewarded(true);
        }
        this.mAdData.setVastVideoConfigString(vastVideoConfig.toJsonString());
        if (this.mLoadListener != null) {
            this.mLoadListener.onAdLoaded();
        }
        this.markReady();
    }

    @VisibleForTesting
    void markReady() {
        this.mReady = true;
        if (this.mAdData == null || this.mHandler == null || this.mAdExpiration == null) {
            return;
        }
        this.mHandler.postDelayed(this.mAdExpiration, 14400000L);
    }

    @VisibleForTesting
    void markNotReady() {
        this.mReady = false;
        if (this.mAdData == null || this.mHandler == null || this.mAdExpiration == null) {
            return;
        }
        this.mHandler.removeCallbacks(this.mAdExpiration);
    }

    @Deprecated
    @VisibleForTesting
    @Nullable
    VastManager getVastManager() {
        return this.mVastManager;
    }

    @Deprecated
    @VisibleForTesting
    void setVastManager(@Nullable VastManager vastManager) {
        this.mVastManager = vastManager;
    }

    @Deprecated
    @VisibleForTesting
    void setReady(boolean ready) {
        this.mReady = ready;
    }

    @Deprecated
    @VisibleForTesting
    void setHandler(@Nullable Handler handler) {
        this.mHandler = handler;
    }

    private class MoPubFullScreenWebListener
    implements BaseHtmlWebView.BaseWebViewListener {
        final AdLifecycleListener.LoadListener loadListener;

        MoPubFullScreenWebListener(AdLifecycleListener.LoadListener loadListener) {
            this.loadListener = loadListener;
        }

        public void onLoaded(View view) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_SUCCESS, (Object[])new Object[]{ADAPTER_NAME});
            MoPubFullscreen.this.markReady();
            this.loadListener.onAdLoaded();
        }

        public void onFailedToLoad(MoPubErrorCode errorCode) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_FAILED, (Object[])new Object[]{ADAPTER_NAME, errorCode.getIntCode(), errorCode});
            MoPubFullscreen.this.markNotReady();
            this.loadListener.onAdLoadFailed(errorCode);
        }

        public void onFailed() {
        }

        public void onRenderProcessGone(@NonNull MoPubErrorCode errorCode) {
        }

        public void onClicked() {
        }

        public void onExpand() {
        }

        public void onResize(boolean toOriginalSize) {
        }

        public void onClose() {
        }
    }
}

