/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.CreativeOrientation;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.DeviceUtils;
import com.mopub.common.util.Intents;
import com.mopub.common.util.Utils;
import com.mopub.exceptions.IntentNotResolvableException;
import com.mopub.mobileads.AdData;
import com.mopub.mobileads.BaseBroadcastReceiver;
import com.mopub.mobileads.FullscreenAdController;
import com.mopub.mobileads.MoPubErrorCode;

public class MoPubFullscreenActivity
extends Activity {
    @Nullable
    private FullscreenAdController mFullscreenAdController;

    public static void start(@NonNull Context context, @NonNull AdData adData) {
        Intent intent = MoPubFullscreenActivity.createIntent(context, adData);
        try {
            Intents.startActivity((Context)context, (Intent)intent);
        }
        catch (IntentNotResolvableException exception) {
            Log.d((String)"MoPubFullscreenActivity", (String)"MoPubFullscreenActivity.class not found. Did you declare MoPubFullscreenActivity in your manifest?");
        }
    }

    @VisibleForTesting
    protected static Intent createIntent(@NonNull Context context, @NonNull AdData adData) {
        Intent intent = new Intent(context, MoPubFullscreenActivity.class);
        intent.putExtra("com_mopub_ad_data", (Parcelable)adData);
        intent.setFlags(0x10000000);
        return intent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        AdData adData = MoPubFullscreenActivity.getAdDataFromIntent(this.getIntent());
        if (adData == null) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"Ad data to show ad is null. Failed to show fullscreen ad."});
            this.finish();
            return;
        }
        long broadcastIdentifier = adData.getBroadcastIdentifier();
        try {
            this.mFullscreenAdController = new FullscreenAdController(this, savedInstanceState, this.getIntent(), adData);
        }
        catch (IllegalStateException e) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.SHOW_FAILED, (Object[])new Object[]{MoPubErrorCode.FULLSCREEN_SHOW_ERROR, MoPubErrorCode.FULLSCREEN_SHOW_ERROR.getIntCode()});
            BaseBroadcastReceiver.broadcastAction((Context)this, (long)broadcastIdentifier, (String)"com.mopub.action.fullscreen.fail");
            this.finish();
            return;
        }
        CreativeOrientation requestedOrientation = CreativeOrientation.DEVICE;
        if (adData.getOrientation() != null) {
            requestedOrientation = adData.getOrientation();
        }
        DeviceUtils.lockOrientation((Activity)this, (CreativeOrientation)requestedOrientation);
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.SHOW_SUCCESS, (Object[])new Object[0]);
        BaseBroadcastReceiver.broadcastAction((Context)this, (long)adData.getBroadcastIdentifier(), (String)"com.mopub.action.fullscreen.show");
        this.getWindow().setFlags(0x1000000, 0x1000000);
    }

    protected void onStart() {
        super.onStart();
        Utils.hideNavigationBar((Activity)this);
    }

    protected void onPause() {
        if (this.mFullscreenAdController != null) {
            this.mFullscreenAdController.pause();
        }
        super.onPause();
    }

    protected void onResume() {
        super.onResume();
        if (this.mFullscreenAdController != null) {
            this.mFullscreenAdController.resume();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.mFullscreenAdController != null) {
            this.mFullscreenAdController.onActivityResult(requestCode, resultCode, data);
        }
    }

    protected void onDestroy() {
        if (this.mFullscreenAdController != null) {
            this.mFullscreenAdController.destroy();
        }
        super.onDestroy();
    }

    public void onBackPressed() {
        if (this.mFullscreenAdController == null || this.mFullscreenAdController.backButtonEnabled()) {
            super.onBackPressed();
        }
    }

    @Nullable
    protected static AdData getAdDataFromIntent(Intent intent) {
        try {
            return (AdData)intent.getParcelableExtra("com_mopub_ad_data");
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Deprecated
    @VisibleForTesting
    FullscreenAdController getFullscreenAdController() {
        return this.mFullscreenAdController;
    }

    @Deprecated
    @VisibleForTesting
    void setFullscreenAdController(@NonNull FullscreenAdController fullscreenAdController) {
        this.mFullscreenAdController = fullscreenAdController;
    }
}

