/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.os.Handler;
import android.view.View;
import android.view.Window;
import android.view.WindowInsets;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.AdFormat;
import com.mopub.common.MoPubReward;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.DeviceUtils;
import com.mopub.mobileads.AdViewController;
import com.mopub.mobileads.MoPubAd;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.factories.AdViewControllerFactory;

public class MoPubInterstitial
implements MoPubAd {
    @Nullable
    protected AdViewController mAdViewController;
    @Nullable
    private InterstitialAdListener mInterstitialAdListener;
    @NonNull
    private Activity mActivity;
    @NonNull
    private Handler mHandler;
    @NonNull
    private volatile InterstitialState mCurrentInterstitialState;

    public MoPubInterstitial(@NonNull Activity activity, @NonNull String adUnitId) {
        this.mActivity = activity;
        AdViewController adViewController = AdViewControllerFactory.create((Context)this.mActivity, (MoPubAd)this);
        adViewController.setShouldAllowAutoRefresh(false);
        this.setAdViewController(adViewController);
        this.setAdUnitId(adUnitId);
        this.mCurrentInterstitialState = InterstitialState.IDLE;
        this.mHandler = new Handler();
    }

    private boolean attemptStateTransition(@NonNull InterstitialState endState) {
        return this.attemptStateTransition(endState, false);
    }

    @VisibleForTesting
    synchronized boolean attemptStateTransition(@NonNull InterstitialState endState, boolean force) {
        Preconditions.checkNotNull((Object)((Object)endState));
        InterstitialState startState = this.mCurrentInterstitialState;
        switch (startState) {
            case IDLE: {
                switch (endState) {
                    case LOADING: {
                        this.invalidateInterstitialAdapter();
                        this.mCurrentInterstitialState = InterstitialState.LOADING;
                        this.updatedInsets();
                        if (force) {
                            if (this.mAdViewController != null) {
                                this.mAdViewController.forceRefresh();
                            }
                        } else {
                            this.loadAd();
                        }
                        return true;
                    }
                    case READY: {
                        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.CUSTOM, (Object[])new Object[]{"Attempted transition from IDLE to READY failed due to no known load call."});
                        return false;
                    }
                    case SHOWING: {
                        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.CUSTOM, (Object[])new Object[]{"No interstitial loading or loaded."});
                        return false;
                    }
                    case DESTROYED: {
                        this.setInterstitialStateDestroyed();
                        return true;
                    }
                }
                return false;
            }
            case LOADING: {
                switch (endState) {
                    case IDLE: {
                        this.invalidateInterstitialAdapter();
                        this.mCurrentInterstitialState = InterstitialState.IDLE;
                        return true;
                    }
                    case LOADING: {
                        if (!force) {
                            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.CUSTOM, (Object[])new Object[]{"Already loading an interstitial."});
                        }
                        return false;
                    }
                    case READY: {
                        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.LOAD_SUCCESS, (Object[])new Object[0]);
                        this.mCurrentInterstitialState = InterstitialState.READY;
                        if (this.mInterstitialAdListener != null) {
                            this.mInterstitialAdListener.onInterstitialLoaded(this);
                        }
                        return true;
                    }
                    case SHOWING: {
                        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.CUSTOM, (Object[])new Object[]{"Interstitial is not ready to be shown yet."});
                        return false;
                    }
                    case DESTROYED: {
                        this.setInterstitialStateDestroyed();
                        return true;
                    }
                }
                return false;
            }
            case READY: {
                switch (endState) {
                    case IDLE: {
                        if (force) {
                            this.invalidateInterstitialAdapter();
                            this.mCurrentInterstitialState = InterstitialState.IDLE;
                            return true;
                        }
                        return false;
                    }
                    case LOADING: {
                        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.CUSTOM, (Object[])new Object[]{"Interstitial already loaded. Not loading another."});
                        if (this.mInterstitialAdListener != null) {
                            this.mInterstitialAdListener.onInterstitialLoaded(this);
                        }
                        return false;
                    }
                    case SHOWING: {
                        this.showFullscreen();
                        this.mCurrentInterstitialState = InterstitialState.SHOWING;
                        return true;
                    }
                    case DESTROYED: {
                        this.setInterstitialStateDestroyed();
                        return true;
                    }
                }
                return false;
            }
            case SHOWING: {
                switch (endState) {
                    case IDLE: {
                        if (force) {
                            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.CUSTOM, (Object[])new Object[]{"Cannot force refresh while showing an interstitial."});
                            return false;
                        }
                        this.invalidateInterstitialAdapter();
                        this.mCurrentInterstitialState = InterstitialState.IDLE;
                        return true;
                    }
                    case LOADING: {
                        if (!force) {
                            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.CUSTOM, (Object[])new Object[]{"Interstitial already showing. Not loading another."});
                        }
                        return false;
                    }
                    case SHOWING: {
                        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.CUSTOM, (Object[])new Object[]{"Already showing an interstitial. Cannot show it again."});
                        return false;
                    }
                    case DESTROYED: {
                        this.setInterstitialStateDestroyed();
                        return true;
                    }
                }
                return false;
            }
            case DESTROYED: {
                MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.CUSTOM, (Object[])new Object[]{"MoPubInterstitial destroyed. Ignoring all requests."});
                return false;
            }
        }
        return false;
    }

    private void setInterstitialStateDestroyed() {
        this.invalidateInterstitialAdapter();
        this.mInterstitialAdListener = null;
        this.mCurrentInterstitialState = InterstitialState.DESTROYED;
    }

    private void updatedInsets() {
        if (Build.VERSION.SDK_INT >= 28) {
            Window window = this.mActivity.getWindow();
            if (window == null) {
                return;
            }
            View decorView = window.getDecorView();
            if (decorView == null) {
                return;
            }
            WindowInsets insets = decorView.getRootWindowInsets();
            if (insets == null) {
                return;
            }
            if (this.mAdViewController != null) {
                this.mAdViewController.setWindowInsets(insets);
            }
        }
    }

    public void load() {
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.LOAD_ATTEMPTED, (Object[])new Object[0]);
        this.attemptStateTransition(InterstitialState.LOADING);
    }

    public boolean show() {
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.SHOW_ATTEMPTED, (Object[])new Object[0]);
        return this.attemptStateTransition(InterstitialState.SHOWING);
    }

    public void forceRefresh() {
        this.attemptStateTransition(InterstitialState.IDLE, true);
        this.attemptStateTransition(InterstitialState.LOADING, true);
    }

    public boolean isReady() {
        return this.mCurrentInterstitialState == InterstitialState.READY;
    }

    boolean isDestroyed() {
        return this.mCurrentInterstitialState == InterstitialState.DESTROYED;
    }

    private void showFullscreen() {
        if (this.mAdViewController != null) {
            this.mAdViewController.show();
        }
    }

    private void invalidateInterstitialAdapter() {
        if (this.mAdViewController != null) {
            this.mAdViewController.invalidateAdapter();
        }
    }

    @NonNull
    public Activity getActivity() {
        return this.mActivity;
    }

    public void destroy() {
        this.attemptStateTransition(InterstitialState.DESTROYED);
    }

    public void setInterstitialAdListener(@Nullable InterstitialAdListener listener) {
        this.mInterstitialAdListener = listener;
    }

    @Nullable
    public InterstitialAdListener getInterstitialAdListener() {
        return this.mInterstitialAdListener;
    }

    public void setTesting(boolean testing) {
        if (this.mAdViewController != null) {
            this.mAdViewController.setTesting(testing);
        }
    }

    public boolean getTesting() {
        if (this.mAdViewController != null) {
            return this.mAdViewController.getTesting();
        }
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.CUSTOM, (Object[])new Object[]{"Can't get testing status for destroyed AdViewController. Returning false."});
        return false;
    }

    public void onAdLoaded() {
        if (this.isDestroyed()) {
            return;
        }
        this.attemptStateTransition(InterstitialState.READY);
    }

    public void onAdLoadFailed(@NonNull MoPubErrorCode errorCode) {
        if (this.isDestroyed()) {
            return;
        }
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.LOAD_FAILED, (Object[])new Object[]{errorCode.getIntCode(), errorCode});
        if (this.mInterstitialAdListener != null) {
            this.mInterstitialAdListener.onInterstitialFailed(this, errorCode);
        }
        this.attemptStateTransition(InterstitialState.IDLE);
    }

    public void onAdFailed(@NonNull MoPubErrorCode errorCode) {
        if (this.isDestroyed()) {
            return;
        }
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.SHOW_FAILED, (Object[])new Object[]{errorCode.getIntCode(), errorCode});
        if (this.mInterstitialAdListener != null) {
            this.mInterstitialAdListener.onInterstitialFailed(this, errorCode);
        }
        this.attemptStateTransition(InterstitialState.IDLE);
    }

    public void onAdShown() {
        if (this.isDestroyed()) {
            return;
        }
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.SHOW_SUCCESS, (Object[])new Object[0]);
        if (this.mInterstitialAdListener != null) {
            this.mInterstitialAdListener.onInterstitialShown(this);
        }
    }

    public void onAdClicked() {
        if (this.isDestroyed()) {
            return;
        }
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.CLICKED, (Object[])new Object[0]);
        if (this.mAdViewController != null) {
            this.mAdViewController.registerClick();
        }
        if (this.mInterstitialAdListener != null) {
            this.mInterstitialAdListener.onInterstitialClicked(this);
        }
    }

    public void onAdDismissed() {
        if (this.isDestroyed()) {
            return;
        }
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.DID_DISAPPEAR, (Object[])new Object[0]);
        this.attemptStateTransition(InterstitialState.IDLE);
        if (this.mInterstitialAdListener != null) {
            this.mInterstitialAdListener.onInterstitialDismissed(this);
        }
    }

    public void onAdComplete(@Nullable MoPubReward moPubReward) {
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.CUSTOM, (Object[])new Object[]{"Interstitial finished."});
        if (this.mAdViewController != null) {
            this.mAdViewController.onAdComplete(null);
        }
    }

    public void onAdImpression() {
    }

    @NonNull
    public AdFormat getAdFormat() {
        return AdFormat.INTERSTITIAL;
    }

    public AdViewController getAdViewController() {
        return this.mAdViewController;
    }

    public void setAdViewController(@Nullable AdViewController adViewController) {
        this.mAdViewController = adViewController;
    }

    @NonNull
    public Point resolveAdSize() {
        return DeviceUtils.getDeviceDimensions((Context)this.mActivity);
    }

    @Deprecated
    @VisibleForTesting
    void setHandler(@NonNull Handler handler) {
        this.mHandler = handler;
    }

    @Deprecated
    @VisibleForTesting
    void setCurrentInterstitialState(@NonNull InterstitialState interstitialState) {
        this.mCurrentInterstitialState = interstitialState;
    }

    @Deprecated
    @VisibleForTesting
    @NonNull
    InterstitialState getCurrentInterstitialState() {
        return this.mCurrentInterstitialState;
    }

    public static interface InterstitialAdListener {
        public void onInterstitialLoaded(MoPubInterstitial var1);

        public void onInterstitialFailed(MoPubInterstitial var1, MoPubErrorCode var2);

        public void onInterstitialShown(MoPubInterstitial var1);

        public void onInterstitialClicked(MoPubInterstitial var1);

        public void onInterstitialDismissed(MoPubInterstitial var1);
    }

    @VisibleForTesting
    static enum InterstitialState {
        IDLE,
        LOADING,
        READY,
        SHOWING,
        DESTROYED;

    }
}

