/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Point;
import android.location.Location;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.Window;
import android.view.WindowInsets;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.AdUrlGenerator;
import com.mopub.common.ClientMetadata;
import com.mopub.common.Constants;
import com.mopub.common.MediationSettings;
import com.mopub.common.MoPub;
import com.mopub.common.MoPubReward;
import com.mopub.common.Preconditions;
import com.mopub.common.SharedPreferencesHelper;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Json;
import com.mopub.common.util.MoPubCollections;
import com.mopub.common.util.ReflectionTarget;
import com.mopub.common.util.Utils;
import com.mopub.mobileads.AdAdapter;
import com.mopub.mobileads.AdData;
import com.mopub.mobileads.AdLifecycleListener;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MoPubRewardedVideoListener;
import com.mopub.mobileads.RewardedAdData;
import com.mopub.mobileads.RewardedAdsLoaders;
import com.mopub.mobileads.RewardedVideoCompletionRequestHandler;
import com.mopub.mobileads.WebViewAdUrlGenerator;
import com.mopub.network.AdResponse;
import com.mopub.network.MoPubNetworkError;
import com.mopub.volley.NoConnectionError;
import com.mopub.volley.VolleyError;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class MoPubRewardedVideoManager {
    private static MoPubRewardedVideoManager sInstance;
    private static final String FULLSCREEN_AD_ADAPTER = "com.mopub.mobileads.FullscreenAdAdapter";
    @NonNull
    private static SharedPreferences sBaseAdSharedPrefs;
    private static final String CUSTOM_EVENT_PREF_NAME = "mopubBaseAdSettings";
    private static final int DEFAULT_LOAD_TIMEOUT = 30000;
    private static final String CURRENCIES_JSON_REWARDS_MAP_KEY = "rewards";
    private static final String CURRENCIES_JSON_REWARD_NAME_KEY = "name";
    private static final String CURRENCIES_JSON_REWARD_AMOUNT_KEY = "amount";
    @VisibleForTesting
    static final int CUSTOM_DATA_MAX_LENGTH_BYTES = 8192;
    public static final int API_VERSION = 1;
    @NonNull
    private final Handler mCallbackHandler;
    @NonNull
    private WeakReference<Activity> mMainActivity;
    @NonNull
    private final Context mContext;
    @NonNull
    private final RewardedAdData mRewardedAdData;
    @Nullable
    private MoPubRewardedVideoListener mVideoListener;
    @NonNull
    private final Set<MediationSettings> mGlobalMediationSettings;
    @NonNull
    private final Map<String, Set<MediationSettings>> mInstanceMediationSettings;
    @NonNull
    private final Handler mBaseAdTimeoutHandler;
    @NonNull
    private final Map<String, Runnable> mTimeoutMap;
    @NonNull
    private final RewardedAdsLoaders rewardedAdsLoaders;

    private MoPubRewardedVideoManager(@NonNull Activity mainActivity, MediationSettings ... mediationSettings) {
        this.mMainActivity = new WeakReference<Activity>(mainActivity);
        this.mContext = mainActivity.getApplicationContext();
        this.mRewardedAdData = new RewardedAdData();
        this.mCallbackHandler = new Handler(Looper.getMainLooper());
        this.mGlobalMediationSettings = new HashSet<MediationSettings>();
        MoPubCollections.addAllNonNull(this.mGlobalMediationSettings, (Object[])mediationSettings);
        this.mInstanceMediationSettings = new HashMap<String, Set<MediationSettings>>();
        this.mBaseAdTimeoutHandler = new Handler();
        this.mTimeoutMap = new HashMap<String, Runnable>();
        this.rewardedAdsLoaders = new RewardedAdsLoaders(this);
        sBaseAdSharedPrefs = SharedPreferencesHelper.getSharedPreferences((Context)this.mContext, (String)CUSTOM_EVENT_PREF_NAME);
    }

    public static synchronized void init(@NonNull Activity mainActivity, MediationSettings ... mediationSettings) {
        if (sInstance == null) {
            sInstance = new MoPubRewardedVideoManager(mainActivity, mediationSettings);
        } else {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"Tried to call initializeRewardedVideo more than once. Only the first initialization call has any effect."});
        }
    }

    @ReflectionTarget
    public static void updateActivity(@Nullable Activity activity) {
        if (sInstance != null) {
            MoPubRewardedVideoManager.sInstance.mMainActivity = new WeakReference<Activity>(activity);
        } else {
            MoPubRewardedVideoManager.logErrorNotInitialized();
        }
    }

    @Nullable
    public static <T extends MediationSettings> T getGlobalMediationSettings(@NonNull Class<T> clazz) {
        if (sInstance == null) {
            MoPubRewardedVideoManager.logErrorNotInitialized();
            return null;
        }
        for (MediationSettings mediationSettings : MoPubRewardedVideoManager.sInstance.mGlobalMediationSettings) {
            if (!clazz.equals(mediationSettings.getClass())) continue;
            return (T)((MediationSettings)clazz.cast(mediationSettings));
        }
        return null;
    }

    @Nullable
    public static <T extends MediationSettings> T getInstanceMediationSettings(@NonNull Class<T> clazz, @NonNull String adUnitId) {
        if (sInstance == null) {
            MoPubRewardedVideoManager.logErrorNotInitialized();
            return null;
        }
        Set<MediationSettings> instanceMediationSettings = MoPubRewardedVideoManager.sInstance.mInstanceMediationSettings.get(adUnitId);
        if (instanceMediationSettings == null) {
            return null;
        }
        for (MediationSettings mediationSettings : instanceMediationSettings) {
            if (!clazz.equals(mediationSettings.getClass())) continue;
            return (T)((MediationSettings)clazz.cast(mediationSettings));
        }
        return null;
    }

    public static void setVideoListener(@Nullable MoPubRewardedVideoListener listener) {
        if (sInstance != null) {
            MoPubRewardedVideoManager.sInstance.mVideoListener = listener;
        } else {
            MoPubRewardedVideoManager.logErrorNotInitialized();
        }
    }

    public static void loadVideo(final @NonNull String adUnitId, @Nullable RequestParameters requestParameters, MediationSettings ... mediationSettings) {
        String customerId;
        Preconditions.checkNotNull((Object)adUnitId);
        if (sInstance == null) {
            MoPubRewardedVideoManager.logErrorNotInitialized();
            return;
        }
        String currentlyShowingAdUnitId = MoPubRewardedVideoManager.sInstance.mRewardedAdData.getCurrentlyShowingAdUnitId();
        if (adUnitId.equals(currentlyShowingAdUnitId)) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{String.format(Locale.US, "Did not queue rewarded ad request for ad unit %s. The ad is already showing.", adUnitId)});
            return;
        }
        if (MoPubRewardedVideoManager.sInstance.rewardedAdsLoaders.canPlay(adUnitId)) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{String.format(Locale.US, "Did not queue rewarded ad request for ad unit %s. This ad unit already finished loading and is ready to show.", adUnitId)});
            MoPubRewardedVideoManager.postToInstance(new Runnable(){

                @Override
                public void run() {
                    if (sInstance.mVideoListener != null) {
                        sInstance.mVideoListener.onRewardedVideoLoadSuccess(adUnitId);
                    }
                }
            });
            return;
        }
        HashSet newInstanceMediationSettings = new HashSet();
        MoPubCollections.addAllNonNull(newInstanceMediationSettings, (Object[])mediationSettings);
        MoPubRewardedVideoManager.sInstance.mInstanceMediationSettings.put(adUnitId, newInstanceMediationSettings);
        String string = customerId = requestParameters == null ? null : requestParameters.mCustomerId;
        if (!TextUtils.isEmpty((CharSequence)customerId)) {
            MoPubRewardedVideoManager.sInstance.mRewardedAdData.setCustomerId(customerId);
        }
        WebViewAdUrlGenerator urlGenerator = new WebViewAdUrlGenerator(MoPubRewardedVideoManager.sInstance.mContext);
        urlGenerator.withAdUnitId(adUnitId).withKeywords(requestParameters == null ? null : requestParameters.mKeywords).withUserDataKeywords(requestParameters == null || !MoPub.canCollectPersonalInformation() ? null : requestParameters.mUserDataKeywords);
        MoPubRewardedVideoManager.setSafeAreaValues((AdUrlGenerator)urlGenerator);
        MoPubRewardedVideoManager.loadVideo(adUnitId, urlGenerator.generateUrlString(Constants.HOST), null);
    }

    private static void loadVideo(@NonNull String adUnitId, @NonNull String adUrlString, @Nullable MoPubErrorCode errorCode) {
        if (sInstance == null) {
            MoPubRewardedVideoManager.logErrorNotInitialized();
            return;
        }
        sInstance.fetchAd(adUnitId, adUrlString, errorCode);
    }

    private void fetchAd(@NonNull String adUnitId, @NonNull String adUrlString, @Nullable MoPubErrorCode errorCode) {
        if (this.rewardedAdsLoaders.isLoading(adUnitId)) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{String.format(Locale.US, "Did not queue rewarded ad request for ad unit %s. A request is already pending.", adUnitId)});
            return;
        }
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{String.format(Locale.US, "Loading rewarded ad request for ad unit %s with URL %s", adUnitId, adUrlString)});
        this.rewardedAdsLoaders.loadNextAd(this.mContext, adUnitId, adUrlString, errorCode);
    }

    public static boolean hasVideo(@NonNull String adUnitId) {
        if (sInstance != null) {
            AdAdapter adAdapter = MoPubRewardedVideoManager.sInstance.mRewardedAdData.getAdAdapter(adUnitId);
            return MoPubRewardedVideoManager.isPlayable(adUnitId, adAdapter);
        }
        MoPubRewardedVideoManager.logErrorNotInitialized();
        return false;
    }

    public static void showVideo(@NonNull String adUnitId) {
        MoPubRewardedVideoManager.showVideo(adUnitId, null);
    }

    public static void showVideo(@NonNull String adUnitId, @Nullable String customData) {
        AdAdapter adAdapter;
        if (sInstance == null) {
            MoPubRewardedVideoManager.logErrorNotInitialized();
            return;
        }
        if (customData != null && customData.length() > 8192) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{String.format(Locale.US, "Provided rewarded ad custom data parameter longer than supported(%d bytes, %d maximum)", customData.length(), 8192)});
        }
        if (MoPubRewardedVideoManager.isPlayable(adUnitId, adAdapter = MoPubRewardedVideoManager.sInstance.mRewardedAdData.getAdAdapter(adUnitId))) {
            if (!MoPubRewardedVideoManager.sInstance.mRewardedAdData.getAvailableRewards(adUnitId).isEmpty() && MoPubRewardedVideoManager.sInstance.mRewardedAdData.getMoPubReward(adUnitId) == null) {
                sInstance.failover(adUnitId, MoPubErrorCode.REWARD_NOT_SELECTED);
                return;
            }
            MoPubRewardedVideoManager.sInstance.mRewardedAdData.updateLastShownRewardMapping(adAdapter, MoPubRewardedVideoManager.sInstance.mRewardedAdData.getMoPubReward(adUnitId));
            MoPubRewardedVideoManager.sInstance.mRewardedAdData.updateAdUnitToCustomDataMapping(adUnitId, customData);
            MoPubRewardedVideoManager.sInstance.mRewardedAdData.setCurrentlyShowingAdUnitId(adUnitId);
            adAdapter.show(null);
        } else {
            if (MoPubRewardedVideoManager.sInstance.rewardedAdsLoaders.isLoading(adUnitId)) {
                MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"Rewarded ad is not ready to be shown yet."});
            } else {
                MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"No rewarded ad loading or loaded."});
            }
            sInstance.failover(adUnitId, MoPubErrorCode.VIDEO_NOT_AVAILABLE);
        }
    }

    private static boolean isPlayable(String adUnitId, @Nullable AdAdapter adAdapter) {
        return sInstance != null && MoPubRewardedVideoManager.sInstance.rewardedAdsLoaders.canPlay(adUnitId) && adAdapter != null && adAdapter.isReady();
    }

    @NonNull
    public static Set<MoPubReward> getAvailableRewards(@NonNull String adUnitId) {
        if (sInstance != null) {
            return MoPubRewardedVideoManager.sInstance.mRewardedAdData.getAvailableRewards(adUnitId);
        }
        MoPubRewardedVideoManager.logErrorNotInitialized();
        return Collections.emptySet();
    }

    public static void selectReward(@NonNull String adUnitId, @NonNull MoPubReward selectedReward) {
        if (sInstance != null) {
            MoPubRewardedVideoManager.sInstance.mRewardedAdData.selectReward(adUnitId, selectedReward);
        } else {
            MoPubRewardedVideoManager.logErrorNotInitialized();
        }
    }

    private static void setSafeAreaValues(@NonNull AdUrlGenerator urlGenerator) {
        Preconditions.checkNotNull((Object)urlGenerator);
        Point dimens = ClientMetadata.getInstance((Context)MoPubRewardedVideoManager.sInstance.mContext).getDeviceDimensions();
        urlGenerator.withRequestedAdSize(dimens);
        if (Build.VERSION.SDK_INT >= 28) {
            Activity activity = (Activity)MoPubRewardedVideoManager.sInstance.mMainActivity.get();
            if (activity == null) {
                return;
            }
            Window window = ((Activity)MoPubRewardedVideoManager.sInstance.mMainActivity.get()).getWindow();
            if (window == null) {
                return;
            }
            WindowInsets insets = window.getDecorView().getRootWindowInsets();
            if (insets == null) {
                return;
            }
            urlGenerator.withWindowInsets(insets);
        }
    }

    void onAdSuccess(AdResponse adResponse) {
        String adUnitId = adResponse.getAdUnitId();
        Integer timeoutMillis = adResponse.getAdTimeoutMillis(30000);
        String baseAdClassName = adResponse.getBaseAdClassName();
        if (baseAdClassName == null) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"Couldn't create base ad, class name was null."});
            this.failover(adUnitId, MoPubErrorCode.ADAPTER_CONFIGURATION_ERROR);
            return;
        }
        AdAdapter currentAdAdapter = this.mRewardedAdData.getAdAdapter(adUnitId);
        if (currentAdAdapter != null) {
            currentAdAdapter.invalidate();
        }
        String rewardedCurrencies = adResponse.getRewardedCurrencies();
        this.mRewardedAdData.resetAvailableRewards(adUnitId);
        this.mRewardedAdData.resetSelectedReward(adUnitId);
        if (TextUtils.isEmpty((CharSequence)rewardedCurrencies)) {
            this.mRewardedAdData.updateAdUnitRewardMapping(adUnitId, adResponse.getRewardedVideoCurrencyName(), adResponse.getRewardedVideoCurrencyAmount());
        } else {
            try {
                this.parseMultiCurrencyJson(adUnitId, rewardedCurrencies);
            }
            catch (Exception e) {
                MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"Error parsing rewarded currencies JSON header: " + rewardedCurrencies});
                this.failover(adUnitId, MoPubErrorCode.REWARDED_CURRENCIES_PARSING_ERROR);
                return;
            }
        }
        this.mRewardedAdData.updateAdUnitToServerCompletionUrlMapping(adUnitId, adResponse.getRewardedVideoCompletionUrl());
        Activity mainActivity = (Activity)this.mMainActivity.get();
        if (mainActivity == null) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"Could not load base ad because Activity reference was null. Call MoPub#updateActivity before requesting more rewarded ads."});
            this.rewardedAdsLoaders.markFail(adUnitId);
            return;
        }
        Map serverExtras = adResponse.getServerExtras();
        String serverExtrasJsonString = new JSONObject(serverExtras).toString();
        String impressionMinVisibleDipsString = adResponse.getImpressionMinVisibleDips();
        String impressionMinVisibleMsString = adResponse.getImpressionMinVisibleMs();
        int timeoutDelayMillis = adResponse.getAdTimeoutMillis(30000);
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{String.format(Locale.US, "Updating init settings for base ad %s with params %s", baseAdClassName, serverExtrasJsonString)});
        sBaseAdSharedPrefs.edit().putString(baseAdClassName, serverExtrasJsonString).apply();
        String adPayload = (String)serverExtras.remove("html-response-body");
        AdData.Builder adDataBuilder = new AdData.Builder().adUnit(adUnitId).isRewarded(true).adType(adResponse.getFullAdType()).adPayload(adPayload != null ? adPayload : "").currencyName(adResponse.getRewardedVideoCurrencyName()).impressionMinVisibleDips(impressionMinVisibleDipsString).impressionMinVisibleMs(impressionMinVisibleMsString).dspCreativeId(adResponse.getDspCreativeId()).broadcastIdentifier(Utils.generateUniqueId()).timeoutDelayMillis(timeoutDelayMillis).customerId(this.mRewardedAdData.getCustomerId()).allowCustomClose(false).fullAdType(adResponse.getFullAdType()).extras(serverExtras);
        Integer rewardedDuration = adResponse.getRewardedDuration();
        if (rewardedDuration != null) {
            adDataBuilder.rewardedDurationSeconds(rewardedDuration.intValue());
        }
        String currencyAmountString = adResponse.getRewardedVideoCurrencyAmount();
        int currencyAmount = 0;
        if (!TextUtils.isEmpty((CharSequence)currencyAmountString)) {
            try {
                currencyAmount = Integer.parseInt(currencyAmountString);
            }
            catch (NumberFormatException e) {
                MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"Unable to convert currency amount: " + currencyAmountString + ". Using the default reward amount: " + 0});
            }
        }
        adDataBuilder.currencyAmount(currencyAmount);
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{String.format(Locale.US, "Loading base ad with class name %s", baseAdClassName)});
        try {
            Class<AdAdapter> adAdapterClass = Class.forName(FULLSCREEN_AD_ADAPTER).asSubclass(AdAdapter.class);
            Constructor<AdAdapter> adAdapterConstructor = adAdapterClass.getDeclaredConstructor(Context.class, String.class, AdData.class);
            adAdapterConstructor.setAccessible(true);
            AdAdapter adAdapter = adAdapterConstructor.newInstance(MoPubRewardedVideoManager.sInstance.mMainActivity.get(), baseAdClassName, adDataBuilder.build());
            InternalRewardedVideoAdListener listener = new InternalRewardedVideoAdListener(adAdapter);
            Runnable timeout = () -> {
                MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"Base Ad failed to load rewarded ad in a timely fashion."});
                adAdapter.onAdLoadFailed(MoPubErrorCode.NETWORK_TIMEOUT);
                MoPubRewardedVideoManager.postToInstance(() -> ((AdAdapter)adAdapter).invalidate());
            };
            this.mBaseAdTimeoutHandler.postDelayed(timeout, (long)timeoutMillis.intValue());
            this.mTimeoutMap.put(adUnitId, timeout);
            adAdapter.load((AdLifecycleListener.LoadListener)listener);
            adAdapter.setInteractionListener((AdLifecycleListener.InteractionListener)listener);
            String adNetworkId = adAdapter.getAdNetworkId();
            this.mRewardedAdData.updateAdUnitAdAdapterMapping(adUnitId, adAdapter);
        }
        catch (Exception e) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{String.format(Locale.US, "Couldn't create base ad with class name %s", baseAdClassName)});
            this.failover(adUnitId, MoPubErrorCode.ADAPTER_CONFIGURATION_ERROR);
        }
    }

    void onAdError(@NonNull VolleyError volleyError, @NonNull String adUnitId) {
        MoPubErrorCode errorCode = MoPubErrorCode.INTERNAL_ERROR;
        if (volleyError instanceof MoPubNetworkError) {
            MoPubNetworkError err = (MoPubNetworkError)volleyError;
            switch (err.getReason()) {
                case NO_FILL: 
                case WARMING_UP: {
                    errorCode = MoPubErrorCode.NO_FILL;
                    break;
                }
                case TOO_MANY_REQUESTS: {
                    errorCode = MoPubErrorCode.TOO_MANY_REQUESTS;
                    break;
                }
                default: {
                    errorCode = MoPubErrorCode.INTERNAL_ERROR;
                }
            }
        }
        if (volleyError instanceof NoConnectionError) {
            errorCode = MoPubErrorCode.NO_CONNECTION;
        }
        this.failover(adUnitId, errorCode);
    }

    private void parseMultiCurrencyJson(@NonNull String adUnitId, @NonNull String rewardedCurrencies) throws JSONException {
        Map rewardsMap = Json.jsonStringToMap((String)rewardedCurrencies);
        String[] rewardsArray = Json.jsonArrayToStringArray((String)((String)rewardsMap.get(CURRENCIES_JSON_REWARDS_MAP_KEY)));
        if (rewardsArray.length == 1) {
            Map rewardData = Json.jsonStringToMap((String)rewardsArray[0]);
            this.mRewardedAdData.updateAdUnitRewardMapping(adUnitId, (String)rewardData.get(CURRENCIES_JSON_REWARD_NAME_KEY), (String)rewardData.get(CURRENCIES_JSON_REWARD_AMOUNT_KEY));
        }
        for (String rewardDataStr : rewardsArray) {
            Map rewardData = Json.jsonStringToMap((String)rewardDataStr);
            this.mRewardedAdData.addAvailableReward(adUnitId, (String)rewardData.get(CURRENCIES_JSON_REWARD_NAME_KEY), (String)rewardData.get(CURRENCIES_JSON_REWARD_AMOUNT_KEY));
        }
    }

    private void failover(@NonNull String adUnitId, @NonNull MoPubErrorCode errorCode) {
        Preconditions.checkNotNull((Object)adUnitId);
        Preconditions.checkNotNull((Object)errorCode);
        if (this.rewardedAdsLoaders.hasMoreAds(adUnitId) && !errorCode.equals((Object)MoPubErrorCode.EXPIRED)) {
            MoPubRewardedVideoManager.loadVideo(adUnitId, "", errorCode);
        } else if (MoPubRewardedVideoManager.sInstance.mVideoListener != null) {
            MoPubRewardedVideoManager.sInstance.mVideoListener.onRewardedVideoLoadFailure(adUnitId, errorCode);
        }
    }

    private void cancelTimeouts(@NonNull String adUnitId) {
        Runnable runnable = this.mTimeoutMap.remove(adUnitId);
        if (runnable != null) {
            this.mBaseAdTimeoutHandler.removeCallbacks(runnable);
        }
    }

    public static void onRewardedVideoLoadSuccess(@NonNull AdAdapter adAdapter, @NonNull String thirdPartyId) {
        MoPubRewardedVideoManager.postToInstance(new ForEachAdUnitIdRunnable(adAdapter){

            @Override
            protected void forEach(@NonNull String adUnitId) {
                sInstance.cancelTimeouts(adUnitId);
                sInstance.rewardedAdsLoaders.creativeDownloadSuccess(adUnitId);
                if (sInstance.mVideoListener != null) {
                    sInstance.mVideoListener.onRewardedVideoLoadSuccess(adUnitId);
                }
            }
        });
    }

    public static void onRewardedVideoLoadFailure(@NonNull AdAdapter adAdapter, String thirdPartyId, final MoPubErrorCode errorCode) {
        MoPubRewardedVideoManager.postToInstance(new ForEachAdUnitIdRunnable(adAdapter){

            @Override
            protected void forEach(@NonNull String adUnitId) {
                sInstance.cancelTimeouts(adUnitId);
                sInstance.failover(adUnitId, errorCode);
            }
        });
    }

    public static void onRewardedVideoStarted(@NonNull AdAdapter adAdapter, String thirdPartyId) {
        final String currentlyShowingAdUnitId = MoPubRewardedVideoManager.sInstance.mRewardedAdData.getCurrentlyShowingAdUnitId();
        if (TextUtils.isEmpty((CharSequence)currentlyShowingAdUnitId)) {
            MoPubRewardedVideoManager.postToInstance(new ForEachAdUnitIdRunnable(adAdapter){

                @Override
                protected void forEach(@NonNull String adUnitId) {
                    MoPubRewardedVideoManager.onRewardedVideoStartedAction(adUnitId);
                }
            });
        } else {
            MoPubRewardedVideoManager.postToInstance(new Runnable(){

                @Override
                public void run() {
                    MoPubRewardedVideoManager.onRewardedVideoStartedAction(currentlyShowingAdUnitId);
                }
            });
        }
    }

    private static void onRewardedVideoStartedAction(@NonNull String adUnitId) {
        Preconditions.checkNotNull((Object)adUnitId);
        if (MoPubRewardedVideoManager.sInstance.mVideoListener != null) {
            MoPubRewardedVideoManager.sInstance.mVideoListener.onRewardedVideoStarted(adUnitId);
        }
        MoPubRewardedVideoManager.sInstance.rewardedAdsLoaders.onRewardedVideoStarted(adUnitId, MoPubRewardedVideoManager.sInstance.mContext);
    }

    public static void onRewardedVideoPlaybackError(@NonNull AdAdapter adAdapter, String thirdPartyId, final MoPubErrorCode errorCode) {
        final String currentlyShowingAdUnitId = MoPubRewardedVideoManager.sInstance.mRewardedAdData.getCurrentlyShowingAdUnitId();
        if (TextUtils.isEmpty((CharSequence)currentlyShowingAdUnitId)) {
            MoPubRewardedVideoManager.postToInstance(new ForEachAdUnitIdRunnable(adAdapter){

                @Override
                protected void forEach(@NonNull String adUnitId) {
                    MoPubRewardedVideoManager.onRewardedVideoPlaybackErrorAction(adUnitId, errorCode);
                }
            });
        } else {
            MoPubRewardedVideoManager.postToInstance(new Runnable(){

                @Override
                public void run() {
                    MoPubRewardedVideoManager.onRewardedVideoPlaybackErrorAction(currentlyShowingAdUnitId, errorCode);
                }
            });
        }
        MoPubRewardedVideoManager.sInstance.mRewardedAdData.setCurrentlyShowingAdUnitId(null);
    }

    private static void onRewardedVideoPlaybackErrorAction(@NonNull String adUnitId, @NonNull MoPubErrorCode errorCode) {
        Preconditions.checkNotNull((Object)adUnitId);
        Preconditions.checkNotNull((Object)errorCode);
        MoPubRewardedVideoManager.sInstance.rewardedAdsLoaders.markFail(adUnitId);
        if (MoPubRewardedVideoManager.sInstance.mVideoListener != null) {
            MoPubRewardedVideoManager.sInstance.mVideoListener.onRewardedVideoPlaybackError(adUnitId, errorCode);
        }
    }

    public static void onRewardedVideoClicked(@NonNull AdAdapter adAdapter, String thirdPartyId) {
        final String currentlyShowingAdUnitId = MoPubRewardedVideoManager.sInstance.mRewardedAdData.getCurrentlyShowingAdUnitId();
        if (TextUtils.isEmpty((CharSequence)currentlyShowingAdUnitId)) {
            MoPubRewardedVideoManager.postToInstance(new ForEachAdUnitIdRunnable(adAdapter){

                @Override
                protected void forEach(@NonNull String adUnitId) {
                    MoPubRewardedVideoManager.onRewardedVideoClickedAction(adUnitId);
                }
            });
        } else {
            MoPubRewardedVideoManager.postToInstance(new Runnable(){

                @Override
                public void run() {
                    MoPubRewardedVideoManager.onRewardedVideoClickedAction(currentlyShowingAdUnitId);
                }
            });
        }
    }

    private static void onRewardedVideoClickedAction(@NonNull String adUnitId) {
        Preconditions.checkNotNull((Object)adUnitId);
        if (MoPubRewardedVideoManager.sInstance.mVideoListener != null) {
            MoPubRewardedVideoManager.sInstance.mVideoListener.onRewardedVideoClicked(adUnitId);
        }
        MoPubRewardedVideoManager.sInstance.rewardedAdsLoaders.onRewardedVideoClicked(adUnitId, MoPubRewardedVideoManager.sInstance.mContext);
    }

    public static void onRewardedVideoClosed(@NonNull AdAdapter adAdapter, String thirdPartyId) {
        final String currentlyShowingAdUnitId = MoPubRewardedVideoManager.sInstance.mRewardedAdData.getCurrentlyShowingAdUnitId();
        if (TextUtils.isEmpty((CharSequence)currentlyShowingAdUnitId)) {
            MoPubRewardedVideoManager.postToInstance(new ForEachAdUnitIdRunnable(adAdapter){

                @Override
                protected void forEach(@NonNull String adUnitId) {
                    MoPubRewardedVideoManager.onRewardedVideoClosedAction(adUnitId);
                }
            });
        } else {
            MoPubRewardedVideoManager.postToInstance(new Runnable(){

                @Override
                public void run() {
                    MoPubRewardedVideoManager.onRewardedVideoClosedAction(currentlyShowingAdUnitId);
                }
            });
        }
        MoPubRewardedVideoManager.sInstance.mRewardedAdData.setCurrentlyShowingAdUnitId(null);
    }

    private static void onRewardedVideoClosedAction(@NonNull String adUnitId) {
        Preconditions.checkNotNull((Object)adUnitId);
        MoPubRewardedVideoManager.sInstance.rewardedAdsLoaders.markPlayed(adUnitId);
        if (MoPubRewardedVideoManager.sInstance.mVideoListener != null) {
            MoPubRewardedVideoManager.sInstance.mVideoListener.onRewardedVideoClosed(adUnitId);
        }
    }

    public static void onRewardedVideoCompleted(@NonNull AdAdapter adAdapter, String thirdPartyId, @NonNull MoPubReward moPubReward) {
        String currentlyShowingAdUnitId = MoPubRewardedVideoManager.sInstance.mRewardedAdData.getCurrentlyShowingAdUnitId();
        MoPubRewardedVideoManager.rewardOnClient(adAdapter, moPubReward, currentlyShowingAdUnitId);
        MoPubRewardedVideoManager.rewardOnServer(currentlyShowingAdUnitId);
    }

    private static void rewardOnServer(final @Nullable String currentlyShowingAdUnitId) {
        final String serverCompletionUrl = MoPubRewardedVideoManager.sInstance.mRewardedAdData.getServerCompletionUrl(currentlyShowingAdUnitId);
        if (!TextUtils.isEmpty((CharSequence)serverCompletionUrl)) {
            MoPubRewardedVideoManager.postToInstance(new Runnable(){

                @Override
                public void run() {
                    MoPubReward reward = sInstance.mRewardedAdData.getMoPubReward(currentlyShowingAdUnitId);
                    String rewardName = reward == null ? "" : reward.getLabel();
                    String rewardAmount = reward == null ? Integer.toString(0) : Integer.toString(reward.getAmount());
                    AdAdapter adAdapter = sInstance.mRewardedAdData.getAdAdapter(currentlyShowingAdUnitId);
                    String className = adAdapter == null ? null : adAdapter.getBaseAdClassName();
                    String customData = sInstance.mRewardedAdData.getCustomData(currentlyShowingAdUnitId);
                    RewardedVideoCompletionRequestHandler.makeRewardedVideoCompletionRequest(sInstance.mContext, serverCompletionUrl, sInstance.mRewardedAdData.getCustomerId(), rewardName, rewardAmount, className, customData);
                }
            });
        }
    }

    private static void rewardOnClient(@NonNull AdAdapter adAdapter, @NonNull MoPubReward moPubReward, @Nullable String currentlyShowingAdUnitId) {
        MoPubRewardedVideoManager.postToInstance(() -> {
            MoPubReward chosenReward = MoPubRewardedVideoManager.chooseReward(MoPubRewardedVideoManager.sInstance.mRewardedAdData.getLastShownMoPubReward(adAdapter), moPubReward);
            HashSet<String> rewardedIds = new HashSet<String>();
            if (TextUtils.isEmpty((CharSequence)currentlyShowingAdUnitId)) {
                Set<String> adUnitIds = MoPubRewardedVideoManager.sInstance.mRewardedAdData.getAdUnitIdsForAdAdapter(adAdapter);
                rewardedIds.addAll(adUnitIds);
            } else {
                rewardedIds.add(currentlyShowingAdUnitId);
            }
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.SHOULD_REWARD, (Object[])new Object[]{chosenReward.getAmount(), chosenReward.getLabel()});
            if (MoPubRewardedVideoManager.sInstance.mVideoListener != null) {
                MoPubRewardedVideoManager.sInstance.mVideoListener.onRewardedVideoCompleted(rewardedIds, chosenReward);
            }
        });
    }

    @VisibleForTesting
    static MoPubReward chooseReward(@Nullable MoPubReward moPubReward, @NonNull MoPubReward networkReward) {
        if (!networkReward.isSuccessful()) {
            return networkReward;
        }
        return moPubReward != null ? moPubReward : networkReward;
    }

    private static void postToInstance(@NonNull Runnable runnable) {
        if (sInstance != null) {
            MoPubRewardedVideoManager.sInstance.mCallbackHandler.post(runnable);
        }
    }

    private static void logErrorNotInitialized() {
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"MoPub rewarded ad was not initialized. You must call MoPub.initializeSdk() with an Activity Context before loading or attempting to play rewarded ads."});
    }

    @Deprecated
    @VisibleForTesting
    @Nullable
    static RewardedAdData getRewardedAdData() {
        if (sInstance != null) {
            return MoPubRewardedVideoManager.sInstance.mRewardedAdData;
        }
        return null;
    }

    @Deprecated
    @VisibleForTesting
    @Nullable
    static RewardedAdsLoaders getAdRequestStatusMapping() {
        if (sInstance != null) {
            return MoPubRewardedVideoManager.sInstance.rewardedAdsLoaders;
        }
        return null;
    }

    @Deprecated
    @VisibleForTesting
    static void setBaseAdSharedPrefs(@NonNull SharedPreferences sharedPrefs) {
        Preconditions.checkNotNull((Object)sharedPrefs);
        sBaseAdSharedPrefs = sharedPrefs;
    }

    private static class InternalRewardedVideoAdListener
    implements AdLifecycleListener.LoadListener,
    AdLifecycleListener.InteractionListener {
        final AdAdapter adAdapter;

        InternalRewardedVideoAdListener(AdAdapter adAdapter) {
            this.adAdapter = adAdapter;
        }

        public void onAdLoaded() {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.LOAD_SUCCESS, (Object[])new Object[0]);
            MoPubRewardedVideoManager.onRewardedVideoLoadSuccess(this.adAdapter, this.adAdapter.getAdNetworkId());
        }

        public void onAdLoadFailed(@NonNull MoPubErrorCode errorCode) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.LOAD_FAILED, (Object[])new Object[]{errorCode.getIntCode(), errorCode});
            this.onAdFailed(errorCode);
        }

        public void onAdFailed(@NonNull MoPubErrorCode errorCode) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.SHOW_FAILED, (Object[])new Object[]{errorCode.getIntCode(), errorCode});
            switch (errorCode) {
                case VIDEO_PLAYBACK_ERROR: 
                case EXPIRED: {
                    MoPubRewardedVideoManager.onRewardedVideoPlaybackError(this.adAdapter, this.adAdapter.getAdNetworkId(), errorCode);
                    break;
                }
                default: {
                    MoPubRewardedVideoManager.onRewardedVideoLoadFailure(this.adAdapter, this.adAdapter.getAdNetworkId(), errorCode);
                }
            }
        }

        public void onAdShown() {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.SHOW_SUCCESS, (Object[])new Object[0]);
            MoPubRewardedVideoManager.onRewardedVideoStarted(this.adAdapter, this.adAdapter.getAdNetworkId());
        }

        public void onAdClicked() {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.CLICKED, (Object[])new Object[0]);
            MoPubRewardedVideoManager.onRewardedVideoClicked(this.adAdapter, this.adAdapter.getAdNetworkId());
        }

        public void onAdImpression() {
        }

        public void onAdDismissed() {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdLogEvent.DID_DISAPPEAR, (Object[])new Object[0]);
            MoPubRewardedVideoManager.onRewardedVideoClosed(this.adAdapter, this.adAdapter.getAdNetworkId());
        }

        public void onAdComplete(@Nullable MoPubReward moPubReward) {
            MoPubReward actualReward = moPubReward;
            if (actualReward == null) {
                actualReward = MoPubReward.success((String)"", (int)0);
            }
            MoPubRewardedVideoManager.onRewardedVideoCompleted(this.adAdapter, this.adAdapter.getAdNetworkId(), actualReward);
        }

        public void onAdCollapsed() {
        }

        public void onAdExpanded() {
        }

        public void onAdPauseAutoRefresh() {
        }

        public void onAdResumeAutoRefresh() {
        }
    }

    private static abstract class ForEachAdUnitIdRunnable
    implements Runnable {
        @NonNull
        private final AdAdapter mAdAdapter;

        ForEachAdUnitIdRunnable(@NonNull AdAdapter adAdapter) {
            Preconditions.checkNotNull((Object)adAdapter);
            this.mAdAdapter = adAdapter;
        }

        protected abstract void forEach(@NonNull String var1);

        @Override
        public void run() {
            Set<String> adUnitIds = sInstance.mRewardedAdData.getAdUnitIdsForAdAdapter(this.mAdAdapter);
            for (String adUnitId : adUnitIds) {
                this.forEach(adUnitId);
            }
        }
    }

    public static final class RequestParameters {
        @Nullable
        public final String mKeywords;
        @Nullable
        public final String mUserDataKeywords;
        @Nullable
        public final Location mLocation;
        @Nullable
        public final String mCustomerId;

        public RequestParameters(@Nullable String keywords) {
            this(keywords, null);
        }

        public RequestParameters(@Nullable String keywords, @Nullable String userDataKeywords) {
            this(keywords, userDataKeywords, null);
        }

        public RequestParameters(@Nullable String keywords, @Nullable String userDataKeywords, @Nullable Location location) {
            this(keywords, userDataKeywords, location, null);
        }

        public RequestParameters(@Nullable String keywords, @Nullable String userDataKeywords, @Nullable Location location, @Nullable String customerId) {
            this.mKeywords = keywords;
            this.mCustomerId = customerId;
            boolean canCollectPersonalInformation = MoPub.canCollectPersonalInformation();
            this.mUserDataKeywords = canCollectPersonalInformation ? userDataKeywords : null;
            this.mLocation = canCollectPersonalInformation ? location : null;
        }
    }
}

