/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.MediationSettings;
import com.mopub.common.MoPubReward;
import com.mopub.common.Preconditions;
import com.mopub.common.SdkConfiguration;
import com.mopub.common.util.ReflectionTarget;
import com.mopub.mobileads.MoPubRewardedVideoListener;
import com.mopub.mobileads.MoPubRewardedVideoManager;
import java.util.Set;

public class MoPubRewardedVideos {
    @ReflectionTarget
    private static void initializeRewardedVideo(@NonNull Activity activity, MediationSettings ... mediationSettings) {
        Preconditions.checkNotNull((Object)activity);
        MoPubRewardedVideoManager.init(activity, mediationSettings);
    }

    @ReflectionTarget
    private static void initializeRewardedVideo(@NonNull Activity activity, @NonNull SdkConfiguration sdkConfiguration) {
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkNotNull((Object)sdkConfiguration);
        MoPubRewardedVideos.initializeRewardedVideo(activity, sdkConfiguration.getMediationSettings());
    }

    @ReflectionTarget
    public static void setRewardedVideoListener(@Nullable MoPubRewardedVideoListener listener) {
        MoPubRewardedVideoManager.setVideoListener(listener);
    }

    @ReflectionTarget
    public static void loadRewardedVideo(@NonNull String adUnitId, MediationSettings ... mediationSettings) {
        Preconditions.checkNotNull((Object)adUnitId);
        MoPubRewardedVideoManager.loadVideo(adUnitId, null, mediationSettings);
    }

    @ReflectionTarget
    public static void loadRewardedVideo(@NonNull String adUnitId, @Nullable MoPubRewardedVideoManager.RequestParameters requestParameters, MediationSettings ... mediationSettings) {
        Preconditions.checkNotNull((Object)adUnitId);
        MoPubRewardedVideoManager.loadVideo(adUnitId, requestParameters, mediationSettings);
    }

    @ReflectionTarget
    public static boolean hasRewardedVideo(@NonNull String adUnitId) {
        Preconditions.checkNotNull((Object)adUnitId);
        return MoPubRewardedVideoManager.hasVideo(adUnitId);
    }

    @ReflectionTarget
    public static void showRewardedVideo(@NonNull String adUnitId) {
        Preconditions.checkNotNull((Object)adUnitId);
        MoPubRewardedVideoManager.showVideo(adUnitId);
    }

    @ReflectionTarget
    public static void showRewardedVideo(@NonNull String adUnitId, @Nullable String customData) {
        Preconditions.checkNotNull((Object)adUnitId);
        MoPubRewardedVideoManager.showVideo(adUnitId, customData);
    }

    @ReflectionTarget
    public static Set<MoPubReward> getAvailableRewards(@NonNull String adUnitId) {
        Preconditions.checkNotNull((Object)adUnitId);
        return MoPubRewardedVideoManager.getAvailableRewards(adUnitId);
    }

    @ReflectionTarget
    public static void selectReward(@NonNull String adUnitId, @NonNull MoPubReward selectedReward) {
        Preconditions.checkNotNull((Object)adUnitId);
        Preconditions.checkNotNull((Object)selectedReward);
        MoPubRewardedVideoManager.selectReward(adUnitId, selectedReward);
    }
}

