/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.MoPubReward;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.AdAdapter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class RewardedAdData {
    @NonNull
    private final Map<String, AdAdapter> mAdUnitToAdAdapterMap = new TreeMap<String, AdAdapter>();
    @NonNull
    private final Map<String, MoPubReward> mAdUnitToRewardMap = new TreeMap<String, MoPubReward>();
    @NonNull
    private final Map<String, Set<MoPubReward>> mAdUnitToAvailableRewardsMap = new TreeMap<String, Set<MoPubReward>>();
    @NonNull
    private final Map<String, String> mAdUnitToServerCompletionUrlMap = new TreeMap<String, String>();
    @NonNull
    private final Map<String, String> mAdUnitToCustomDataMap = new TreeMap<String, String>();
    @NonNull
    private final Map<AdAdapter, MoPubReward> mAdAdapterToRewardMap = new HashMap<AdAdapter, MoPubReward>();
    @NonNull
    private final Map<AdAdapter, Set<String>> mAdAdapterToAdUnitIdMap = new HashMap<AdAdapter, Set<String>>();
    @Nullable
    private String mCurrentlyShowingAdUnitId;
    @Nullable
    private String mCustomerId;

    RewardedAdData() {
    }

    @Nullable
    AdAdapter getAdAdapter(@Nullable String adUnitId) {
        return this.mAdUnitToAdAdapterMap.get(adUnitId);
    }

    @Nullable
    MoPubReward getMoPubReward(@Nullable String adUnitId) {
        return this.mAdUnitToRewardMap.get(adUnitId);
    }

    @Nullable
    String getCustomData(@Nullable String adUnitId) {
        return this.mAdUnitToCustomDataMap.get(adUnitId);
    }

    void addAvailableReward(@NonNull String adUnitId, @Nullable String currencyName, @Nullable String currencyAmount) {
        int intCurrencyAmount;
        Preconditions.checkNotNull((Object)adUnitId);
        if (currencyName == null || currencyAmount == null) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{String.format(Locale.US, "Currency name and amount cannot be null: name = %s, amount = %s", currencyName, currencyAmount)});
            return;
        }
        try {
            intCurrencyAmount = Integer.parseInt(currencyAmount);
        }
        catch (NumberFormatException e) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{String.format(Locale.US, "Currency amount must be an integer: %s", currencyAmount)});
            return;
        }
        if (intCurrencyAmount < 0) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{String.format(Locale.US, "Currency amount cannot be negative: %s", currencyAmount)});
            return;
        }
        if (this.mAdUnitToAvailableRewardsMap.containsKey(adUnitId)) {
            this.mAdUnitToAvailableRewardsMap.get(adUnitId).add(MoPubReward.success((String)currencyName, (int)intCurrencyAmount));
        } else {
            HashSet<MoPubReward> availableRewards = new HashSet<MoPubReward>();
            availableRewards.add(MoPubReward.success((String)currencyName, (int)intCurrencyAmount));
            this.mAdUnitToAvailableRewardsMap.put(adUnitId, availableRewards);
        }
    }

    @NonNull
    Set<MoPubReward> getAvailableRewards(@NonNull String adUnitId) {
        Preconditions.checkNotNull((Object)adUnitId);
        Set<MoPubReward> availableRewards = this.mAdUnitToAvailableRewardsMap.get(adUnitId);
        return availableRewards == null ? Collections.emptySet() : availableRewards;
    }

    void selectReward(@NonNull String adUnitId, @NonNull MoPubReward selectedReward) {
        Preconditions.checkNotNull((Object)adUnitId);
        Preconditions.checkNotNull((Object)selectedReward);
        Set<MoPubReward> availableRewards = this.mAdUnitToAvailableRewardsMap.get(adUnitId);
        if (availableRewards == null || availableRewards.isEmpty()) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{String.format(Locale.US, "AdUnit %s does not have any rewards.", adUnitId)});
            return;
        }
        if (!availableRewards.contains(selectedReward)) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{String.format(Locale.US, "Selected reward is invalid for AdUnit %s.", adUnitId)});
            return;
        }
        this.updateAdUnitRewardMapping(adUnitId, selectedReward.getLabel(), Integer.toString(selectedReward.getAmount()));
    }

    void resetAvailableRewards(@NonNull String adUnitId) {
        Preconditions.checkNotNull((Object)adUnitId);
        Set<MoPubReward> availableRewards = this.mAdUnitToAvailableRewardsMap.get(adUnitId);
        if (availableRewards != null && !availableRewards.isEmpty()) {
            availableRewards.clear();
        }
    }

    void resetSelectedReward(@NonNull String adUnitId) {
        Preconditions.checkNotNull((Object)adUnitId);
        this.updateAdUnitRewardMapping(adUnitId, null, null);
    }

    @Nullable
    String getServerCompletionUrl(@Nullable String adUnitId) {
        if (TextUtils.isEmpty((CharSequence)adUnitId)) {
            return null;
        }
        return this.mAdUnitToServerCompletionUrlMap.get(adUnitId);
    }

    @Nullable
    MoPubReward getLastShownMoPubReward(@NonNull AdAdapter adAdapter) {
        return this.mAdAdapterToRewardMap.get(adAdapter);
    }

    @NonNull
    Set<String> getAdUnitIdsForAdAdapter(@NonNull AdAdapter adAdapter) {
        Preconditions.checkNotNull((Object)adAdapter);
        HashSet<String> allIds = new HashSet<String>();
        for (Map.Entry<AdAdapter, Set<String>> entry : this.mAdAdapterToAdUnitIdMap.entrySet()) {
            AdAdapter currentAdAdapter = entry.getKey();
            if (adAdapter != currentAdAdapter) continue;
            allIds.addAll((Collection<String>)entry.getValue());
        }
        return allIds;
    }

    void updateAdUnitAdAdapterMapping(@NonNull String adUnitId, @NonNull AdAdapter adAdapter) {
        Preconditions.checkNotNull((Object)adUnitId);
        Preconditions.checkNotNull((Object)adAdapter);
        this.mAdUnitToAdAdapterMap.put(adUnitId, adAdapter);
        this.associateAdAdapterWithAdUnitId(adAdapter, adUnitId);
    }

    void updateAdUnitRewardMapping(@NonNull String adUnitId, @Nullable String currencyName, @Nullable String currencyAmount) {
        int intCurrencyAmount;
        Preconditions.checkNotNull((Object)adUnitId);
        if (currencyName == null || currencyAmount == null) {
            this.mAdUnitToRewardMap.remove(adUnitId);
            return;
        }
        try {
            intCurrencyAmount = Integer.parseInt(currencyAmount);
        }
        catch (NumberFormatException e) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{String.format(Locale.US, "Currency amount must be an integer: %s", currencyAmount)});
            return;
        }
        if (intCurrencyAmount < 0) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{String.format(Locale.US, "Currency amount cannot be negative: %s", currencyAmount)});
            return;
        }
        this.mAdUnitToRewardMap.put(adUnitId, MoPubReward.success((String)currencyName, (int)intCurrencyAmount));
    }

    void updateAdUnitToServerCompletionUrlMapping(@NonNull String adUnitId, @Nullable String serverCompletionUrl) {
        Preconditions.checkNotNull((Object)adUnitId);
        this.mAdUnitToServerCompletionUrlMap.put(adUnitId, serverCompletionUrl);
    }

    void updateLastShownRewardMapping(@NonNull AdAdapter adAdapter, @Nullable MoPubReward moPubReward) {
        Preconditions.checkNotNull((Object)adAdapter);
        this.mAdAdapterToRewardMap.put(adAdapter, moPubReward);
    }

    void associateAdAdapterWithAdUnitId(@NonNull AdAdapter adAdapter, @NonNull String adUnitId) {
        Set<String> adUnitIds;
        Iterator<Map.Entry<AdAdapter, Set<String>>> entryIterator = this.mAdAdapterToAdUnitIdMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<AdAdapter, Set<String>> entry = entryIterator.next();
            if (entry.getKey().equals(adAdapter) || !entry.getValue().contains(adUnitId)) continue;
            entry.getValue().remove(adUnitId);
            if (!entry.getValue().isEmpty()) break;
            entryIterator.remove();
            break;
        }
        if ((adUnitIds = this.mAdAdapterToAdUnitIdMap.get(adAdapter)) == null) {
            adUnitIds = new HashSet<String>();
            this.mAdAdapterToAdUnitIdMap.put(adAdapter, adUnitIds);
        }
        adUnitIds.add(adUnitId);
    }

    void setCurrentlyShowingAdUnitId(@Nullable String currentAdUnitId) {
        this.mCurrentlyShowingAdUnitId = currentAdUnitId;
    }

    void updateAdUnitToCustomDataMapping(@NonNull String adUnitId, @Nullable String customData) {
        Preconditions.NoThrow.checkNotNull((Object)adUnitId);
        this.mAdUnitToCustomDataMap.put(adUnitId, customData);
    }

    @Nullable
    String getCurrentlyShowingAdUnitId() {
        return this.mCurrentlyShowingAdUnitId;
    }

    void setCustomerId(@Nullable String customerId) {
        this.mCustomerId = customerId;
    }

    @Nullable
    String getCustomerId() {
        return this.mCustomerId;
    }

    @Deprecated
    @VisibleForTesting
    void clear() {
        this.mAdUnitToAdAdapterMap.clear();
        this.mAdUnitToRewardMap.clear();
        this.mAdUnitToAvailableRewardsMap.clear();
        this.mAdUnitToServerCompletionUrlMap.clear();
        this.mAdUnitToCustomDataMap.clear();
        this.mAdAdapterToRewardMap.clear();
        this.mAdAdapterToAdUnitIdMap.clear();
        this.mCurrentlyShowingAdUnitId = null;
        this.mCustomerId = null;
    }

    @Deprecated
    @VisibleForTesting
    boolean existsInAvailableRewards(@NonNull String adUnitId, @NonNull String currencyName, int currencyAmount) {
        Preconditions.checkNotNull((Object)adUnitId);
        Preconditions.checkNotNull((Object)currencyName);
        for (MoPubReward reward : this.getAvailableRewards(adUnitId)) {
            if (!reward.getLabel().equals(currencyName) || reward.getAmount() != currencyAmount) continue;
            return true;
        }
        return false;
    }

    private static class TwoPartKey
    extends Pair<AdAdapter, String> {
        @NonNull
        final AdAdapter adAdapter;
        @NonNull
        final String adNetworkId;

        public TwoPartKey(@NonNull AdAdapter adAdapter, @NonNull String adNetworkId) {
            super((Object)adAdapter, (Object)adNetworkId);
            this.adAdapter = adAdapter;
            this.adNetworkId = adNetworkId;
        }
    }
}

