/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.AdFormat;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.mobileads.AdLoaderRewardedVideo;
import com.mopub.mobileads.MoPubError;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MoPubRewardedVideoManager;
import com.mopub.network.AdLoader;
import com.mopub.network.AdResponse;
import com.mopub.volley.Request;
import com.mopub.volley.VolleyError;
import java.util.HashMap;
import java.util.Map;

class RewardedAdsLoaders {
    @NonNull
    private final HashMap<String, AdLoaderRewardedVideo> mAdUnitToAdLoader;
    @NonNull
    private final MoPubRewardedVideoManager moPubRewardedVideoManager;

    RewardedAdsLoaders(@NonNull MoPubRewardedVideoManager rewardedVideoManager) {
        this.moPubRewardedVideoManager = rewardedVideoManager;
        this.mAdUnitToAdLoader = new HashMap();
    }

    @Nullable
    Request<?> loadNextAd(@NonNull Context context, @NonNull String adUnitId, @NonNull String adUrlString, @Nullable MoPubErrorCode errorCode) {
        Preconditions.checkNotNull((Object)adUnitId);
        Preconditions.checkNotNull((Object)context);
        AdLoaderRewardedVideo adLoader = this.mAdUnitToAdLoader.get(adUnitId);
        if (adLoader == null || !adLoader.hasMoreAds()) {
            adLoader = new AdLoaderRewardedVideo(adUrlString, AdFormat.REWARDED_VIDEO, adUnitId, context, new RewardedVideoRequestListener(adUnitId));
            this.mAdUnitToAdLoader.put(adUnitId, adLoader);
        }
        return adLoader.loadNextAd((MoPubError)errorCode);
    }

    boolean isLoading(@NonNull String adUnitId) {
        return this.mAdUnitToAdLoader.containsKey(adUnitId) && this.mAdUnitToAdLoader.get(adUnitId).isRunning();
    }

    void markFail(@NonNull String adUnitId) {
        Preconditions.checkNotNull((Object)adUnitId);
        if (this.mAdUnitToAdLoader.containsKey(adUnitId)) {
            this.mAdUnitToAdLoader.remove(adUnitId);
        }
    }

    void markPlayed(@NonNull String adUnitId) {
        Preconditions.checkNotNull((Object)adUnitId);
        if (this.mAdUnitToAdLoader.containsKey(adUnitId)) {
            this.mAdUnitToAdLoader.remove(adUnitId);
        }
    }

    void onRewardedVideoStarted(@NonNull String adUnitId, @NonNull Context context) {
        Preconditions.checkNotNull((Object)adUnitId);
        Preconditions.checkNotNull((Object)context);
        AdLoaderRewardedVideo loaderRewardedVideo = this.mAdUnitToAdLoader.get(adUnitId);
        if (loaderRewardedVideo == null) {
            return;
        }
        loaderRewardedVideo.trackImpression(context);
    }

    void onRewardedVideoClicked(@NonNull String adUnitId, @NonNull Context context) {
        Preconditions.checkNotNull((Object)adUnitId);
        Preconditions.checkNotNull((Object)context);
        AdLoaderRewardedVideo loaderRewardedVideo = this.mAdUnitToAdLoader.get(adUnitId);
        if (loaderRewardedVideo == null) {
            return;
        }
        loaderRewardedVideo.trackClick(context);
    }

    boolean canPlay(@NonNull String adUnitId) {
        AdLoaderRewardedVideo loaderRewardedVideo = this.mAdUnitToAdLoader.get(adUnitId);
        if (loaderRewardedVideo == null) {
            return false;
        }
        AdResponse adResponse = loaderRewardedVideo.getLastDeliveredResponse();
        return adResponse != null;
    }

    boolean hasMoreAds(@NonNull String adUnitId) {
        AdLoaderRewardedVideo loaderRewardedVideo = this.mAdUnitToAdLoader.get(adUnitId);
        return loaderRewardedVideo != null && loaderRewardedVideo.hasMoreAds();
    }

    void creativeDownloadSuccess(@NonNull String adUnitId) {
        AdLoaderRewardedVideo loaderRewardedVideo = this.mAdUnitToAdLoader.get(adUnitId);
        if (loaderRewardedVideo == null) {
            return;
        }
        loaderRewardedVideo.creativeDownloadSuccess();
    }

    @Deprecated
    @VisibleForTesting
    void clearMapping() {
        this.mAdUnitToAdLoader.clear();
    }

    @Deprecated
    @VisibleForTesting
    Map<String, AdLoaderRewardedVideo> getLoadersMap() {
        return this.mAdUnitToAdLoader;
    }

    public class RewardedVideoRequestListener
    implements AdLoader.Listener {
        public final String adUnitId;

        RewardedVideoRequestListener(String adUnitId) {
            this.adUnitId = adUnitId;
        }

        public void onSuccess(AdResponse response) {
            RewardedAdsLoaders.this.moPubRewardedVideoManager.onAdSuccess(response);
        }

        public void onErrorResponse(VolleyError volleyError) {
            RewardedAdsLoaders.this.moPubRewardedVideoManager.onAdError(volleyError, this.adUnitId);
        }
    }
}

