/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.RewardedVideoCompletionRequest;
import com.mopub.network.Networking;
import com.mopub.volley.DefaultRetryPolicy;
import com.mopub.volley.Request;
import com.mopub.volley.RequestQueue;
import com.mopub.volley.RetryPolicy;
import com.mopub.volley.VolleyError;

public class RewardedVideoCompletionRequestHandler
implements RewardedVideoCompletionRequest.RewardedVideoCompletionRequestListener {
    static final int[] RETRY_TIMES = new int[]{5000, 10000, 20000, 40000, 60000};
    static final int REQUEST_TIMEOUT_DELAY = 1000;
    static final int MAX_RETRIES = 17;
    private static final String CUSTOMER_ID_KEY = "&customer_id=";
    private static final String SDK_VERSION_KEY = "&nv=";
    private static final String API_VERSION_KEY = "&v=";
    private static final String REWARD_NAME_KEY = "&rcn=";
    private static final String REWARD_AMOUNT_KEY = "&rca=";
    private static final String CUSTOM_EVENT_CLASS_NAME_KEY = "&cec=";
    private static final String CUSTOM_DATA_KEY = "&rcd=";
    @NonNull
    private final String mUrl;
    @NonNull
    private final Handler mHandler;
    @NonNull
    private final RequestQueue mRequestQueue;
    @NonNull
    private final Context mContext;
    private int mRetryCount;
    private volatile boolean mShouldStop;

    RewardedVideoCompletionRequestHandler(@NonNull Context context, @NonNull String url, @Nullable String customerId, @NonNull String rewardName, @NonNull String rewardAmount, @Nullable String className, @Nullable String customData) {
        this(context, url, customerId, rewardName, rewardAmount, className, customData, new Handler());
    }

    @VisibleForTesting
    RewardedVideoCompletionRequestHandler(@NonNull Context context, @NonNull String url, @Nullable String customerId, @NonNull String rewardName, @NonNull String rewardAmount, @Nullable String className, @Nullable String customData, @NonNull Handler handler) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)url);
        Preconditions.checkNotNull((Object)rewardName);
        Preconditions.checkNotNull((Object)rewardAmount);
        Preconditions.checkNotNull((Object)handler);
        this.mUrl = RewardedVideoCompletionRequestHandler.appendParameters(url, customerId, rewardName, rewardAmount, className, customData);
        this.mRetryCount = 0;
        this.mHandler = handler;
        this.mRequestQueue = Networking.getRequestQueue((Context)context);
        this.mContext = context.getApplicationContext();
    }

    void makeRewardedVideoCompletionRequest() {
        if (this.mShouldStop) {
            this.mRequestQueue.cancelAll((Object)this.mUrl);
            return;
        }
        RewardedVideoCompletionRequest rewardedVideoCompletionRequest = new RewardedVideoCompletionRequest(this.mContext, this.mUrl, (RetryPolicy)new DefaultRetryPolicy(RewardedVideoCompletionRequestHandler.getTimeout(this.mRetryCount) - 1000, 0, 0.0f), this);
        rewardedVideoCompletionRequest.setTag(this.mUrl);
        this.mRequestQueue.add((Request)rewardedVideoCompletionRequest);
        if (this.mRetryCount >= 17) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"Exceeded number of retries for rewarded video completion request."});
            return;
        }
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                RewardedVideoCompletionRequestHandler.this.makeRewardedVideoCompletionRequest();
            }
        }, (long)RewardedVideoCompletionRequestHandler.getTimeout(this.mRetryCount));
        ++this.mRetryCount;
    }

    @Override
    public void onResponse(Integer response) {
        if (response != null && (response < 500 || response >= 600)) {
            this.mShouldStop = true;
        }
    }

    public void onErrorResponse(VolleyError volleyError) {
        if (volleyError != null && volleyError.networkResponse != null && (volleyError.networkResponse.statusCode < 500 || volleyError.networkResponse.statusCode >= 600)) {
            this.mShouldStop = true;
        }
    }

    public static void makeRewardedVideoCompletionRequest(@Nullable Context context, @Nullable String url, @Nullable String customerId, @NonNull String rewardName, @NonNull String rewardAmount, @Nullable String rewardedAd, @Nullable String customData) {
        if (context == null || TextUtils.isEmpty((CharSequence)url) || rewardName == null || rewardAmount == null) {
            return;
        }
        new RewardedVideoCompletionRequestHandler(context, url, customerId, rewardName, rewardAmount, rewardedAd, customData).makeRewardedVideoCompletionRequest();
    }

    static int getTimeout(int retryCount) {
        if (retryCount >= 0 && retryCount < RETRY_TIMES.length) {
            return RETRY_TIMES[retryCount];
        }
        return RETRY_TIMES[RETRY_TIMES.length - 1];
    }

    private static String appendParameters(@NonNull String url, @Nullable String customerId, @NonNull String rewardName, @NonNull String rewardAmount, @Nullable String className, @Nullable String customData) {
        Preconditions.checkNotNull((Object)url);
        Preconditions.checkNotNull((Object)rewardName);
        Preconditions.checkNotNull((Object)rewardAmount);
        StringBuilder stringBuilder = new StringBuilder(url);
        stringBuilder.append(CUSTOMER_ID_KEY).append(customerId == null ? "" : Uri.encode((String)customerId)).append(REWARD_NAME_KEY).append(Uri.encode((String)rewardName)).append(REWARD_AMOUNT_KEY).append(Uri.encode((String)rewardAmount)).append(SDK_VERSION_KEY).append(Uri.encode((String)"5.14.0")).append(API_VERSION_KEY).append(1).append(CUSTOM_EVENT_CLASS_NAME_KEY).append(className == null ? "" : Uri.encode((String)className));
        if (!TextUtils.isEmpty((CharSequence)customData)) {
            stringBuilder.append(CUSTOM_DATA_KEY).append(Uri.encode((String)customData));
        }
        return stringBuilder.toString();
    }

    @Deprecated
    @VisibleForTesting
    boolean getShouldStop() {
        return this.mShouldStop;
    }

    @Deprecated
    @VisibleForTesting
    int getRetryCount() {
        return this.mRetryCount;
    }

    @Deprecated
    @VisibleForTesting
    void setRetryCount(int retryCount) {
        this.mRetryCount = retryCount;
    }
}

