/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Dips;
import com.mopub.common.util.Drawables;
import com.mopub.mobileads.VastVideoProgressBarWidget;
import com.mopub.mobileads.resource.DrawableConstants;

public class MediaLayout
extends RelativeLayout {
    private static final int GRADIENT_STRIP_HEIGHT_DIPS = 35;
    private static final int MUTE_SIZE_DIPS = 36;
    private static final int CONTROL_SIZE_DIPS = 40;
    private static final int PINNER_PADDING_DIPS = 10;
    private static final float ASPECT_MULTIPLIER_WIDTH_TO_HEIGHT = 0.5625f;
    private static final float ASPECT_MULTIPLIER_HEIGHT_TO_WIDTH = 1.7777778f;
    @NonNull
    private volatile Mode mMode = Mode.IMAGE;
    @NonNull
    private MuteState mMuteState;
    @NonNull
    private ImageView mMainImageView;
    @Nullable
    private TextureView mVideoTextureView;
    @Nullable
    private ProgressBar mLoadingSpinner;
    @Nullable
    private ImageView mPlayButton;
    @Nullable
    private ImageView mBottomGradient;
    @Nullable
    private ImageView mTopGradient;
    @Nullable
    private VastVideoProgressBarWidget mVideoProgress;
    @Nullable
    private ImageView mMuteControl;
    @Nullable
    private View mOverlay;
    @Nullable
    private Drawable mMutedDrawable;
    @Nullable
    private Drawable mUnmutedDrawable;
    private boolean mIsInitialized;
    private final int mControlSizePx;
    private final int mGradientStripHeightPx;
    private final int mMuteSizePx;
    private final int mPaddingPx;

    public MediaLayout(@NonNull Context context) {
        this(context, null);
    }

    public MediaLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MediaLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        Preconditions.checkNotNull((Object)context);
        this.mMuteState = MuteState.MUTED;
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        params.addRule(13);
        this.mMainImageView = new ImageView(context);
        this.mMainImageView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mMainImageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.addView((View)this.mMainImageView);
        this.mControlSizePx = Dips.asIntPixels((float)40.0f, (Context)context);
        this.mGradientStripHeightPx = Dips.asIntPixels((float)35.0f, (Context)context);
        this.mMuteSizePx = Dips.asIntPixels((float)36.0f, (Context)context);
        this.mPaddingPx = Dips.asIntPixels((float)10.0f, (Context)context);
    }

    public void setSurfaceTextureListener(@Nullable TextureView.SurfaceTextureListener stl) {
        if (this.mVideoTextureView != null) {
            this.mVideoTextureView.setSurfaceTextureListener(stl);
            SurfaceTexture st = this.mVideoTextureView.getSurfaceTexture();
            if (st != null && stl != null) {
                stl.onSurfaceTextureAvailable(st, this.mVideoTextureView.getWidth(), this.mVideoTextureView.getHeight());
            }
        }
    }

    public void initForVideo() {
        if (this.mIsInitialized) {
            return;
        }
        RelativeLayout.LayoutParams videoTextureLayoutParams = new RelativeLayout.LayoutParams(-1, -1);
        videoTextureLayoutParams.addRule(13);
        this.mVideoTextureView = new TextureView(this.getContext());
        this.mVideoTextureView.setLayoutParams((ViewGroup.LayoutParams)videoTextureLayoutParams);
        this.mVideoTextureView.setId(View.generateViewId());
        this.addView((View)this.mVideoTextureView);
        this.mMainImageView.bringToFront();
        RelativeLayout.LayoutParams loadingSpinnerParams = new RelativeLayout.LayoutParams(this.mControlSizePx, this.mControlSizePx);
        loadingSpinnerParams.addRule(10);
        loadingSpinnerParams.addRule(11);
        this.mLoadingSpinner = new ProgressBar(this.getContext());
        this.mLoadingSpinner.setLayoutParams((ViewGroup.LayoutParams)loadingSpinnerParams);
        this.mLoadingSpinner.setPadding(0, this.mPaddingPx, this.mPaddingPx, 0);
        this.mLoadingSpinner.setIndeterminate(true);
        this.addView((View)this.mLoadingSpinner);
        RelativeLayout.LayoutParams bottomGradientParams = new RelativeLayout.LayoutParams(-1, this.mGradientStripHeightPx);
        bottomGradientParams.addRule(8, this.mVideoTextureView.getId());
        this.mBottomGradient = new ImageView(this.getContext());
        this.mBottomGradient.setLayoutParams((ViewGroup.LayoutParams)bottomGradientParams);
        GradientDrawable bottomGradientDrawable = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{DrawableConstants.GradientStrip.START_COLOR, DrawableConstants.GradientStrip.END_COLOR});
        this.mBottomGradient.setImageDrawable((Drawable)bottomGradientDrawable);
        this.addView((View)this.mBottomGradient);
        RelativeLayout.LayoutParams topGradientParams = new RelativeLayout.LayoutParams(-1, this.mGradientStripHeightPx);
        topGradientParams.addRule(6, this.mVideoTextureView.getId());
        this.mTopGradient = new ImageView(this.getContext());
        this.mTopGradient.setLayoutParams((ViewGroup.LayoutParams)topGradientParams);
        GradientDrawable topGradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{DrawableConstants.GradientStrip.START_COLOR, DrawableConstants.GradientStrip.END_COLOR});
        this.mTopGradient.setImageDrawable((Drawable)topGradientDrawable);
        this.addView((View)this.mTopGradient);
        this.mVideoProgress = new VastVideoProgressBarWidget(this.getContext());
        this.mVideoProgress.setAnchorId(this.mVideoTextureView.getId());
        this.mVideoProgress.calibrateAndMakeVisible(1000, 0);
        this.addView((View)this.mVideoProgress);
        this.mMutedDrawable = Drawables.NATIVE_MUTED.createDrawable(this.getContext());
        this.mUnmutedDrawable = Drawables.NATIVE_UNMUTED.createDrawable(this.getContext());
        RelativeLayout.LayoutParams muteControlParams = new RelativeLayout.LayoutParams(this.mMuteSizePx, this.mMuteSizePx);
        muteControlParams.addRule(9);
        muteControlParams.addRule(2, this.mVideoProgress.getId());
        this.mMuteControl = new ImageView(this.getContext());
        this.mMuteControl.setLayoutParams((ViewGroup.LayoutParams)muteControlParams);
        this.mMuteControl.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.mMuteControl.setPadding(this.mPaddingPx, this.mPaddingPx, this.mPaddingPx, this.mPaddingPx);
        this.mMuteControl.setImageDrawable(this.mMutedDrawable);
        this.addView((View)this.mMuteControl);
        RelativeLayout.LayoutParams overlayParams = new RelativeLayout.LayoutParams(-1, -1);
        overlayParams.addRule(13);
        this.mOverlay = new View(this.getContext());
        this.mOverlay.setLayoutParams((ViewGroup.LayoutParams)overlayParams);
        this.mOverlay.setBackgroundColor(0);
        this.addView(this.mOverlay);
        RelativeLayout.LayoutParams playButtonParams = new RelativeLayout.LayoutParams(this.mControlSizePx, this.mControlSizePx);
        playButtonParams.addRule(13);
        this.mPlayButton = new ImageView(this.getContext());
        this.mPlayButton.setLayoutParams((ViewGroup.LayoutParams)playButtonParams);
        this.mPlayButton.setImageDrawable(Drawables.NATIVE_PLAY.createDrawable(this.getContext()));
        this.addView((View)this.mPlayButton);
        this.mIsInitialized = true;
        this.updateViewState();
    }

    public void reset() {
        this.setMode(Mode.IMAGE);
        this.setPlayButtonClickListener(null);
        this.setMuteControlClickListener(null);
        this.setVideoClickListener(null);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int measWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int measHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int curWidth = this.getMeasuredWidth();
        int curHeight = this.getMeasuredHeight();
        int finalWidth = widthMode == 0x40000000 ? measWidth : (widthMode == Integer.MIN_VALUE ? Math.min(measWidth, curWidth) : curWidth);
        int finalHeight = (int)(0.5625f * (float)finalWidth);
        if (heightMode == 0x40000000 && measHeight < finalHeight) {
            finalHeight = measHeight;
            finalWidth = (int)(1.7777778f * (float)finalHeight);
        }
        if (Math.abs(finalHeight - curHeight) >= 2 || Math.abs(finalWidth - curWidth) >= 2) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{String.format("Resetting mediaLayout size to w: %d h: %d", finalWidth, finalHeight)});
            this.getLayoutParams().width = finalWidth;
            this.getLayoutParams().height = finalHeight;
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void setMainImageDrawable(@NonNull Drawable drawable2) {
        Preconditions.checkNotNull((Object)drawable2);
        this.mMainImageView.setImageDrawable(drawable2);
    }

    public void resetProgress() {
        if (this.mVideoProgress != null) {
            this.mVideoProgress.reset();
        }
    }

    public void updateProgress(int progressTenthPercentage) {
        if (this.mVideoProgress != null) {
            this.mVideoProgress.updateProgress(progressTenthPercentage);
        }
    }

    public TextureView getTextureView() {
        return this.mVideoTextureView;
    }

    public void setMode(@NonNull Mode mode) {
        Preconditions.checkNotNull((Object)((Object)mode));
        this.mMode = mode;
        this.post(new Runnable(){

            @Override
            public void run() {
                MediaLayout.this.updateViewState();
            }
        });
    }

    @Nullable
    public ImageView getMainImageView() {
        return this.mMainImageView;
    }

    public void setMuteControlClickListener(@Nullable View.OnClickListener muteControlListener) {
        if (this.mMuteControl != null) {
            this.mMuteControl.setOnClickListener(muteControlListener);
        }
    }

    public void setPlayButtonClickListener(@Nullable View.OnClickListener playButtonListener) {
        if (this.mPlayButton != null && this.mOverlay != null) {
            this.mOverlay.setOnClickListener(playButtonListener);
            this.mPlayButton.setOnClickListener(playButtonListener);
        }
    }

    public void setVideoClickListener(@Nullable View.OnClickListener videoClickListener) {
        if (this.mVideoTextureView != null) {
            this.mVideoTextureView.setOnClickListener(videoClickListener);
        }
    }

    public void setMuteState(@NonNull MuteState muteState) {
        Preconditions.checkNotNull((Object)((Object)muteState));
        if (muteState == this.mMuteState) {
            return;
        }
        this.mMuteState = muteState;
        if (this.mMuteControl != null) {
            switch (this.mMuteState) {
                case MUTED: {
                    this.mMuteControl.setImageDrawable(this.mMutedDrawable);
                    break;
                }
                default: {
                    this.mMuteControl.setImageDrawable(this.mUnmutedDrawable);
                }
            }
        }
    }

    private void updateViewState() {
        switch (this.mMode) {
            case IMAGE: {
                this.setMainImageVisibility(0);
                this.setLoadingSpinnerVisibility(4);
                this.setVideoControlVisibility(4);
                this.setPlayButtonVisibility(4);
                break;
            }
            case LOADING: {
                this.setMainImageVisibility(0);
                this.setLoadingSpinnerVisibility(0);
                this.setVideoControlVisibility(4);
                this.setPlayButtonVisibility(4);
                break;
            }
            case BUFFERING: {
                this.setMainImageVisibility(4);
                this.setLoadingSpinnerVisibility(0);
                this.setVideoControlVisibility(0);
                this.setPlayButtonVisibility(4);
            }
            case PLAYING: {
                this.setMainImageVisibility(4);
                this.setLoadingSpinnerVisibility(4);
                this.setVideoControlVisibility(0);
                this.setPlayButtonVisibility(4);
                break;
            }
            case PAUSED: {
                this.setMainImageVisibility(4);
                this.setLoadingSpinnerVisibility(4);
                this.setVideoControlVisibility(0);
                this.setPlayButtonVisibility(0);
                break;
            }
            case FINISHED: {
                this.setMainImageVisibility(0);
                this.setLoadingSpinnerVisibility(4);
                this.setVideoControlVisibility(4);
                this.setPlayButtonVisibility(0);
                break;
            }
        }
    }

    private void setMainImageVisibility(int visibility) {
        this.mMainImageView.setVisibility(visibility);
    }

    private void setLoadingSpinnerVisibility(int visibility) {
        if (this.mLoadingSpinner != null) {
            this.mLoadingSpinner.setVisibility(visibility);
        }
        if (this.mTopGradient != null) {
            this.mTopGradient.setVisibility(visibility);
        }
    }

    private void setVideoControlVisibility(int visibility) {
        if (this.mBottomGradient != null) {
            this.mBottomGradient.setVisibility(visibility);
        }
        if (this.mVideoProgress != null) {
            this.mVideoProgress.setVisibility(visibility);
        }
        if (this.mMuteControl != null) {
            this.mMuteControl.setVisibility(visibility);
        }
    }

    private void setPlayButtonVisibility(int visibility) {
        if (this.mPlayButton != null && this.mOverlay != null) {
            this.mPlayButton.setVisibility(visibility);
            this.mOverlay.setVisibility(visibility);
        }
    }

    public static enum MuteState {
        MUTED,
        UNMUTED;

    }

    public static enum Mode {
        IMAGE,
        PLAYING,
        LOADING,
        BUFFERING,
        PAUSED,
        FINISHED;

    }
}

