/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.nativeads.MediaLayout;
import com.mopub.nativeads.MediaViewBinder;

class MediaViewHolder {
    @Nullable
    View mainView;
    @Nullable
    MediaLayout mediaLayout;
    @Nullable
    TextView titleView;
    @Nullable
    TextView textView;
    @Nullable
    ImageView iconImageView;
    @Nullable
    TextView callToActionView;
    @Nullable
    ImageView privacyInformationIconImageView;
    @Nullable
    TextView sponsoredTextView;
    @VisibleForTesting
    static final MediaViewHolder EMPTY_MEDIA_VIEW_HOLDER = new MediaViewHolder();

    private MediaViewHolder() {
    }

    @NonNull
    static MediaViewHolder fromViewBinder(@NonNull View view, @NonNull MediaViewBinder mediaViewBinder) {
        MediaViewHolder mediaViewHolder = new MediaViewHolder();
        mediaViewHolder.mainView = view;
        try {
            mediaViewHolder.titleView = (TextView)view.findViewById(mediaViewBinder.titleId);
            mediaViewHolder.textView = (TextView)view.findViewById(mediaViewBinder.textId);
            mediaViewHolder.callToActionView = (TextView)view.findViewById(mediaViewBinder.callToActionId);
            mediaViewHolder.mediaLayout = (MediaLayout)view.findViewById(mediaViewBinder.mediaLayoutId);
            mediaViewHolder.iconImageView = (ImageView)view.findViewById(mediaViewBinder.iconImageId);
            mediaViewHolder.privacyInformationIconImageView = (ImageView)view.findViewById(mediaViewBinder.privacyInformationIconImageId);
            mediaViewHolder.sponsoredTextView = (TextView)view.findViewById(mediaViewBinder.sponsoredTextId);
            return mediaViewHolder;
        }
        catch (ClassCastException exception) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"Could not cast from id in MediaViewBinder to expected View type", exception});
            return EMPTY_MEDIA_VIEW_HOLDER;
        }
    }
}

