/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.upstream.cache.CacheEvictor;
import com.google.android.exoplayer2.upstream.cache.LeastRecentlyUsedCacheEvictor;
import com.google.android.exoplayer2.upstream.cache.SimpleCache;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.util.DeviceUtils;
import java.io.File;

class MoPubCache {
    private static final String NATIVE_CACHE_NAME = "mopub-native-cache";
    private static volatile Cache sInstance = null;

    MoPubCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    static Cache getCacheInstance(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        Cache instance = sInstance;
        if (instance != null) return instance;
        Class<MoPubCache> clazz = MoPubCache.class;
        synchronized (MoPubCache.class) {
            File cacheDir;
            instance = sInstance;
            if (instance != null || (cacheDir = context.getApplicationContext().getCacheDir()) == null) return instance;
            File nativeCacheDir = new File(cacheDir.getPath() + File.separator + NATIVE_CACHE_NAME);
            long cacheSize = DeviceUtils.diskCacheSizeBytes((File)cacheDir);
            LeastRecentlyUsedCacheEvictor lruEvictor = new LeastRecentlyUsedCacheEvictor(cacheSize);
            sInstance = instance = new SimpleCache(nativeCacheDir, (CacheEvictor)lruEvictor);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    @VisibleForTesting
    static void resetInstance() {
        if (sInstance != null) {
            sInstance.release();
            sInstance = null;
        }
    }
}

