/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.AudioManager;
import android.text.TextUtils;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibilityTracker;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.MoPubCollections;
import com.mopub.common.util.Utils;
import com.mopub.mobileads.MraidVideoPlayerActivity;
import com.mopub.mobileads.VastManager;
import com.mopub.mobileads.VastTracker;
import com.mopub.mobileads.VastVideoConfig;
import com.mopub.mobileads.VideoViewabilityTracker;
import com.mopub.mobileads.factories.VastManagerFactory;
import com.mopub.nativeads.BaseNativeAd;
import com.mopub.nativeads.CustomEventNative;
import com.mopub.nativeads.MediaLayout;
import com.mopub.nativeads.NativeErrorCode;
import com.mopub.nativeads.NativeImageHelper;
import com.mopub.nativeads.NativeVideoController;
import com.mopub.nativeads.VideoNativeAd;
import com.mopub.network.TrackingRequest;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MoPubCustomEventVideoNative
extends CustomEventNative {
    public static final String ADAPTER_NAME = MoPubCustomEventVideoNative.class.getSimpleName();
    private MoPubVideoNativeAd videoNativeAd;

    protected void loadNativeAd(@NonNull Context context, @NonNull CustomEventNative.CustomEventNativeListener customEventNativeListener, @NonNull Map<String, Object> localExtras, @NonNull Map<String, String> serverExtras) {
        Object json = localExtras.get("com_mopub_native_json");
        if (!(json instanceof JSONObject)) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_FAILED, (Object[])new Object[]{ADAPTER_NAME, NativeErrorCode.INVALID_RESPONSE.getIntCode(), NativeErrorCode.INVALID_RESPONSE});
            customEventNativeListener.onNativeAdFailed(NativeErrorCode.INVALID_RESPONSE);
            return;
        }
        VideoResponseHeaders videoResponseHeaders = new VideoResponseHeaders(serverExtras);
        if (!videoResponseHeaders.hasValidHeaders()) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_FAILED, (Object[])new Object[]{ADAPTER_NAME, NativeErrorCode.INVALID_RESPONSE.getIntCode(), NativeErrorCode.INVALID_RESPONSE});
            customEventNativeListener.onNativeAdFailed(NativeErrorCode.INVALID_RESPONSE);
            return;
        }
        Object clickTrackingUrlsFromHeaderObject = localExtras.get("click-tracking-url");
        if (!(clickTrackingUrlsFromHeaderObject instanceof List) || ((List)clickTrackingUrlsFromHeaderObject).isEmpty()) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_FAILED, (Object[])new Object[]{ADAPTER_NAME, NativeErrorCode.UNSPECIFIED.getIntCode(), NativeErrorCode.UNSPECIFIED});
            customEventNativeListener.onNativeAdFailed(NativeErrorCode.UNSPECIFIED);
            return;
        }
        List clickTrackingUrlsFromHeader = (List)clickTrackingUrlsFromHeaderObject;
        this.videoNativeAd = new MoPubVideoNativeAd(context, (JSONObject)json, customEventNativeListener, videoResponseHeaders, clickTrackingUrlsFromHeader);
        try {
            this.videoNativeAd.loadAd();
        }
        catch (IllegalArgumentException e) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_FAILED, (Object[])new Object[]{ADAPTER_NAME, NativeErrorCode.UNSPECIFIED.getIntCode(), NativeErrorCode.UNSPECIFIED});
            customEventNativeListener.onNativeAdFailed(NativeErrorCode.UNSPECIFIED);
        }
    }

    protected void onInvalidate() {
        if (this.videoNativeAd == null) {
            return;
        }
        this.videoNativeAd.invalidate();
    }

    @VisibleForTesting
    static class VideoResponseHeaders {
        private boolean mHeadersAreValid;
        private int mPlayVisiblePercent;
        private int mPauseVisiblePercent;
        private int mImpressionMinVisiblePercent;
        private int mImpressionVisibleMs;
        private int mMaxBufferMs;
        private Integer mImpressionVisiblePx;
        private JSONObject mVideoTrackers;

        VideoResponseHeaders(@NonNull Map<String, String> serverExtras) {
            block10: {
                try {
                    this.mPlayVisiblePercent = Integer.parseInt(serverExtras.get("play-visible-percent"));
                    this.mPauseVisiblePercent = Integer.parseInt(serverExtras.get("pause-visible-percent"));
                    this.mImpressionVisibleMs = Integer.parseInt(serverExtras.get("impression-visible-ms"));
                    this.mMaxBufferMs = Integer.parseInt(serverExtras.get("max-buffer-ms"));
                    this.mHeadersAreValid = true;
                }
                catch (NumberFormatException e) {
                    this.mHeadersAreValid = false;
                }
                String impressionVisiblePxString = serverExtras.get("impression-min-visible-px");
                if (!TextUtils.isEmpty((CharSequence)impressionVisiblePxString)) {
                    try {
                        this.mImpressionVisiblePx = Integer.parseInt(impressionVisiblePxString);
                    }
                    catch (NumberFormatException e) {
                        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.CUSTOM, (Object[])new Object[]{"Unable to parse impression min visible px from server extras."});
                    }
                }
                try {
                    this.mImpressionMinVisiblePercent = Integer.parseInt(serverExtras.get("impression-min-visible-percent"));
                }
                catch (NumberFormatException e) {
                    MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.CUSTOM, (Object[])new Object[]{"Unable to parse impression min visible percent from server extras."});
                    if (this.mImpressionVisiblePx != null && this.mImpressionVisiblePx >= 0) break block10;
                    this.mHeadersAreValid = false;
                }
            }
            String videoTrackers = serverExtras.get("video-trackers");
            if (TextUtils.isEmpty((CharSequence)videoTrackers)) {
                return;
            }
            try {
                this.mVideoTrackers = new JSONObject(videoTrackers);
            }
            catch (JSONException e) {
                MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.CUSTOM_WITH_THROWABLE, (Object[])new Object[]{"Failed to parse video trackers to JSON: " + videoTrackers, e});
                this.mVideoTrackers = null;
            }
        }

        boolean hasValidHeaders() {
            return this.mHeadersAreValid;
        }

        int getPlayVisiblePercent() {
            return this.mPlayVisiblePercent;
        }

        int getPauseVisiblePercent() {
            return this.mPauseVisiblePercent;
        }

        int getImpressionMinVisiblePercent() {
            return this.mImpressionMinVisiblePercent;
        }

        int getImpressionVisibleMs() {
            return this.mImpressionVisibleMs;
        }

        int getMaxBufferMs() {
            return this.mMaxBufferMs;
        }

        @Nullable
        Integer getImpressionVisiblePx() {
            return this.mImpressionVisiblePx;
        }

        JSONObject getVideoTrackers() {
            return this.mVideoTrackers;
        }
    }

    @VisibleForTesting
    static class NativeVideoControllerFactory {
        NativeVideoControllerFactory() {
        }

        public NativeVideoController createForId(long id, @NonNull Context context, @NonNull List<NativeVideoController.VisibilityTrackingEvent> visibilityTrackingEvents, @NonNull VastVideoConfig vastVideoConfig) {
            return NativeVideoController.createForId(id, context, visibilityTrackingEvents, vastVideoConfig);
        }
    }

    @VisibleForTesting
    static class PayloadVisibilityStrategy
    implements NativeVideoController.VisibilityTrackingEvent.OnTrackedStrategy {
        @NonNull
        private final Context mContext;
        @NonNull
        private final String mUrl;

        PayloadVisibilityStrategy(@NonNull Context context, @NonNull String url) {
            this.mContext = context.getApplicationContext();
            this.mUrl = url;
        }

        @Override
        public void execute() {
            TrackingRequest.makeTrackingHttpRequest((String)this.mUrl, (Context)this.mContext);
        }
    }

    @VisibleForTesting
    static class HeaderVisibilityStrategy
    implements NativeVideoController.VisibilityTrackingEvent.OnTrackedStrategy {
        @NonNull
        private final WeakReference<MoPubVideoNativeAd> mMoPubVideoNativeAd;

        HeaderVisibilityStrategy(@NonNull MoPubVideoNativeAd moPubVideoNativeAd) {
            this.mMoPubVideoNativeAd = new WeakReference<MoPubVideoNativeAd>(moPubVideoNativeAd);
        }

        @Override
        public void execute() {
            MoPubVideoNativeAd moPubVideoNativeAd = (MoPubVideoNativeAd)this.mMoPubVideoNativeAd.get();
            if (moPubVideoNativeAd != null) {
                moPubVideoNativeAd.notifyAdImpressed();
            }
        }
    }

    public static class MoPubVideoNativeAd
    extends VideoNativeAd
    implements VastManager.VastManagerListener,
    NativeVideoController.NativeVideoProgressRunnable.ProgressListener,
    AudioManager.OnAudioFocusChangeListener {
        static final String PRIVACY_INFORMATION_CLICKTHROUGH_URL = "https://www.mopub.com/optout/";
        @NonNull
        private final Context mContext;
        @NonNull
        private final JSONObject mJsonObject;
        @NonNull
        private VideoState mVideoState;
        @NonNull
        private final VisibilityTracker mVideoVisibleTracking;
        @NonNull
        private final List<String> mMoPubClickTrackingUrls;
        @NonNull
        private final CustomEventNative.CustomEventNativeListener mCustomEventNativeListener;
        @NonNull
        private final VideoResponseHeaders mVideoResponseHeaders;
        @NonNull
        private final NativeVideoControllerFactory mNativeVideoControllerFactory;
        @Nullable
        private NativeVideoController mNativeVideoController;
        @NonNull
        private final VastManager mVastManager;
        @Nullable
        VastVideoConfig mVastVideoConfig;
        @Nullable
        private MediaLayout mMediaLayout;
        @Nullable
        private View mRootView;
        private final long mId;
        private boolean mNeedsSeek;
        private boolean mNeedsPrepare;
        private boolean mPauseCanBeTracked = false;
        private boolean mResumeCanBeTracked = false;
        private int mLatestVideoControllerState;
        private boolean mError;
        private boolean mLatestVisibility;
        private boolean mMuted;
        private boolean mEnded;

        public MoPubVideoNativeAd(@NonNull Context context, @NonNull JSONObject jsonObject, @NonNull CustomEventNative.CustomEventNativeListener customEventNativeListener, @NonNull VideoResponseHeaders videoResponseHeaders, @NonNull List<String> clickTrackingUrls) {
            this(context, jsonObject, customEventNativeListener, videoResponseHeaders, new VisibilityTracker(context), new NativeVideoControllerFactory(), clickTrackingUrls, VastManagerFactory.create((Context)context.getApplicationContext(), (boolean)false));
        }

        @VisibleForTesting
        MoPubVideoNativeAd(@NonNull Context context, @NonNull JSONObject jsonObject, @NonNull CustomEventNative.CustomEventNativeListener customEventNativeListener, @NonNull VideoResponseHeaders videoResponseHeaders, @NonNull VisibilityTracker visibilityTracker, @NonNull NativeVideoControllerFactory nativeVideoControllerFactory, @NonNull List<String> clickTrackingUrls, @NonNull VastManager vastManager) {
            Preconditions.checkNotNull((Object)context);
            Preconditions.checkNotNull((Object)jsonObject);
            Preconditions.checkNotNull((Object)customEventNativeListener);
            Preconditions.checkNotNull((Object)videoResponseHeaders);
            Preconditions.checkNotNull((Object)visibilityTracker);
            Preconditions.checkNotNull((Object)nativeVideoControllerFactory);
            Preconditions.checkNotNull(clickTrackingUrls);
            Preconditions.checkNotNull((Object)vastManager);
            this.mContext = context.getApplicationContext();
            this.mJsonObject = jsonObject;
            this.mCustomEventNativeListener = customEventNativeListener;
            this.mVideoResponseHeaders = videoResponseHeaders;
            this.mNativeVideoControllerFactory = nativeVideoControllerFactory;
            this.mMoPubClickTrackingUrls = clickTrackingUrls;
            this.mId = Utils.generateUniqueId();
            this.mNeedsSeek = true;
            this.mVideoState = VideoState.CREATED;
            this.mNeedsPrepare = true;
            this.mLatestVideoControllerState = 1;
            this.mMuted = true;
            this.mVideoVisibleTracking = visibilityTracker;
            this.mVideoVisibleTracking.setVisibilityTrackerListener(new VisibilityTracker.VisibilityTrackerListener(){

                public void onVisibilityChanged(List<View> visibleViews, List<View> invisibleViews) {
                    if (!visibleViews.isEmpty() && !mLatestVisibility) {
                        mLatestVisibility = true;
                        this.maybeChangeState();
                    } else if (!invisibleViews.isEmpty() && mLatestVisibility) {
                        mLatestVisibility = false;
                        this.maybeChangeState();
                    }
                }
            });
            this.mVastManager = vastManager;
        }

        void loadAd() throws IllegalArgumentException {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_ATTEMPTED, (Object[])new Object[]{ADAPTER_NAME});
            if (!this.containsRequiredKeys(this.mJsonObject)) {
                throw new IllegalArgumentException("JSONObject did not contain required keys.");
            }
            Iterator keys = this.mJsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Parameter parameter = Parameter.from(key);
                if (parameter != null) {
                    try {
                        this.addInstanceVariable(parameter, this.mJsonObject.opt(key));
                        continue;
                    }
                    catch (ClassCastException e) {
                        throw new IllegalArgumentException("JSONObject key (" + key + ") contained unexpected value.");
                    }
                }
                this.addExtra(key, this.mJsonObject.opt(key));
            }
            if (TextUtils.isEmpty((CharSequence)this.getPrivacyInformationIconClickThroughUrl())) {
                this.setPrivacyInformationIconClickThroughUrl(PRIVACY_INFORMATION_CLICKTHROUGH_URL);
            }
            NativeImageHelper.preCacheImages((Context)this.mContext, this.getAllImageUrls(), (NativeImageHelper.ImageListener)new NativeImageHelper.ImageListener(){

                public void onImagesCached() {
                    MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_SUCCESS, (Object[])new Object[]{ADAPTER_NAME});
                    if (this.isInvalidated()) {
                        return;
                    }
                    mVastManager.prepareVastVideoConfiguration(this.getVastVideo(), (VastManager.VastManagerListener)this, null, mContext);
                }

                public void onImagesFailedToCache(NativeErrorCode errorCode) {
                    if (this.isInvalidated()) {
                        return;
                    }
                    MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_FAILED, (Object[])new Object[]{ADAPTER_NAME, errorCode.getIntCode(), errorCode});
                    mCustomEventNativeListener.onNativeAdFailed(errorCode);
                }
            });
        }

        public void onVastVideoConfigurationPrepared(@Nullable VastVideoConfig vastVideoConfig) {
            if (vastVideoConfig == null) {
                MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_FAILED, (Object[])new Object[]{ADAPTER_NAME, NativeErrorCode.INVALID_RESPONSE.getIntCode(), NativeErrorCode.INVALID_RESPONSE});
                this.mCustomEventNativeListener.onNativeAdFailed(NativeErrorCode.INVALID_RESPONSE);
                return;
            }
            ArrayList<NativeVideoController.VisibilityTrackingEvent> visibilityTrackingEvents = new ArrayList<NativeVideoController.VisibilityTrackingEvent>();
            NativeVideoController.VisibilityTrackingEvent visibilityTrackingEvent = new NativeVideoController.VisibilityTrackingEvent();
            visibilityTrackingEvent.strategy = new HeaderVisibilityStrategy(this);
            visibilityTrackingEvent.minimumPercentageVisible = this.mVideoResponseHeaders.getImpressionMinVisiblePercent();
            visibilityTrackingEvent.totalRequiredPlayTimeMs = this.mVideoResponseHeaders.getImpressionVisibleMs();
            visibilityTrackingEvents.add(visibilityTrackingEvent);
            visibilityTrackingEvent.minimumVisiblePx = this.mVideoResponseHeaders.getImpressionVisiblePx();
            for (VastTracker vastTracker : vastVideoConfig.getImpressionTrackers()) {
                NativeVideoController.VisibilityTrackingEvent vastImpressionTrackingEvent = new NativeVideoController.VisibilityTrackingEvent();
                vastImpressionTrackingEvent.strategy = new PayloadVisibilityStrategy(this.mContext, vastTracker.getContent());
                vastImpressionTrackingEvent.minimumPercentageVisible = this.mVideoResponseHeaders.getImpressionMinVisiblePercent();
                vastImpressionTrackingEvent.totalRequiredPlayTimeMs = this.mVideoResponseHeaders.getImpressionVisibleMs();
                visibilityTrackingEvents.add(vastImpressionTrackingEvent);
                vastImpressionTrackingEvent.minimumVisiblePx = this.mVideoResponseHeaders.getImpressionVisiblePx();
            }
            this.mVastVideoConfig = vastVideoConfig;
            VideoViewabilityTracker vastVideoViewabilityTracker = this.mVastVideoConfig.getVideoViewabilityTracker();
            if (vastVideoViewabilityTracker != null) {
                NativeVideoController.VisibilityTrackingEvent vastVisibilityTrackingEvent = new NativeVideoController.VisibilityTrackingEvent();
                vastVisibilityTrackingEvent.strategy = new PayloadVisibilityStrategy(this.mContext, vastVideoViewabilityTracker.getContent());
                vastVisibilityTrackingEvent.minimumPercentageVisible = vastVideoViewabilityTracker.getPercentViewable();
                vastVisibilityTrackingEvent.totalRequiredPlayTimeMs = vastVideoViewabilityTracker.getViewablePlaytimeMS();
                visibilityTrackingEvents.add(vastVisibilityTrackingEvent);
            }
            this.mVastVideoConfig.setPrivacyInformationIconImageUrl(this.getPrivacyInformationIconImageUrl());
            this.mVastVideoConfig.setPrivacyInformationIconClickthroughUrl(this.getPrivacyInformationIconClickThroughUrl());
            HashSet clickTrackers = new HashSet();
            MoPubCollections.addAllNonNull(clickTrackers, this.mMoPubClickTrackingUrls);
            MoPubCollections.addAllNonNull(clickTrackers, (Collection)this.getClickTrackers());
            ArrayList<VastTracker> vastClickTrackers = new ArrayList<VastTracker>();
            for (String clickTrackingUrl : clickTrackers) {
                vastClickTrackers.add(new VastTracker.Builder(clickTrackingUrl).isRepeatable(false).build());
            }
            this.mVastVideoConfig.addClickTrackers(vastClickTrackers);
            this.mVastVideoConfig.setClickThroughUrl(this.getClickDestinationUrl());
            this.mNativeVideoController = this.mNativeVideoControllerFactory.createForId(this.mId, this.mContext, visibilityTrackingEvents, this.mVastVideoConfig);
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_SUCCESS, (Object[])new Object[]{ADAPTER_NAME});
            this.mCustomEventNativeListener.onNativeAdLoaded((BaseNativeAd)this);
            JSONObject videoTrackers = this.mVideoResponseHeaders.getVideoTrackers();
            if (videoTrackers != null) {
                this.mVastVideoConfig.addVideoTrackers(videoTrackers);
            }
        }

        private boolean containsRequiredKeys(@NonNull JSONObject jsonObject) {
            Preconditions.checkNotNull((Object)jsonObject);
            HashSet keys = new HashSet();
            Iterator jsonKeys = jsonObject.keys();
            while (jsonKeys.hasNext()) {
                keys.add(jsonKeys.next());
            }
            return keys.containsAll(Parameter.requiredKeys);
        }

        private void addInstanceVariable(@NonNull Parameter key, @Nullable Object value) throws ClassCastException {
            Preconditions.checkNotNull((Object)((Object)key));
            Preconditions.checkNotNull((Object)value);
            try {
                switch (key) {
                    case IMPRESSION_TRACKER: {
                        this.addImpressionTrackers(value);
                        break;
                    }
                    case TITLE: {
                        this.setTitle((String)value);
                        break;
                    }
                    case TEXT: {
                        this.setText((String)value);
                        break;
                    }
                    case IMAGE_URL: {
                        this.setMainImageUrl((String)value);
                        break;
                    }
                    case ICON_URL: {
                        this.setIconImageUrl((String)value);
                        break;
                    }
                    case CLICK_DESTINATION: {
                        this.setClickDestinationUrl((String)value);
                        break;
                    }
                    case CLICK_TRACKER: {
                        this.parseClickTrackers(value);
                        break;
                    }
                    case CALL_TO_ACTION: {
                        this.setCallToAction((String)value);
                        break;
                    }
                    case VAST_VIDEO: {
                        this.setVastVideo((String)value);
                        break;
                    }
                    case PRIVACY_INFORMATION_ICON_IMAGE_URL: {
                        this.setPrivacyInformationIconImageUrl((String)value);
                        break;
                    }
                    case PRIVACY_INFORMATION_ICON_CLICKTHROUGH_URL: {
                        this.setPrivacyInformationIconClickThroughUrl((String)value);
                        break;
                    }
                    case SPONSORED: {
                        this.setSponsored((String)value);
                    }
                    default: {
                        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.CUSTOM, (Object[])new Object[]{"Unable to add JSON key to internal mapping: " + key.mName});
                        break;
                    }
                }
            }
            catch (ClassCastException e) {
                if (!key.mRequired) {
                    MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.CUSTOM, (Object[])new Object[]{"Ignoring class cast exception for optional key: " + key.mName});
                }
                throw e;
            }
        }

        private void parseClickTrackers(@NonNull Object clickTrackers) {
            if (clickTrackers instanceof JSONArray) {
                this.addClickTrackers(clickTrackers);
            } else {
                this.addClickTracker((String)clickTrackers);
            }
        }

        @Override
        public void render(@NonNull MediaLayout mediaLayout) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.SHOW_ATTEMPTED, (Object[])new Object[]{ADAPTER_NAME});
            Preconditions.checkNotNull((Object)((Object)mediaLayout));
            this.mVideoVisibleTracking.addView(this.mRootView, (View)mediaLayout, this.mVideoResponseHeaders.getPlayVisiblePercent(), this.mVideoResponseHeaders.getPauseVisiblePercent(), this.mVideoResponseHeaders.getImpressionVisiblePx());
            this.mMediaLayout = mediaLayout;
            this.mMediaLayout.initForVideo();
            this.mMediaLayout.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

                public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
                    mNativeVideoController.setListener(this);
                    mNativeVideoController.setOnAudioFocusChangeListener(this);
                    mNativeVideoController.setProgressListener(this);
                    mNativeVideoController.setTextureView(mMediaLayout.getTextureView());
                    mMediaLayout.resetProgress();
                    long duration = mNativeVideoController.getDuration();
                    long currentPosition = mNativeVideoController.getCurrentPosition();
                    if (mLatestVideoControllerState == 4 || duration > 0L && duration - currentPosition < 750L) {
                        mEnded = true;
                    }
                    if (mNeedsPrepare) {
                        mNeedsPrepare = false;
                        mNativeVideoController.prepare(this);
                    }
                    mNeedsSeek = true;
                    this.maybeChangeState();
                    if (mVideoState == VideoState.PLAYING || mVideoState == VideoState.PLAYING_MUTED) {
                        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.SHOW_SUCCESS, (Object[])new Object[]{ADAPTER_NAME});
                    }
                }

                public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
                }

                public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                    mNeedsPrepare = true;
                    mNativeVideoController.release(this);
                    this.applyState(VideoState.PAUSED);
                    return true;
                }

                public void onSurfaceTextureUpdated(SurfaceTexture surface) {
                }
            });
            this.mMediaLayout.setPlayButtonClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    mMediaLayout.resetProgress();
                    mNativeVideoController.seekTo(0L);
                    mEnded = false;
                    mNeedsSeek = false;
                }
            });
            this.mMediaLayout.setMuteControlClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    mMuted = !mMuted;
                    this.maybeChangeState();
                }
            });
            this.mMediaLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.CLICKED, (Object[])new Object[]{ADAPTER_NAME});
                    this.prepareToLeaveView();
                    mNativeVideoController.triggerImpressionTrackers();
                    MraidVideoPlayerActivity.startNativeVideo((Context)mContext, (long)mId, (VastVideoConfig)mVastVideoConfig);
                }
            });
            if (this.mNativeVideoController.getPlaybackState() == 5) {
                this.mNativeVideoController.prepare(this);
            }
            this.applyState(VideoState.PAUSED);
        }

        @Override
        public void prepare(@NonNull View view) {
            Preconditions.checkNotNull((Object)view);
            this.mRootView = view;
            this.mRootView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    this.prepareToLeaveView();
                    mNativeVideoController.triggerImpressionTrackers();
                    mNativeVideoController.handleCtaClick(mContext);
                }
            });
        }

        @Override
        public void clear(@NonNull View view) {
            Preconditions.checkNotNull((Object)view);
            this.mNativeVideoController.clear();
            this.cleanUpMediaLayout();
        }

        @Override
        public void destroy() {
            this.invalidate();
            this.cleanUpMediaLayout();
            this.mNativeVideoController.setPlayWhenReady(false);
            this.mNativeVideoController.release(this);
            NativeVideoController.remove(this.mId);
            this.mVideoVisibleTracking.destroy();
        }

        @Override
        public void onStateChanged(boolean playWhenReady, int playbackState) {
            this.mLatestVideoControllerState = playbackState;
            this.maybeChangeState();
        }

        @Override
        public void onError(Exception e) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.SHOW_FAILED, (Object[])new Object[]{ADAPTER_NAME, NativeErrorCode.UNSPECIFIED.getIntCode(), NativeErrorCode.UNSPECIFIED});
            this.mError = true;
            this.maybeChangeState();
        }

        @Override
        public void updateProgress(int progressTenthPercent) {
            this.mMediaLayout.updateProgress(progressTenthPercent);
        }

        public void onAudioFocusChange(int focusChange) {
            if (focusChange == -1 || focusChange == -2) {
                this.mMuted = true;
                this.maybeChangeState();
            } else if (focusChange == -3) {
                this.mNativeVideoController.setAudioVolume(0.3f);
            } else if (focusChange == 1) {
                this.mNativeVideoController.setAudioVolume(1.0f);
                this.maybeChangeState();
            }
        }

        private void cleanUpMediaLayout() {
            if (this.mMediaLayout != null) {
                this.mMediaLayout.setMode(MediaLayout.Mode.IMAGE);
                this.mMediaLayout.setSurfaceTextureListener(null);
                this.mMediaLayout.setPlayButtonClickListener(null);
                this.mMediaLayout.setMuteControlClickListener(null);
                this.mMediaLayout.setOnClickListener(null);
                this.mVideoVisibleTracking.removeView((View)this.mMediaLayout);
                this.mMediaLayout = null;
            }
        }

        private void prepareToLeaveView() {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.WILL_LEAVE_APPLICATION, (Object[])new Object[]{ADAPTER_NAME});
            this.mNeedsSeek = true;
            this.mNeedsPrepare = true;
            this.mNativeVideoController.setListener(null);
            this.mNativeVideoController.setOnAudioFocusChangeListener(null);
            this.mNativeVideoController.setProgressListener(null);
            this.mNativeVideoController.clear();
            this.applyState(VideoState.PAUSED, true);
        }

        private void maybeChangeState() {
            VideoState newState = this.mVideoState;
            if (this.mError) {
                newState = VideoState.FAILED_LOAD;
            } else if (this.mEnded) {
                newState = VideoState.ENDED;
            } else if (this.mLatestVideoControllerState == 1) {
                newState = VideoState.LOADING;
            } else if (this.mLatestVideoControllerState == 2) {
                newState = VideoState.BUFFERING;
            } else if (this.mLatestVideoControllerState == 4) {
                this.mEnded = true;
                newState = VideoState.ENDED;
            } else if (this.mLatestVideoControllerState == 3) {
                newState = this.mLatestVisibility ? (this.mMuted ? VideoState.PLAYING_MUTED : VideoState.PLAYING) : VideoState.PAUSED;
            }
            this.applyState(newState);
        }

        @VisibleForTesting
        void applyState(@NonNull VideoState videoState) {
            this.applyState(videoState, false);
        }

        @VisibleForTesting
        void applyState(@NonNull VideoState videoState, boolean transitionToFullScreen) {
            Preconditions.checkNotNull((Object)((Object)videoState));
            if (this.mVastVideoConfig == null || this.mNativeVideoController == null || this.mMediaLayout == null) {
                return;
            }
            if (this.mVideoState == videoState) {
                return;
            }
            VideoState previousState = this.mVideoState;
            this.mVideoState = videoState;
            switch (videoState) {
                case FAILED_LOAD: {
                    this.mVastVideoConfig.handleError(this.mContext, null, 0);
                    this.mNativeVideoController.setAppAudioEnabled(false);
                    this.mMediaLayout.setMode(MediaLayout.Mode.IMAGE);
                    break;
                }
                case CREATED: 
                case LOADING: {
                    this.mNativeVideoController.setPlayWhenReady(true);
                    this.mMediaLayout.setMode(MediaLayout.Mode.LOADING);
                    break;
                }
                case BUFFERING: {
                    this.mNativeVideoController.setPlayWhenReady(true);
                    this.mMediaLayout.setMode(MediaLayout.Mode.BUFFERING);
                    break;
                }
                case PAUSED: {
                    if (transitionToFullScreen) {
                        this.mResumeCanBeTracked = false;
                    }
                    if (!transitionToFullScreen) {
                        this.mNativeVideoController.setAppAudioEnabled(false);
                        if (this.mPauseCanBeTracked) {
                            TrackingRequest.makeVastTrackingHttpRequest((List)this.mVastVideoConfig.getPauseTrackers(), null, (Integer)((int)this.mNativeVideoController.getCurrentPosition()), null, (Context)this.mContext);
                            this.mPauseCanBeTracked = false;
                            this.mResumeCanBeTracked = true;
                        }
                    }
                    this.mNativeVideoController.setPlayWhenReady(false);
                    this.mMediaLayout.setMode(MediaLayout.Mode.PAUSED);
                    break;
                }
                case PLAYING: {
                    this.handleResumeTrackersAndSeek(previousState);
                    this.mNativeVideoController.setPlayWhenReady(true);
                    this.mNativeVideoController.setAudioEnabled(true);
                    this.mNativeVideoController.setAppAudioEnabled(true);
                    this.mMediaLayout.setMode(MediaLayout.Mode.PLAYING);
                    this.mMediaLayout.setMuteState(MediaLayout.MuteState.UNMUTED);
                    break;
                }
                case PLAYING_MUTED: {
                    this.handleResumeTrackersAndSeek(previousState);
                    this.mNativeVideoController.setPlayWhenReady(true);
                    this.mNativeVideoController.setAudioEnabled(false);
                    this.mNativeVideoController.setAppAudioEnabled(false);
                    this.mMediaLayout.setMode(MediaLayout.Mode.PLAYING);
                    this.mMediaLayout.setMuteState(MediaLayout.MuteState.MUTED);
                    break;
                }
                case ENDED: {
                    if (this.mNativeVideoController.hasFinalFrame()) {
                        this.mMediaLayout.setMainImageDrawable(this.mNativeVideoController.getFinalFrame());
                    }
                    this.mPauseCanBeTracked = false;
                    this.mResumeCanBeTracked = false;
                    this.mVastVideoConfig.handleComplete(this.mContext, 0);
                    this.mNativeVideoController.setAppAudioEnabled(false);
                    this.mMediaLayout.setMode(MediaLayout.Mode.FINISHED);
                    this.mMediaLayout.updateProgress(1000);
                }
            }
        }

        private void handleResumeTrackersAndSeek(VideoState previousState) {
            if (this.mResumeCanBeTracked && previousState != VideoState.PLAYING && previousState != VideoState.PLAYING_MUTED) {
                TrackingRequest.makeVastTrackingHttpRequest((List)this.mVastVideoConfig.getResumeTrackers(), null, (Integer)((int)this.mNativeVideoController.getCurrentPosition()), null, (Context)this.mContext);
                this.mResumeCanBeTracked = false;
            }
            this.mPauseCanBeTracked = true;
            if (this.mNeedsSeek) {
                this.mNeedsSeek = false;
                this.mNativeVideoController.seekTo(this.mNativeVideoController.getCurrentPosition());
            }
        }

        private boolean isImageKey(@Nullable String name) {
            return name != null && name.toLowerCase(Locale.US).endsWith("image");
        }

        @NonNull
        private List<String> getExtrasImageUrls() {
            ArrayList<String> extrasBitmapUrls = new ArrayList<String>(this.getExtras().size());
            for (Map.Entry<String, Object> entry : this.getExtras().entrySet()) {
                if (!this.isImageKey(entry.getKey()) || !(entry.getValue() instanceof String)) continue;
                extrasBitmapUrls.add((String)entry.getValue());
            }
            return extrasBitmapUrls;
        }

        @NonNull
        private List<String> getAllImageUrls() {
            ArrayList<String> imageUrls = new ArrayList<String>();
            if (!TextUtils.isEmpty((CharSequence)this.getMainImageUrl())) {
                imageUrls.add(this.getMainImageUrl());
            }
            if (!TextUtils.isEmpty((CharSequence)this.getIconImageUrl())) {
                imageUrls.add(this.getIconImageUrl());
            }
            if (!TextUtils.isEmpty((CharSequence)this.getPrivacyInformationIconImageUrl())) {
                imageUrls.add(this.getPrivacyInformationIconImageUrl());
            }
            imageUrls.addAll(this.getExtrasImageUrls());
            return imageUrls;
        }

        @Deprecated
        @VisibleForTesting
        boolean needsPrepare() {
            return this.mNeedsPrepare;
        }

        @Deprecated
        @VisibleForTesting
        boolean hasEnded() {
            return this.mEnded;
        }

        @Deprecated
        @VisibleForTesting
        boolean needsSeek() {
            return this.mNeedsSeek;
        }

        @Deprecated
        @VisibleForTesting
        boolean isMuted() {
            return this.mMuted;
        }

        @Deprecated
        @VisibleForTesting
        long getId() {
            return this.mId;
        }

        @Deprecated
        @VisibleForTesting
        VideoState getVideoState() {
            return this.mVideoState;
        }

        @Deprecated
        @VisibleForTesting
        void setLatestVisibility(boolean latestVisibility) {
            this.mLatestVisibility = latestVisibility;
        }

        @Deprecated
        @VisibleForTesting
        void setMuted(boolean muted) {
            this.mMuted = muted;
        }

        @Deprecated
        @VisibleForTesting
        MediaLayout getMediaLayout() {
            return this.mMediaLayout;
        }

        public static enum VideoState {
            CREATED,
            LOADING,
            BUFFERING,
            PAUSED,
            PLAYING,
            PLAYING_MUTED,
            ENDED,
            FAILED_LOAD;

        }

        static enum Parameter {
            IMPRESSION_TRACKER("imptracker", true),
            CLICK_TRACKER("clktracker", true),
            TITLE("title", false),
            TEXT("text", false),
            IMAGE_URL("mainimage", false),
            ICON_URL("iconimage", false),
            CLICK_DESTINATION("clk", false),
            FALLBACK("fallback", false),
            CALL_TO_ACTION("ctatext", false),
            VAST_VIDEO("video", false),
            PRIVACY_INFORMATION_ICON_IMAGE_URL("privacyicon", false),
            PRIVACY_INFORMATION_ICON_CLICKTHROUGH_URL("privacyclkurl", false),
            SPONSORED("sponsored", false);

            @NonNull
            final String mName;
            final boolean mRequired;
            @NonNull
            @VisibleForTesting
            static final Set<String> requiredKeys;

            private Parameter(String name, boolean required) {
                Preconditions.checkNotNull((Object)name);
                this.mName = name;
                this.mRequired = required;
            }

            @Nullable
            static Parameter from(@NonNull String name) {
                Preconditions.checkNotNull((Object)name);
                for (Parameter parameter : Parameter.values()) {
                    if (!parameter.mName.equals(name)) continue;
                    return parameter;
                }
                return null;
            }

            static {
                requiredKeys = new HashSet<String>();
                for (Parameter parameter : Parameter.values()) {
                    if (!parameter.mRequired) continue;
                    requiredKeys.add(parameter.mName);
                }
            }
        }
    }
}

