/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.nativeads.BaseNativeAd;
import com.mopub.nativeads.MediaLayout;
import com.mopub.nativeads.MediaViewBinder;
import com.mopub.nativeads.MediaViewHolder;
import com.mopub.nativeads.MoPubAdRenderer;
import com.mopub.nativeads.NativeImageHelper;
import com.mopub.nativeads.NativeRendererHelper;
import com.mopub.nativeads.VideoNativeAd;
import java.util.WeakHashMap;

public class MoPubVideoNativeAdRenderer
implements MoPubAdRenderer<VideoNativeAd> {
    @NonNull
    private final MediaViewBinder mMediaViewBinder;
    @VisibleForTesting
    @NonNull
    final WeakHashMap<View, MediaViewHolder> mMediaViewHolderMap;

    public MoPubVideoNativeAdRenderer(@NonNull MediaViewBinder mediaViewBinder) {
        this.mMediaViewBinder = mediaViewBinder;
        this.mMediaViewHolderMap = new WeakHashMap();
    }

    @NonNull
    public View createAdView(@NonNull Context context, @Nullable ViewGroup parent) {
        return LayoutInflater.from((Context)context).inflate(this.mMediaViewBinder.layoutId, parent, false);
    }

    public void renderAdView(@NonNull View view, @NonNull VideoNativeAd videoNativeAd) {
        MediaViewHolder mediaViewHolder = this.mMediaViewHolderMap.get(view);
        if (mediaViewHolder == null) {
            mediaViewHolder = MediaViewHolder.fromViewBinder(view, this.mMediaViewBinder);
            this.mMediaViewHolderMap.put(view, mediaViewHolder);
        }
        this.update(mediaViewHolder, videoNativeAd);
        NativeRendererHelper.updateExtras((View)mediaViewHolder.mainView, this.mMediaViewBinder.extras, videoNativeAd.getExtras());
        this.setViewVisibility(mediaViewHolder, 0);
        MediaLayout mediaLayout = (MediaLayout)view.findViewById(this.mMediaViewBinder.mediaLayoutId);
        videoNativeAd.render(mediaLayout);
    }

    public boolean supports(@NonNull BaseNativeAd nativeAd) {
        Preconditions.checkNotNull((Object)nativeAd);
        return nativeAd instanceof VideoNativeAd;
    }

    private void update(@NonNull MediaViewHolder mediaViewHolder, @NonNull VideoNativeAd videoNativeAd) {
        NativeRendererHelper.addTextView((TextView)mediaViewHolder.titleView, (String)videoNativeAd.getTitle());
        NativeRendererHelper.addTextView((TextView)mediaViewHolder.textView, (String)videoNativeAd.getText());
        NativeRendererHelper.addCtaButton((TextView)mediaViewHolder.callToActionView, (View)mediaViewHolder.mainView, (String)videoNativeAd.getCallToAction());
        if (mediaViewHolder.mediaLayout != null) {
            NativeImageHelper.loadImageView((String)videoNativeAd.getMainImageUrl(), (ImageView)mediaViewHolder.mediaLayout.getMainImageView());
        }
        NativeImageHelper.loadImageView((String)videoNativeAd.getIconImageUrl(), (ImageView)mediaViewHolder.iconImageView);
        NativeRendererHelper.addPrivacyInformationIcon((ImageView)mediaViewHolder.privacyInformationIconImageView, (String)videoNativeAd.getPrivacyInformationIconImageUrl(), (String)videoNativeAd.getPrivacyInformationIconClickThroughUrl());
        NativeRendererHelper.addSponsoredView((String)videoNativeAd.getSponsored(), (TextView)mediaViewHolder.sponsoredTextView);
    }

    private void setViewVisibility(@NonNull MediaViewHolder mediaViewHolder, int visibility) {
        if (mediaViewHolder.mainView != null) {
            mediaViewHolder.mainView.setVisibility(visibility);
        }
    }
}

