/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.nativeads;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.TextUtils;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.util.Dips;
import com.mopub.common.util.Drawables;
import com.mopub.mobileads.VastVideoProgressBarWidget;
import com.mopub.mobileads.native_video.R;
import com.mopub.mobileads.resource.CtaButtonDrawable;
import com.mopub.mobileads.resource.DrawableConstants;
import com.mopub.nativeads.NativeImageHelper;

public class NativeFullScreenVideoView
extends RelativeLayout {
    @VisibleForTesting
    @NonNull
    Mode mMode;
    private int mOrientation;
    @NonNull
    private final ImageView mCachedVideoFrameView;
    @NonNull
    private final TextureView mVideoTexture;
    @NonNull
    private final ProgressBar mLoadingSpinner;
    @NonNull
    private final ImageView mBottomGradient;
    @NonNull
    private final ImageView mTopGradient;
    @NonNull
    private final VastVideoProgressBarWidget mVideoProgress;
    @NonNull
    private final View mOverlay;
    @NonNull
    private final ImageView mPlayButton;
    @NonNull
    private final ImageView mPrivacyInformationIcon;
    @NonNull
    private final ImageView mCtaButton;
    @NonNull
    private final ImageView mCloseControl;
    @VisibleForTesting
    final int mCtaWidthPx;
    @VisibleForTesting
    final int mCtaHeightPx;
    @VisibleForTesting
    final int mCtaMarginPx;
    @VisibleForTesting
    final int mCloseControlSizePx;
    @VisibleForTesting
    final int mClosePaddingPx;
    @VisibleForTesting
    final int mPrivacyInformationIconSizePx;
    @VisibleForTesting
    final int mPlayControlSizePx;
    @VisibleForTesting
    final int mGradientStripHeightPx;

    public NativeFullScreenVideoView(@NonNull Context context, int orientation, @Nullable String ctaText) {
        this(context, orientation, ctaText, new ImageView(context), new TextureView(context), new ProgressBar(context), new ImageView(context), new ImageView(context), new VastVideoProgressBarWidget(context), new View(context), new ImageView(context), new ImageView(context), new ImageView(context), new ImageView(context));
    }

    @VisibleForTesting
    NativeFullScreenVideoView(@NonNull Context context, int orientation, @Nullable String ctaText, @NonNull ImageView cachedImageView, @NonNull TextureView videoTexture, @NonNull ProgressBar loadingSpinner, @NonNull ImageView bottomGradient, @NonNull ImageView topGradient, @NonNull VastVideoProgressBarWidget videoProgress, @NonNull View overlay, @NonNull ImageView playButton, @NonNull ImageView privacyInformationIcon, @NonNull ImageView ctaButton, @NonNull ImageView closeControl) {
        super(context);
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)cachedImageView);
        Preconditions.checkNotNull((Object)videoTexture);
        Preconditions.checkNotNull((Object)loadingSpinner);
        Preconditions.checkNotNull((Object)bottomGradient);
        Preconditions.checkNotNull((Object)topGradient);
        Preconditions.checkNotNull((Object)videoProgress);
        Preconditions.checkNotNull((Object)overlay);
        Preconditions.checkNotNull((Object)playButton);
        Preconditions.checkNotNull((Object)privacyInformationIcon);
        Preconditions.checkNotNull((Object)ctaButton);
        Preconditions.checkNotNull((Object)closeControl);
        this.mOrientation = orientation;
        this.mMode = Mode.LOADING;
        this.mCtaWidthPx = Dips.asIntPixels((float)200.0f, (Context)context);
        this.mCtaHeightPx = Dips.asIntPixels((float)42.0f, (Context)context);
        this.mCtaMarginPx = Dips.asIntPixels((float)10.0f, (Context)context);
        this.mCloseControlSizePx = Dips.asIntPixels((float)56.0f, (Context)context);
        this.mClosePaddingPx = Dips.asIntPixels((float)6.0f, (Context)context);
        this.mPrivacyInformationIconSizePx = Dips.asIntPixels((float)44.0f, (Context)context);
        this.mPlayControlSizePx = Dips.asIntPixels((float)50.0f, (Context)context);
        this.mGradientStripHeightPx = Dips.asIntPixels((float)45.0f, (Context)context);
        RelativeLayout.LayoutParams videoTextureLayoutParams = new RelativeLayout.LayoutParams(-1, -1);
        videoTextureLayoutParams.addRule(13);
        this.mVideoTexture = videoTexture;
        this.mVideoTexture.setId(View.generateViewId());
        this.mVideoTexture.setLayoutParams((ViewGroup.LayoutParams)videoTextureLayoutParams);
        this.addView((View)this.mVideoTexture);
        this.mCachedVideoFrameView = cachedImageView;
        this.mCachedVideoFrameView.setId(View.generateViewId());
        this.mCachedVideoFrameView.setLayoutParams((ViewGroup.LayoutParams)videoTextureLayoutParams);
        this.mCachedVideoFrameView.setBackgroundColor(0);
        this.addView((View)this.mCachedVideoFrameView);
        RelativeLayout.LayoutParams spinnerParams = new RelativeLayout.LayoutParams(this.mPlayControlSizePx, this.mPlayControlSizePx);
        spinnerParams.addRule(13);
        this.mLoadingSpinner = loadingSpinner;
        this.mLoadingSpinner.setId(View.generateViewId());
        this.mLoadingSpinner.setBackground((Drawable)new LoadingBackground(context));
        this.mLoadingSpinner.setLayoutParams((ViewGroup.LayoutParams)spinnerParams);
        this.mLoadingSpinner.setIndeterminate(true);
        this.addView((View)this.mLoadingSpinner);
        RelativeLayout.LayoutParams bottomGradientParams = new RelativeLayout.LayoutParams(-1, this.mGradientStripHeightPx);
        bottomGradientParams.addRule(8, this.mVideoTexture.getId());
        this.mBottomGradient = bottomGradient;
        this.mBottomGradient.setId(View.generateViewId());
        this.mBottomGradient.setLayoutParams((ViewGroup.LayoutParams)bottomGradientParams);
        GradientDrawable bottomGradientDrawable = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{DrawableConstants.GradientStrip.START_COLOR, DrawableConstants.GradientStrip.END_COLOR});
        this.mBottomGradient.setImageDrawable((Drawable)bottomGradientDrawable);
        this.addView((View)this.mBottomGradient);
        RelativeLayout.LayoutParams topGradientParams = new RelativeLayout.LayoutParams(-1, this.mGradientStripHeightPx);
        topGradientParams.addRule(10);
        this.mTopGradient = topGradient;
        this.mTopGradient.setId(View.generateViewId());
        this.mTopGradient.setLayoutParams((ViewGroup.LayoutParams)topGradientParams);
        GradientDrawable topGradientDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{DrawableConstants.GradientStrip.START_COLOR, DrawableConstants.GradientStrip.END_COLOR});
        this.mTopGradient.setImageDrawable((Drawable)topGradientDrawable);
        this.addView((View)this.mTopGradient);
        this.mVideoProgress = videoProgress;
        this.mVideoProgress.setId(View.generateViewId());
        this.mVideoProgress.setAnchorId(this.mVideoTexture.getId());
        this.mVideoProgress.calibrateAndMakeVisible(1000, 0);
        this.addView((View)this.mVideoProgress);
        RelativeLayout.LayoutParams overlayParams = new RelativeLayout.LayoutParams(-1, -1);
        overlayParams.addRule(13);
        this.mOverlay = overlay;
        this.mOverlay.setId(View.generateViewId());
        this.mOverlay.setLayoutParams((ViewGroup.LayoutParams)overlayParams);
        this.mOverlay.setBackgroundColor(-2013265920);
        this.addView(this.mOverlay);
        RelativeLayout.LayoutParams playButtonParams = new RelativeLayout.LayoutParams(this.mPlayControlSizePx, this.mPlayControlSizePx);
        playButtonParams.addRule(13);
        this.mPlayButton = playButton;
        this.mPlayButton.setId(View.generateViewId());
        this.mPlayButton.setLayoutParams((ViewGroup.LayoutParams)playButtonParams);
        this.mPlayButton.setImageDrawable(Drawables.NATIVE_PLAY.createDrawable(context));
        this.addView((View)this.mPlayButton);
        this.mPrivacyInformationIcon = privacyInformationIcon;
        this.mPrivacyInformationIcon.setId(View.generateViewId());
        this.mPrivacyInformationIcon.setPadding(this.mClosePaddingPx, this.mClosePaddingPx, this.mClosePaddingPx * 2, this.mClosePaddingPx * 2);
        this.addView((View)this.mPrivacyInformationIcon);
        CtaButtonDrawable ctaDrawable = new CtaButtonDrawable(context);
        if (!TextUtils.isEmpty((CharSequence)ctaText)) {
            ctaDrawable.setCtaText(ctaText);
        }
        this.mCtaButton = ctaButton;
        this.mCtaButton.setId(View.generateViewId());
        this.mCtaButton.setImageDrawable((Drawable)ctaDrawable);
        this.addView((View)this.mCtaButton);
        this.mCloseControl = closeControl;
        this.mCloseControl.setId(View.generateViewId());
        this.mCloseControl.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_mopub_close_button));
        this.mCloseControl.setPadding(this.mClosePaddingPx * 3, this.mClosePaddingPx, this.mClosePaddingPx, this.mClosePaddingPx * 3);
        this.addView((View)this.mCloseControl);
        this.updateViewState();
    }

    public void resetProgress() {
        this.mVideoProgress.reset();
    }

    public void setMode(@NonNull Mode mode) {
        Preconditions.checkNotNull((Object)((Object)mode));
        if (this.mMode == mode) {
            return;
        }
        this.mMode = mode;
        this.updateViewState();
    }

    @NonNull
    public TextureView getTextureView() {
        return this.mVideoTexture;
    }

    public void setOrientation(int orientation) {
        if (this.mOrientation == orientation) {
            return;
        }
        this.mOrientation = orientation;
        this.updateViewState();
    }

    public void setSurfaceTextureListener(@Nullable TextureView.SurfaceTextureListener surfaceTextureListener) {
        this.mVideoTexture.setSurfaceTextureListener(surfaceTextureListener);
        SurfaceTexture surfaceTexture = this.mVideoTexture.getSurfaceTexture();
        if (surfaceTexture != null && surfaceTextureListener != null) {
            surfaceTextureListener.onSurfaceTextureAvailable(surfaceTexture, this.mVideoTexture.getWidth(), this.mVideoTexture.getHeight());
        }
    }

    public void setCloseControlListener(@Nullable View.OnClickListener closeControlListener) {
        this.mCloseControl.setOnClickListener(closeControlListener);
    }

    public void setPrivacyInformationClickListener(@Nullable View.OnClickListener privacyInformationListener) {
        this.mPrivacyInformationIcon.setOnClickListener(privacyInformationListener);
    }

    public void setPrivacyInformationIconImageUrl(@Nullable String privacyInformationIconImageUrl) {
        if (TextUtils.isEmpty((CharSequence)privacyInformationIconImageUrl)) {
            this.mPrivacyInformationIcon.setImageDrawable(Drawables.NATIVE_PRIVACY_INFORMATION_ICON.createDrawable(this.mPrivacyInformationIcon.getContext()));
        } else {
            NativeImageHelper.loadImageView((String)privacyInformationIconImageUrl, (ImageView)this.mPrivacyInformationIcon);
        }
    }

    public void setCtaClickListener(@Nullable View.OnClickListener ctaListener) {
        this.mCtaButton.setOnClickListener(ctaListener);
    }

    public void setPlayControlClickListener(@Nullable View.OnClickListener playControlListener) {
        this.mPlayButton.setOnClickListener(playControlListener);
        this.mOverlay.setOnClickListener(playControlListener);
    }

    public void updateProgress(int progressPercentage) {
        this.mVideoProgress.updateProgress(progressPercentage);
    }

    public void setCachedVideoFrame(@Nullable Bitmap cachedVideoFrame) {
        this.mCachedVideoFrameView.setImageBitmap(cachedVideoFrame);
    }

    private void updateViewState() {
        switch (this.mMode) {
            case LOADING: {
                this.setCachedImageVisibility(0);
                this.setLoadingSpinnerVisibility(0);
                this.setVideoProgressVisibility(4);
                this.setPlayButtonVisibility(4);
                break;
            }
            case PLAYING: {
                this.setCachedImageVisibility(4);
                this.setLoadingSpinnerVisibility(4);
                this.setVideoProgressVisibility(0);
                this.setPlayButtonVisibility(4);
                break;
            }
            case PAUSED: {
                this.setCachedImageVisibility(4);
                this.setLoadingSpinnerVisibility(4);
                this.setVideoProgressVisibility(0);
                this.setPlayButtonVisibility(0);
                break;
            }
            case FINISHED: {
                this.setCachedImageVisibility(0);
                this.setLoadingSpinnerVisibility(4);
                this.setVideoProgressVisibility(4);
                this.setPlayButtonVisibility(0);
                break;
            }
        }
        this.updateVideoTextureLayout();
        this.updateControlLayouts();
    }

    private void setCachedImageVisibility(int visibility) {
        this.mCachedVideoFrameView.setVisibility(visibility);
    }

    private void setLoadingSpinnerVisibility(int visibility) {
        this.mLoadingSpinner.setVisibility(visibility);
    }

    private void setVideoProgressVisibility(int visibility) {
        this.mVideoProgress.setVisibility(visibility);
    }

    private void setPlayButtonVisibility(int visibility) {
        this.mPlayButton.setVisibility(visibility);
        this.mOverlay.setVisibility(visibility);
    }

    private void updateVideoTextureLayout() {
        int newHeight;
        Configuration configuration = this.getContext().getResources().getConfiguration();
        ViewGroup.LayoutParams layoutParams = this.mVideoTexture.getLayoutParams();
        int newWidth = Dips.dipsToIntPixels((float)configuration.screenWidthDp, (Context)this.getContext());
        if (newWidth != layoutParams.width) {
            layoutParams.width = newWidth;
        }
        if ((newHeight = Dips.dipsToIntPixels((float)((float)configuration.screenWidthDp * 9.0f / 16.0f), (Context)this.getContext())) != layoutParams.height) {
            layoutParams.height = newHeight;
        }
    }

    private void updateControlLayouts() {
        RelativeLayout.LayoutParams ctaParams = new RelativeLayout.LayoutParams(this.mCtaWidthPx, this.mCtaHeightPx);
        ctaParams.setMargins(this.mCtaMarginPx, this.mCtaMarginPx, this.mCtaMarginPx, this.mCtaMarginPx);
        RelativeLayout.LayoutParams privacyInformationIconParams = new RelativeLayout.LayoutParams(this.mPrivacyInformationIconSizePx, this.mPrivacyInformationIconSizePx);
        RelativeLayout.LayoutParams closeParams = new RelativeLayout.LayoutParams(this.mCloseControlSizePx, this.mCloseControlSizePx);
        switch (this.mOrientation) {
            case 1: {
                ctaParams.addRule(3, this.mVideoTexture.getId());
                ctaParams.addRule(14);
                privacyInformationIconParams.addRule(10);
                privacyInformationIconParams.addRule(9);
                closeParams.addRule(10);
                closeParams.addRule(11);
                break;
            }
            case 2: {
                ctaParams.addRule(2, this.mVideoProgress.getId());
                ctaParams.addRule(11);
                privacyInformationIconParams.addRule(6, this.mVideoTexture.getId());
                privacyInformationIconParams.addRule(5, this.mVideoTexture.getId());
                closeParams.addRule(6, this.mVideoTexture.getId());
                closeParams.addRule(7, this.mVideoTexture.getId());
                break;
            }
        }
        this.mCtaButton.setLayoutParams((ViewGroup.LayoutParams)ctaParams);
        this.mPrivacyInformationIcon.setLayoutParams((ViewGroup.LayoutParams)privacyInformationIconParams);
        this.mCloseControl.setLayoutParams((ViewGroup.LayoutParams)closeParams);
    }

    @Deprecated
    @VisibleForTesting
    ImageView getCtaButton() {
        return this.mCtaButton;
    }

    @VisibleForTesting
    static class LoadingBackground
    extends Drawable {
        @NonNull
        private final RectF mButtonRect;
        @NonNull
        private final Paint mPaint;
        @VisibleForTesting
        final int mCornerRadiusPx;

        LoadingBackground(@NonNull Context context) {
            this(context, new RectF(), new Paint());
        }

        LoadingBackground(@NonNull Context context, @NonNull RectF rectF, @NonNull Paint paint) {
            Preconditions.checkNotNull((Object)context);
            Preconditions.checkNotNull((Object)rectF);
            Preconditions.checkNotNull((Object)paint);
            this.mButtonRect = rectF;
            this.mPaint = paint;
            this.mPaint.setColor(-16777216);
            this.mPaint.setAlpha(128);
            this.mPaint.setAntiAlias(true);
            this.mCornerRadiusPx = Dips.asIntPixels((float)5.0f, (Context)context);
        }

        public void draw(Canvas canvas) {
            this.mButtonRect.set(this.getBounds());
            canvas.drawRoundRect(this.mButtonRect, (float)this.mCornerRadiusPx, (float)this.mCornerRadiusPx, this.mPaint);
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf) {
        }

        public int getOpacity() {
            return 0;
        }
    }

    public static enum Mode {
        LOADING,
        PLAYING,
        PAUSED,
        FINISHED;

    }
}

